(in-package :ga)

;;; ==========================================================================
;;; GA MAIN DIALOG
;;; ==========================================================================

(defun ga ()
     (setq pail-lib::*ga-module-loaded* t)
     (in-package :ga)
     (create-ga-window)
     (set-ga-menubar)
     ; (set-help-ga)
     )
 
(defun set-help-ga ()
  (set-pail-help :general "ga:help:ga-main-help.gen"
                 :technical "ga:help:ga-main-help.tec"))


(defun quit-ga ()
     (remove-from-window-menu (object-name *ga-main-window*))
     (window-close *ga-main-window*)
     (setq pail-lib::*ga-module-loaded* nil)
     (make-available :ga)
     (select-window pail-lib::*pail-main-window*)
     (in-package :pail-lib))



(defun create-ga-window ()
      (let* ((*number-of-buttons* 4)           
              (box (clipping-box *lisp-main-window*))
              (h-indent (round (* 0.2 (box-width box))))
              (v-indent (round (* 0.2 (- (box-height box) 20))))
              (h-size (- (box-width box) (* 2 h-indent)))
              (button-width (round (/ h-size *number-of-buttons*)))
                (button-height 25)
                (out-dialog nil)
              (height (box-height (clipping-box *lisp-main-window*)))
              (width (box-width (clipping-box *lisp-main-window*))))
          (unless *ga-main-window*
              (setq *ga-main-window*
                   (open-dialog ()
                        'ga-main-dialog *lisp-main-window* :pop-up-p nil
                        :title "GA Main" :name ':ga-main
                        :pane-class 'ga-bitmap-pane
                        :background-color (make-rgb :red 0 :green 128 :blue 128) 
                        :window-exterior (clipping-box *lisp-main-window*))))
         (add-to-window-menu
               (stream-title *ga-main-window*)
               (object-name *ga-main-window*))
          (setq *out-dialog*
            (open-dialog
                  (list
                           (make-dialog-item :widget 'button
                                 :title "Parameters"
                                  :available-p t
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (ga-parameter))
                                 :box (make-box
                                       0
                                       0
                                       button-width
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Options"
                                 :name ':gaoptions
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (ga-options))
                                 :box (make-box
                                       (round (/ (- (box-width (window-interior *ga-main-window*)) (* 2 h-indent)) 4))
                                       0
                                       (* 2 (round (/ (- (box-width (window-interior *ga-main-window*)) (* 2 h-indent)) 4)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Start"
                                 :name ':gastart
                                 :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (ga-start))
                                 :box (make-box
                                       (* 2 (round (/ (- (box-width (window-interior *ga-main-window*)) (* 2 h-indent)) 4)))
                                       0
                                       (* 3 (round (/ (- (box-width (window-interior *ga-main-window*)) (* 2 h-indent)) 4)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Function"
                                 :name ':gafunction
                                 :available-p t
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (ga-function))
                                 :box (make-box
                                       (* 3 (round (/ (- (box-width (window-interior *ga-main-window*)) (* 2 h-indent)) 4)))
                                       0
                                       (- (box-width (window-interior *ga-main-window*)) (* 2 h-indent))
                                       button-height)))
                  'dialog *ga-main-window*
                  :pop-up-p nil
                  :title "GA: Output"
                  :user-closable nil
                  :user-shrinkable t
                  :user-resizable nil
                  :user-scrollable nil
                  :user-movable t
                  :window-border :dialog-box
                  :window-interior
                  (make-box 
                         h-indent 
                         v-indent
                         (- (box-width (window-interior *ga-main-window*)) h-indent)
                         (- (box-height (window-interior *ga-main-window*)) v-indent)))))
         (setq *ga-output-window*
               (open-stream 'ga-fred-window *out-dialog* :output
                     :title "Genetic Algorithms"
                     :user-closable nil :user-resizable nil
                     :user-scrollable t :user-movable nil :user-shrinkable nil 
                     :font (make-font :modern nil 14)
                     :name ':ga-output
                     :window-exterior
                     (make-box
                             0 25
                             (box-width (visible-box *out-dialog*))
                             (box-height (visible-box *out-dialog*))))))

(defun ga-start ()
     (setq *current-generation* nil)
     (open-monitor)
     (start-evolving))

(defun ga-parameter ()
     (ga-parameter-dialog))

(defun ga-options ()
     (fitness-parameter-dialog))

(defun ga-function ()
     (select-fitness-function))

(defvar *ga-file-menu* nil)
     
(defun ga-new ()
     (:new *ga-main-window*))

(defun ga-open ()
      (pail-open *ga-main-window*))                  
             
(defun ga-save ()
      (pail-save *ga-main-window*))                  
             
(defun ga-save-as ()
      (pail-save-as *ga-main-window*))         

(defun ga-close ()
     (let ((window (front-window *ga-main-window*)))
     (:close window)))

(defun ga-print ()
     (:print (front-window *ga-main-window*)))


(defparameter *ga-file-menu*
     (make-menu-item :title "~File" :value
           (open-menu 
                (list 
                   (make-menu-item :title "~New"
                         :value 'ga-new :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\N))
                   (make-menu-item :title "~Open"
                         :value 'ga-open :available-p t 
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\O))
                   (make-menu-item :title "~Close"
                        :value 'ga-close ;;OKKKIO extremly dangerous
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "Load Function..."
                         :value 'ga-load-function :available-p t 
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "~Save"
                         :value 'ga-save 
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\S))
                  (make-menu-item :title "Save ~As"
                        :value 'ga-save-as
                        :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "~Print"
                         :value 'ga-print
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\P))
                   menu-separator
                   (make-menu-item :name :help :title "~Help"
                         :value 'ga-file-help
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\H))
                   (make-menu-item :title "E~xit from GA"
                         :value 'quit-ga :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\X)))
                'pop-up-menu *lisp-main-window* :name '*ga-file-menu* :title '"" 
                :selection-function 'funcall-menu-item)))

(defun ga-load-function ()
     (load-fitness-function))
     
;(defvar *verbose-mode* t)

(defparameter *ga-parameter-menu*
     (make-menu-item :title "F~unction" :value
           (open-menu 
                (list 
                   (make-menu-item :title "~New"
                         :value 'ga-new :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\N))
                   (make-menu-item
                         :title "Select Function..."
                         :value 'ga-function :available-p t
                         :selected-p nil :font nil )
                   (make-menu-item
                         :title "Load Function..."
                         :value 'load-fitness-function :available-p t
                         :selected-p nil :font nil)
                   (make-menu-item
                         :title "Set Fitness Options..."
                         :value 'fitness-parameter-dialog :available-p t
                         :selected-p nil :font nil))
                'pop-up-menu *lisp-main-window* :name '*ga-parameter-menu* :title '"" 
                 :selection-function 'funcall-menu-item)))
                                         
                           
(defparameter *ga-main-menu*
     (make-menu-item :title "~Evolve" :value
           (open-menu 
                (list 
                   (make-menu-item
                         :title "Start Evolution..."
                         :value 'ga-start-evolution :available-p t
                         :selected-p nil :font nil )
                   (make-menu-item
                         :title "Interrupt Evolution"
                         :value 'ga-interrupt :available-p t
                         :selected-p nil :font nil)
                   (make-menu-item
                         :title "Continue Evolution"
                         :value 'ga-continue :available-p t
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item
                         :title "Analyze Chromosomes..."
                         :value 'ga-analyzec :available-p nil
                         :selected-p nil :font nil)
                   (make-menu-item
                         :title "Genetic Parameters..."
                         :value 'ga-parmeter-dialog :available-p nil
                         :selected-p nil :font nil)
                   (make-menu-item
                         :title "Environment Info..."
                         :value 'display-environment :available-p nil
                         :selected-p nil :font nil))
                'pop-up-menu *lisp-main-window* :name '*ga-main-menu* :title '"" 
                :selection-function 'funcall-menu-item)))

(defun ga-start-evolution ()
     (setq *current-generation* nil)
     (open-monitor)
     (eval-enqueue
      '(start-evolving)))
                                         
(defun ga-interrupt ()
     (setq *proceed* nil))
                                         
(defun ga-continue
      (open-monitor)
     (start-evolving))

(defun ga-analyzec ()
 (open-analyze-display 0))


(defvar *ga-demo-menu* nil)

(setq *ga-demo-menu*
     (make-menu-item :title "~Demos" :value
           (open-menu 
                (list 
                   (make-menu-item :title "Demo 1"
                         :available-p t
                         :value 'demo-1)
                   )
                'pop-up-menu *lisp-main-window* :name '*ga-demo-menu* :title '"" 
                :selection-function 'funcall-menu-item)))

(defun demo-1 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-1))




                                                   
(defvar *ga-menubar* nil)

(defun set-ga-menubar ()
     (clean-up-menubar)
         (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Tools
                :value *pail-tool-menu*))
     (add-to-menu *lisp-menu-bar*
          *ga-file-menu*)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Edit
                :value *pail-edit-menu*))
     (add-to-menu *lisp-menu-bar*
          *ga-parameter-menu*)
     (add-to-menu *lisp-menu-bar*
          *ga-main-menu*)
     (add-to-menu *lisp-menu-bar*
          *ga-demo-menu*)
     (add-to-menu *lisp-menu-bar*
          *pail-window-menu*)  
     )

