(in-package :ga)

;;; ==========================================================================
;;; GA PARAMETER DIALOG
;;; ==========================================================================

(defvar *ga-dialog* nil)

(defclass ga-parameter (ga-dialog) ())

(defparameter *ga-dialog* nil)
(defun ga-parameter-dialog ()
   (setq *ga-dialog* nil) ;;; questo e' acking!!!!!!!!!
  (if *ga-dialog*
    (select-window *ga-dialog*)
    (setq *ga-dialog*
            (open-dialog 
               (list 
                  (make-dialog-item :widget 'button :groupstart nil 
                     :tabstop nil :box #.(make-box 40 200 120 225) 
                     :font (make-font nil :arial 16 '(:bold)) :name 
                     :ga-help :title "Help")
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 148 280 172) :value *generations-to-evolve*
                     :font (make-font nil :courier\ new 16 nil) :name 
                     :ga-gen-evolve)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 108 280 132) :value *mutation-probability*
                     :font (make-font nil :courier\ new 16 nil) :name 
                     :mutation-prob)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 68 280 92) :value *crossover-probability*
                      :font (make-font nil :courier\ new 16 nil) :name 
                     :crossover-prob)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 28 280 52) :value *population-size*
                      :font (make-font nil :courier\ new 16 nil) :name 
                     :pop-size)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 150 200 170) :value 
                     "Generations to Evolve" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :proportion-select)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 110 200 130) :value 
                     "Mutation Probability" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :mutation-p)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 70 200 90) :value 
                     "Cross-over Probability" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :crossover-p)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 30 200 50) :value 
                     "Population Size" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :ga-period)
                  (make-dialog-item :widget 'default-button :groupstart nil 
                     :tabstop nil :set-value-fn 'save-ga-parameters 
                     :box #.(make-box 200 200 280 225) :font 
                     (make-font nil :arial 16 '(:bold)) :name :ga-ok 
                     :title "OK")
                  )
               'dialog *lisp-main-window* :name :ga-parameters
                   :title "Genetic Parameters"
                   :font (make-font :swiss :system 20 '(:bold))
               :user-movable t :user-resizable nil :user-closable nil
               :user-shrinkable nil :user-scrollable nil 
                  :window-border :dialog-box
               :background-color (make-rgb :red 0 :green 128 :blue 128) 
               :pop-up-p nil :visible-box #.(make-box 0 0 315 240)))))
          


(defun save-ga-parameters (widget new-value old-value)
      (setf *generations-to-evolve*
          (dialog-item-value (nth 1 (dialog-items *ga-dialog*))))
      (setf *crossover-probability*
          (dialog-item-value (nth 3 (dialog-items *ga-dialog*))))
      (setf *mutation-probability*
          (dialog-item-value (nth 2 (dialog-items *ga-dialog*))))
      (setf *population-size*
          (dialog-item-value (nth 4 (dialog-items *ga-dialog*))))
     (close *ga-dialog*)
   
   ; (setq *ga-dialog* nil)
    ; (set-menu-after-step)
     )   

(defun change-ga-parameter  (widget new-value old-value)
       (set-dialog-item-value widget (eval new-value)))


(defun setup-globals (from-this-object)
  (setq *current-generation* nil)
  (setf *fitness-function* (fitness-function from-this-object))
  (setf *parameter* (nparameter from-this-object))
  (setf *bits-per-parameter* (bits-per-parameter from-this-object))
  (setf *lower-bound* (lower-bound from-this-object))
  (setf *upper-bound* (upper-bound from-this-object))
  (setf *precision* (expt 2 (bits-per-parameter from-this-object)))
  (setf *max-allele* (* *bits-per-parameter* *parameter*))
  (setf *itervall-length* (- *upper-bound* *lower-bound*))
  (setf *gray-coding* (gray-coded from-this-object)))


(defun fitness-parameter-dialog ()
  (set-pail-help 
   :general "ga:help:ga-options-help.gen"
   :gen-title "GA: Options Help")
  (modal-dialog
   (make-instance   'ga-option
    :window-title "GA Options"
    :view-subviews
    (list (make-instance 'check-box-dialog-item
            :dialog-item-text "Verbose Output"
            :dialog-item-action #'(lambda (item)
                                    (declare (ignore item))
                                    (setq *verbose-mode* (not *verbose-mode*)))
            :check-box-checked-p *verbose-mode*)
          (make-instance 'check-box-dialog-item
            :dialog-item-text           "   Normalize Fitness"
            :dialog-item-action         #'(lambda (item)
                                            (setf *normalize-fitness-p*
                                                  (check-box-checked-p item)))
            :check-box-checked-p *normalize-fitness-p*)
          (make-instance 'check-box-dialog-item
            :dialog-item-text "   Scale Fitness"
            :dialog-item-action #'(lambda (item)
                                    (setf *scale-fitness-p*
                                          (check-box-checked-p item)))
            :check-box-checked-p *scale-fitness-p*)
          (make-instance 'check-box-dialog-item
            :dialog-item-text "   Allow Mutations"
            :dialog-item-action #'(lambda (item)
                                    (setf *mutations-p*
                                          (check-box-checked-p item)))
            :check-box-checked-p *mutations-p*)))))


 
;;; ==========================================================================
;;; FITNESS FUNCTION DIALOG
;;; ==========================================================================


(defun select-fitness-function ()
     (let ((fun (select-item-from-list
                        *lisp-main-window*
                        (printable-list-of-functions *known-functions*)
                        "Please, select a function: "
                        )))
         (when fun
              (setq *current-function* (find-ffunction fun *known-functions*))
             (fitness-function-dialog *current-function*)
              (setup-globals *current-function*)
               (set-dialog-item-available-p
                (find-named-object ':gastart *out-dialog*) t)
              )))

(defun printable-list-of-functions (lista)
     (let ((result nil))
     (dolist (item lista )
          (push (fitness-function item) result))
         (reverse result)))


(defun find-ffunction (fun lista)
     (dolist (item lista )
         (when (eq (fitness-function item) fun)
              (return item))))

(defun load-fitness-function ()
  (let ((file
           (pc::pop-up-load-file-dialog
                 *ga-main-window*
                 nil
                 "Load Fitness Function"
                 "Load Fitness Function"
                 "*.*"
                 (concatenate 'string *pail-directory*
                                                    "ga\\funs\\")
                 :open)))
    (when file (load file))))


(defun new-fitness-function (f &optional (aux (make-instance 'ga-function :fitness-function f)))
  (push aux *known-functions*)
  (fitness-function-dialog
   (setq *current-function* aux))
  (setup-globals *current-function*)
  (dialog-item-enable (view-named 'start *ga-main-window*)))


(defun sf-print-function (a b)
  (princ (fitness-function a) b))

(defvar *ff-dialog* nil)

(defclass ga-fnct (ga-info)())

(defmethod initialize-instance ((g ga-fnct) &rest rest)
    (call-next-method)
  (set-dialog-item-text (elt (view-subviews g) 0) "Fitness Function Parameters"))



(defun display-environment ()
  (modal-dialog 
   (make-instance 'ga-info
     :view-subviews
     (list (make-instance 'static-text-dialog-item
             :dialog-item-text "Function")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *current-function*
                                 (write-to-string (fitness-function *current-function*))
                                 "Not specified"))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Normalize fittness")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *normalize-fitness-p* "yes" "no"))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Scale fittness")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *scale-fitness-p* "yes" "no"))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Allow mutations")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *mutations-p* "yes" "no"))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Mutation Probability")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (write-to-string *mutation-probability*))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Crossover Probability")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (write-to-string *crossover-probability*))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Population Size")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (write-to-string *population-size*))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Nr. of Generations")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (write-to-string *generations-to-evolve*))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Verbose")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *verbose-mode* "yes" "no"))))))


;;; ==========================================================================
;;; 
;;; ==========================================================================

(defun start-evolving ()
  (close-all-anal-displ)
;;;   (dialog-item-enable (view-named 'stop *ga-main-window*))
;;;   (dialog-item-disable (view-named 'start *ga-main-window*))
;;;   (dialog-item-disable (view-named 'analyze *ga-main-window*))
;;;   (dialog-item-disable (view-named 'continue *ga-main-window*))
  (format *ga-output-window* "~%Evolving ~a generations~%" *generations-to-evolve*);)
  (unless *current-generation*
    (setf *current-generation* (make-instance 'population :size *population-size*)))
  (setf *running* t 
        *current-generation*
        (evolve *current-generation* :generations *generations-to-evolve*)
        *running* nil)
;;;      (dialog-item-enable (view-named 'start *ga-main-window*))
;;;      (dialog-item-enable (view-named 'analyze *ga-main-window*))
;;;      (dialog-item-enable (view-named 'continue *ga-main-window*))
;;;      (dialog-item-disable (view-named 'stop *ga-main-window*))
  (setf *proceed* t))




