;;; -*- Mode: LISP; Package: pail-help; Syntax: Common-lisp; -*-


(export '(set-help
          help-window
          gen-help-key-handler
          tec-help-key-handler
          open-help-file))
          
(defclass help-window (fred-window)
  ())

(defmethod window-needs-saving-p ((h help-window))
  nil)

(defmethod view-key-event-handler :around ((h help-window)  nulla)
  (declare (ignore nulla))
  nil)

(defvar *default-comtab* *comtab*)

(defvar *current-gen-help-file* (concatenate 'string *pail-directory*
                                                   "help\\mn-help.gen"))

(defvar *current-gen-window-title* "PAIL: General Help")

(defvar *current-tec-help-file* (concatenate 'string *pail-directory*
                                                  "help\\mn-help.tec"))

(defvar *current-tec-window-title* "PAIL: Technical Help")

(defun gen-help-key-handler ()
  (def-fred-command (:function #\1) open-gen-help-file)
  (def-fred-command (#\help) open-gen-help-file))      

(defun tec-help-key-handler ()
        (def-fred-command (:function #\2) open-tec-help-file))


(defun open-gen-help-file (&rest nulla)
  (declare (ignore nulla))
  (open-help-file *current-gen-help-file* *current-gen-window-title*))

(defun open-tec-help-file (&rest nulla)
  (declare (ignore nulla))
  (open-help-file *current-tec-help-file* *current-tec-window-title*))

(defun open-help-file (h-file h-window-name)
  (make-instance 'help-window
                 :filename h-file
                 :view-size #@(350 250)
                 :direction :output
                 :grow-icon-p t
                 :window-title h-window-name))



(defun set-help (&key (general nil) (technical nil))
  (when general (setq *current-gen-help-file* (concatenate 'string *pail-directory* general)))
  (if technical (setq *current-tec-help-file* (concatenate 'string *pail-directory* technical))
      (setq *current-tec-help-file* (concatenate 'string *pail-directory*
                                             "help\\mn-help.tec"))))