;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-ex1.cl
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)

(setf *readable* t)

(defun start-demo-1 ()
      (when 
               (create-demo-dialog  
                :window-title "ID3 Demos"
                :title "Inductive Learning with ID3"
                :subtitle "A First Demo"
                :helpfile "id3\\help\\id3-d1.asc"
                :window *id3-main-window*)
             (progn
                  (setq *id3-demo-running* t)
                  (catch 'stop-demo (main-demo-1))
                  (setq *id3-demo-running* nil))))


(defun main-demo-1 ()
      (format-demo "This is the first ID3 demo

")
      (demo-loop)
      (when *current-table-editor*
             (when (windowp *current-table-editor*) 
                    (close-table)))
      (setq *current-table*
            (make-table
                   :table-name "Exemple with a clash"
                   :attributes '(profit      age         competition type)
                   :rows      '((down        old         no          software)
                                      (down        midlife     yes         software)
                                      (up          midlife     no          hardware)
                                      (down        old         no          hardware)
                                      (up          new         no          hardware)
                                      (up          new         no          software)
                                      (up          midlife     no          software)
                                      (up          new         yes         software)
                                      (down        midlife     yes         hardware)
                                      (down        old         yes         software))))
      (set-dialog-item-value
            (find-named-object ':table-input *id3-message-window*)
            (table-name *current-table*))
      (setq *current-table-editor*
            (table-to-editor *current-table* *id3-main-window*
                 (list 'add-example 'delete-example
                    'add-attribute 'delete-attribute 'close-table)))
      (set-menu-after-load)
      (format-demo "In the <Table Editor> window you can see a table
of values describing several companies.

")
      (demo-loop)
      (setq *target-attribute* (car (attributes *current-table*)))
      (set-menu-item-available-p
       (find-named-object ':classify *id3-classify-menu*) t)
      (set-dialog-item-value
            (find-named-object ':target-attribute *id3-message-window*)
            *target-attribute*)
      (format-demo "Now we will try to find rules in data.
Target attribute for classifying is diplayed in
ID3 Main Window under the heading <Target attribute>

")
      (demo-loop)
      (start-classify)
      (format-demo "Rules can be derived from this decision tree.
You can see these rules in the <Rules> window.
The descision tree organizes the gained
knowledge so that it is optimal for a query.

")
      (demo-loop)	
      (get-rules)
      (demo-loop)
      (format-demo "We are now able to query the decision
tree. You will do this by answering the 
following questions. The answer will be
displayed in the ID3 Main window

")
      (id3-query)
      (close-table)
      (format-demo "End of demo."))

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
