;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-ex2.cl
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)


(setf *readable* t)

(defun start-demo-2 ()
      (when 
               (create-demo-dialog  
                :window-title "ID3 Demos"
                :title "Inductive Learning with ID3"
                :subtitle "A Second Demo"
                :helpfile "id3\\help\\id3-d2.asc"
                :window *id3-main-window*)
             (progn
                  (setq *id3-demo-running* t)
                  (catch 'stop-demo (main-demo-2))
                  (setq *id3-demo-running* nil))))

(defun main-demo-2 ()
      (format-demo "This is the second ID3 demo

")
      (demo-loop)
      (when *current-table-editor*
             (when (windowp *current-table-editor*) 
                    (close-table)))
      (setq *current-table*
           (make-table
                  :name "Example with a clash"
             :attributes '(profit      age         competition type)
             :rows      '((down        old         no          software)
                          (down        midlife     yes         software)
                          (up          midlife     no          hardware)
                          (down        old         no          hardware)
                          (up          new         no          hardware)
                          (up          new         no          software)
                          (up          midlife     no          software)
                          (up          new         yes         software)
                          (down        midlife     no          hardware)
                          (down        old         yes         software))))
      (set-dialog-item-value
            (find-named-object ':table-input *id3-message-window*)
            (table-name *current-table*))
      (setq *current-table-editor*
            (table-to-editor *current-table* *id3-main-window*
                 (list 'add-example 'delete-example
                    'add-attribute 'delete-attribute 'close-table)))
      (set-menu-after-load)
      (format-demo "In the <Table Editor> window you can see a table
of values describing several companies.

")
      (demo-loop)
      (format-demo "In the <Table Editor> window you can see the table
of examples. These are the examples of demo 1
except that the second last has a 'no' for
competition. This clashes with example 3

")
      (demo-loop)
      (setq *target-attribute* (car (attributes *current-table*)))
      (set-menu-item-available-p
       (find-named-object ':classify *id3-classify-menu*) t)
      (set-dialog-item-value
            (find-named-object ':target-attribute *id3-message-window*)
            *target-attribute*)
      (format-demo "Now we are trying to find rules in data.
Target attribute for classifying is PROFIT

")
      (demo-loop)
      (start-classify)
      (demo-loop)
      (close-table)
      (format-demo "Experiment with 'Accept Clashes' flag!
End of demo."))
 


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
