;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-demo3.lisp
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)


(defun start-demo-3 ()
  (catch 'stop-demo
    (let ((current-table
           (make-instance 'table
             :attributes '(profit      age         competition type)
	      :rows      '((down        old         no          software)
			   (down        midlife     yes         software)
			   (up          midlife     no          hardware)
			   (down        old         no          hardware)
			   (up          new         no          hardware)
			   (up          new         no          software)
			   (up          midlife     no          software)
			   (up          new         yes         software)
			   (down        midlife     yes         hardware)
			   (down        old         yes         software))))
          (demo-windows nil))
      
      (id3)
    (create-demo-dialog :window-title "ID3: Third Demo"
                          :title "ID3"
                          :subtitle "Ordinary Example"
                          :helpfile "id3:help:id3-demo3.asc")
      (format-demo "This is the third ID3 demo")
      (demo-loop)
      (clear-info)
      (setq *current-table* current-table)
      (set-dialog-item-text (aref (view-subviews *id3-main-window*) 8)
                      "Ordinary Example")
      (setq *target-attribute* 'COMPETITION)
      (set-dialog-item-text (aref (view-subviews *id3-main-window*) 7)
                            (write-to-string *target-attribute*))
      (push (setq *current-table-editor* (table-to-editor current-table)) demo-windows)
      (format-demo "In the <Examples> window you can see the table
of examples. These are the examples of demo 1.
We now try to classify an other attribute.")
      (demo-loop)
      (format-demo "Now trying to find rules in data.
The target attribute is PROFIT")
      (start-classify)
      (demo-loop)
      (format-demo "The decision tree depends on the target
attribute. The usability of the data
depends on what you want to classify!")
      (demo-loop)
      (format-demo "End of demo.")
      (dolist (window demo-windows)
        (window-close window)))))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
