;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-demo4.lisp
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)

(defun start-demo-4 ()
  (catch 'stop-demo
    (let ((current-table
           (make-instance 'table
             :attributes '(profit      age         competition type)
             :rows      '((down        *           no          software)
                          (down        midlife     yes         software)
                          (up          midlife     no          hardware)
                          (down        old         *           *)
                          (up          new         no          hardware)
                          (up          new         no          software)
			   (up          midlife     no          software)
			   (up          new         yes         software)
			   (down        midlife     yes         hardware)
			   (down        old         yes         software))))
          (demo-windows nil))
      (id3)
    (create-demo-dialog :window-title "ID3: Fourth Demo"
                          :title "ID3"
                          :subtitle "Example with Wildcards"
                          :helpfile "id3:help:id3-demo4.asc")
      (format-demo "This is the fourth ID3 demo")
      (demo-loop)
      (clear-info)
      (setq *current-table* current-table)
      (set-dialog-item-text (aref (view-subviews *id3-main-window*) 8)
                      "Example with Wildcards")
      (setq *target-attribute* 'PROFIT)
      (set-dialog-item-text (aref (view-subviews *id3-main-window*) 7)
                            (write-to-string *target-attribute*))
      (push (setq *current-table-editor* (table-to-editor current-table)) demo-windows)
      (format-demo "In the <Examples> window you can see the table
of examples with wildcards.")
      (demo-loop)
      (format-demo "Now expanding wildcards ...")
      (setf *current-table* (expand-wildcards *current-table*))
      (push (setq *current-table-editor* (table-to-editor current-table)) demo-windows)
      (format-demo "In the <Examples> window you can see the
new table without wildcards.")
      (demo-loop)
      (format-demo "
So many lines increases the chance for a clash,
but we will try to classify.")
      (start-classify)
      (demo-loop)
      (format-demo "End of demo.")
      (dolist (window demo-windows)
        (window-close window)))))




;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
