;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-ex5.cl
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)

(defun dialog-5 (text-disp table-disp rule-disp)
  (let ((exm (make-table
	      :attributes '(profit      age         competition type)
	      :rows      '((down        20          no          software)
			   (down        8           yes         software)
			   (up          5           no          hardware)
			   (down        18          no          hardware)
			   (up          1           no          hardware)
			   (up          2           no          software)
			   (up          6           no          software)
			   (up          3           yes         software)
			   (down        5           yes         hardware)
			   (down        15          yes         software))))
	(newexm nil)
	(attribute 'profit)
	(browse1 nil)
	(*readable* t)
	(dtree nil))
    (deactivate-display rule-disp)
    (format-display table-disp "~a" exm)
    (format-display text-disp "In the <Examples> window you can see a table")
    (format-display text-disp "~&of examples. Note that the values for the")
    (format-display text-disp "~&attribute age are numeric.")
    (when (wait)
      (format-display text-disp "~%Now trying to find rules in data.")
      (format-display text-disp "~%Target attribute is ~a ..." attribute)
      (setf dtree (classify attribute exm))
      (if (and (not *accept-clashes*)
	       (plusp (clash-p exm attribute)))
	  (progn
	    (format-display text-disp "~%Generated a decision tree.")
	    (format-display text-disp "~&(see <Decision tree> window)")
	    (format-display text-disp "~&There were clashes!"))
	(progn
	  (format-display text-disp "~%Generated a decision tree.")
	  (format-display text-disp "~&(see <Decision tree> window)")))
      (setf browse1 (make-instance 'browser
		      :starting-tree dtree
		      :title "ID3:Decision tree"
		      :left 500
		      :bottom 0))
      (setf (bottom browse1) (- 341 (height browse1)))
      (when (wait)
	(format-display text-disp "~%The problem seems that each number")
	(format-display text-disp "~&is a distict value.  Instead we cluster")
	(format-display text-disp "~&the values into three groups,")
	(format-display text-disp "~&low medium and high.")
	(setf newexm (cluster  (copy exm) :clusters 3 :attribute 'age))
	(when (wait)
	  (format-display text-disp "~%You see the new table in the <Examples>")
	  (format-display text-disp "~&window. Numbers have been replaced!")
	  (format-display table-disp "~a" newexm)
	  (when (wait)
	    (setf dtree (classify attribute newexm))
	    (if (and (not *accept-clashes*)
		     (plusp (clash-p newexm attribute)))
		(progn
		  (format-display text-disp "~%Generated a decision tree.")
		  (format-display text-disp "~&(see <Decision tree> window)")
		  (format-display text-disp "~&There were clashes!"))
	      (progn
		(format-display text-disp "~%Generated a decision tree.")
		(format-display text-disp "~&(see <Decision tree> window)")))
	    (setf browse (make-instance 'browser
			   :starting-tree dtree
			   :title "ID3:Decision tree"
			   :left 500
			   :bottom 0))
	    (setf (bottom (display browse)) (- 341 (height browse)))
	    (when (wait)
	      (close-display (display browse1))
	      (format-display text-disp "~%End of demo."))))))))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
