
(in-package :id3)

(defvar *id3-main-window* nil)
(defvar *id3-output-window* nil)
(defvar *id3-message-window* nil)
(defvar *out-dialog*)
(defvar *current-table* nil)
(defvar *current-table-file* nil)
(defvar *current-table-title* "No name")
(defvar *current-decision-tree* nil)
(defvar *current-table-editor* nil)

(defvar *target-attribute* nil)
(defvar *verbose* nil)
(defvar *clashes* nil)
(defvar *accept-clashes* nil)
(defvar *open-id3-windows* nil)
(defvar *list-of-tables* nil)
(defvar *opened-trees* nil)
(defvar *opened-rules* nil)


(defclass id3-dialog (dialog)
       ())

(defclass id3-rule-window (text-edit-window)
       ())



(defmethod initialize-instance :after ((id id3-dialog) &rest whatever)
      (declare (ignore whatever))
      (push id *open-id3-windows*))

(defmethod window-close :after ((id id3-dialog))
      (delete id *open-id3-windows*))



(defclass id3-table-editor (table-editor id3-dialog)
       ())



(defclass id3-main-dialog (id3-dialog)
       ())

(defmethod bring-window-to-front :after ((id id3-main-dialog))
        (in-package :id3)
        (set-id3-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Induction with ID3 module"))

(defmethod window-close ((imd id3-main-dialog))
      (when (yes-or-no-p "Do you really want to
quit the ID3 module")
          (remove-from-window-menu (object-name *id3-main-window*))
          (close imd)
          (setf imd nil)
          (quit-id3)))

(defmethod bring-window-to-front :after ((id id3-main-dialog))
        (in-package :id3)
        (set-id3-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Induction Trees module"))

(defclass id3-browser (browser) 
       ((target
              :initarg :target
              :initform nil
              :accessor target)))



(defmethod select-window :after ((b id3-browser) &optional box)
      (setq *current-decision-tree* (starting-tree b))
      (setq *target-attribute* (target b))
      (set-dialog-item-value
            (find-named-object ':tree-output *id3-message-window*)
            (target b)))

