;;; -*- Mode: LISP; Package: id3; Syntax: Common-lisp; -*-
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atn-init.lisp
;;;  Desc: general user interface for the  ID3 tool
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4. april 1992 - PC
;;; Author(s):  Paolo Cattaneo
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; 
;;; 
;;; --------------------------------------------------------------------------

(in-package :id3)



(defun id3 ()
      (setq pail-lib::*id3-module-loaded* t)
      (in-package :id3)
      (create-id3-window)
      (set-id3-menubar)
;      (set-help :general "id3\\help\\id3-desc.asc")
      )



(defun create-id3-window ()
      (let* ((*number-of-buttons* 4)           
                (box (clipping-box *lisp-main-window*))
                (h-indent (round (* 0.2 (box-width box))))
                (v-indent (round (* 0.2 (- (box-height box) 20))))
                (h-size (- (box-width box) (* 2 h-indent)))
                (button-width (round (/ h-size *number-of-buttons*)))
                (button-height 25)
                (out-dialog nil)
              (height (box-height (clipping-box *lisp-main-window*)))
              (width (box-width (clipping-box *lisp-main-window*))))
          (setq *id3-main-window*
                (open-dialog ()
                      'id3-main-dialog *lisp-main-window* :pop-up-p nil
                      :title "ID3 Main" :name ':id3-main
                      :background-color (make-rgb :red 0 :green 128 :blue 128) 
                      :window-exterior (clipping-box *lisp-main-window*)))
              (add-to-window-menu
                   (stream-title *id3-main-window*)
                   (object-name *id3-main-window*))
          (setq out-dialog (setq *out-dialog*
            (open-dialog
                  (list
                           (make-dialog-item :widget 'button
                                 :title "Help"
                                  :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (bp-help))
                                 :box (make-box
                                       0
                                       0
                                       button-width
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Classify"
                                 :available-p nil
                                 :name ':classify
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (start-classify))
                                 :box (make-box
                                       (round (/ (- (box-width (window-interior *id3-main-window*)) (* 2 h-indent)) 4))
                                       0
                                       (* 2 (round (/ (- (box-width (window-interior *id3-main-window*)) (* 2 h-indent)) 4)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Target Attribute"
                                 :name ':set-target-attribute
                                 :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (set-target-attribute))
                                 :box (make-box
                                       (* 2 (round (/ (- (box-width (window-interior *id3-main-window*)) (* 2 h-indent)) 4)))
                                       0
                                       (* 3 (round (/ (- (box-width (window-interior *id3-main-window*)) (* 2 h-indent)) 4)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Load Table"
                                 :name ':load-table
                                 :available-p t
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (load-table))
                                 :box (make-box
                                       (* 3 (round (/ (- (box-width (window-interior *id3-main-window*)) (* 2 h-indent)) 4)))
                                       0
                                       (- (box-width (window-interior *id3-main-window*)) (* 2 h-indent))
                                       button-height)))
                  'dialog *id3-main-window*
                  :pop-up-p nil
                  :title "ID3: Output"
                  :user-closable nil
                  :user-shrinkable t
                  :user-resizable nil
                  :user-scrollable nil
                  :user-movable t
                  :window-border :dialog-box
                  :window-interior
                  (make-box 
                         h-indent 
                         v-indent 
                         (- (box-width (window-interior *id3-main-window*)) h-indent)
                         (- (box-height (window-interior *id3-main-window*)) v-indent)))))
          (setq *id3-output-window*
              (open-stream 'text-edit-window *out-dialog* :output
                   :user-closable nil :user-resizable nil :user-shrinkable nil
                    :user-scrollable t :user-movable nil
                   :font (make-font :modern nil 14)
                   :name ':id3-output
                   :window-interior (make-box
                             0 25
                             (box-width (visible-box out-dialog))
                             (- (box-height (visible-box out-dialog)) 110))))
          (setq *id3-message-window*
                (open-dialog
                      (list
                         (make-dialog-item :widget 'static-text
                                :value "Target Attribute:"
                                :background-color t
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 20 10 150 30))
                         (make-dialog-item :widget 'static-text
                                :value "ID3 - Tree Output:"
                                :background-color t
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 20 40 150 60))
                         (make-dialog-item :widget 'static-text
                                :value "ID3 - Table Input:"
                                :background-color t
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 20 70 150 90))
                         (make-dialog-item :widget 'static-text
                                :value "Untitled"
                                :name ':target-attribute
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 170 10 540 30))
                         (make-dialog-item :widget 'static-text
                                :value "Untitled"
                                :name ':tree-output
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 170 40 540 60))
                         (make-dialog-item :widget 'static-text
                                :value *current-table-title*
                                :name ':table-input
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 170 70 540 90)))
                      'dialog *out-dialog* :pop-up-p nil
                      :title "Status"
                      :user-closable nil :user-scrollable nil :user-resizable nil
                      :user-shrinkable nil :user-movable nil
                      :window-border :dialog-box
                      :window-exterior
                      (make-box 
                             0 (- (box-height (visible-box out-dialog)) 110)
                             (box-width (visible-box out-dialog))
                             (box-height (visible-box out-dialog)))))))



(defvar *id3-file-menu* nil)

(defun id3-new ()
     (:new *id3-main-window*))


(defun id3-close ()
     (let ((window (front-window *id3-main-window*)))
     (:close window)))

(defun id3-print ()
     (:print (front-window *id3-main-window*)))

(defun id3-open ()
      (:open *id3-main-window*))                  
             
(defun id3-save ()
      (:save *id3-main-window*))                  
             
(defun id3-save-as ()
      (:save-as *id3-main-window*))                

(setq *id3-file-menu*
      (make-menu-item :title "~File" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "~New"
                             :value 'id3-new :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\N))
                      (make-menu-item :title "~Open"
                             :value 'id3-open :available-p t 
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\O))
                      (make-menu-item :title "~Close"
                             :value 'id3-close :available-p t
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "Load Table..."
                             :name ':load-table
                             :value 'load-table :available-p t)
                      (make-menu-item :title "Select Output Tree"
                             :name ':select-output-tree
                             :value 'select-output-tree :available-p nil)
                      menu-separator
                      (make-menu-item :title "~Save"
                             :value 'id3-save :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\S))
                      (make-menu-item :title "Save ~As"
                             :value 'id3-save-as :available-p t
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "~Print"
                             :value 'rbs-print :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\S))
                      menu-separator
                      (make-menu-item :name :help :title "~Help"
                             :value 'id3-file-help :available-p nil
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\H))
                      (make-menu-item :title "E~xit from ID3"
                             :value 'id3-exit :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\X)))
                   'pop-up-menu *lisp-main-window* :name '*atn-file-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))      


(defun id3-exit ()
     (window-close *id3-main-window*))

(defun quit-id3 ()
;;;      (dolist (item *open-id3-windows*)
;;;           (when (windowp item)
;;;                (close item)))
      (setq *current-table* nil)
      (setq *current-table-editor* nil)
      (setq *current-decision-tree* nil)
      (setq *target-attribute* nil)
      (setq *list-of-tables* nil)
      (setq pail-lib::*id3-module-loaded* nil)
      (make-available :id3)
      (select-window pail-lib::*pail-main-window*)
      (in-package :pail-lib))





(defvar *id3-classify-menu* nil)

(setq *id3-classify-menu*
      (make-menu-item :title "~Classify" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "Set Target Attribute"
                             :name ':set-target-attribute
                             :value 'set-target-attribute :available-p nil)
                      (make-menu-item :title "Classify"
                             :name ':classify
                             :value 'start-classify :available-p nil)
                      (make-menu-item :title "Query"
                             :name ':query
                             :value 'id3-query :available-p nil)
                      (make-menu-item :title "Get Rules"
                             :name ':get-rules
                             :value 'get-rules :available-p nil)
                      menu-separator
                      (make-menu-item :title "Verbose Mode"
                             :name ':set-verbose
                             :selected-p *verbose*
                             :value 'set-verbose :available-p t)
                      (make-menu-item :title "Accept Clashes"
                             :name ':accept-clashes
                             :selected-p *accept-clashes*
                             :value 'accept-clashes :available-p t))
                   'pop-up-menu *lisp-main-window* :name '*id3-parser-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))




(defun new-table ()
     (let ((fake-table (make-table
             :table-name "Untitled Table"
             :attributes '()
             :rows      nil)))
     (when *current-table-editor*
          (close-table))         
     (setq *current-table* fake-table)
     (setq *current-table-editor*
                            (table-to-editor *current-table* *id3-main-window*
                                
                                 (list 'add-example 'delete-example
                                         'add-attribute 'delete-attribute 'close-table)
                                (make-position 200 100)))
    ;; (setf (table-needs-saving-p *current-table-editor*) t) ;; NOT TRUE
         ;; a new table is not to be saved
     (setq *current-table-file* "new-tab.tab")
     (set-menu-after-load)))



(defvar *id3-table-editor-menu* nil)

(setq *id3-table-editor-menu*
     (make-menu-item :title "~Table Editor" :value
           (open-menu 
                (list (make-menu-item :title "New Table"
                             :name ':new-table
                             :value 'new-table :available-p t) 
                      (make-menu-item :title "Load Table ..."
                             :name ':load-table
                             :value 'load-table :available-p t)
                      (make-menu-item :title "Save Table As ..."
                             :name ':save-table-as
                             :value 'save-table-as :available-p nil)
                      menu-separator
                      (make-menu-item :title "Add Attribute" 
                             :name ':add-attribute
                             :value 'add-attribute :available-p nil)
                      (make-menu-item :title "Delete Attribute"
                             :name ':delete-attribute
                             :value 'delete-attribute :available-p nil)
                      (make-menu-item :title "Add Example"
                             :name ':add-example
                             :value 'add-example :available-p nil)
                      (make-menu-item :title "Delete Example"
                             :name ':delete-example
                             :value 'delete-example :available-p nil)
                      (make-menu-item :title "Expand Wildcards"
                             :name ':expand-wildcards
                             :value 'menu-expand-wildcards :available-p nil)
                      (make-menu-item :title "Remove Duplication"
                             :name ':remove-duplication
                             :value 'remove-duplication :available-p nil))
                   'pop-up-menu *lisp-main-window* :name '*id3-table-editor-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))


                   



(defvar *id3-demo-menu* nil)
(defvar *demo-in-progress* nil)

(setq *id3-demo-menu*
      (make-menu-item :title "~Demos" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "Demo 1"
                             :value 'demo-1 :available-p t)
                      (make-menu-item :title "Demo 2"
                             :value 'demo-2 :available-p t)
                      (make-menu-item :title "Demo 3"
                             :value 'demo-3 :available-p nil))
                   'pop-up-menu *lisp-main-window* :name '*id3-demo-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))
                   
                                            

(defun demo-1 (&rest nulla)
  (setq *demo-in-progress* t)
  (start-demo-1)
  (setq *demo-in-progress* nil))


(defun demo-2 (&rest nulla)
  (setq *demo-in-progress* t)
  (start-demo-2)
  (setq *demo-in-progress* nil))

(defun demo-3 (&rest nulla)
  (setq *demo-in-progress* t)
  (start-demo-3)
  (setq *demo-in-progress* nil))


                                                   
;; (defvar *lisp-menu-bar* nil)

(defun set-id3-menubar ()
;;;      (setq *lisp-menu-bar*
;;;           (open-stream 'menu-bar *lisp-main-window* :io))
     (clean-up-menubar)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Tools
                :value *pail-tool-menu*))
     (add-to-menu *lisp-menu-bar*
          *id3-file-menu*)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Edit
                :value *pail-edit-menu*))
     (add-to-menu *lisp-menu-bar*
          *id3-classify-menu*)
     (add-to-menu *lisp-menu-bar*
          *id3-table-editor-menu*)
     (add-to-menu *lisp-menu-bar*
          *id3-demo-menu*)
     (add-to-menu *lisp-menu-bar*
          *pail-window-menu*)  
    ; (set-window-menu *id3-main-window* *lisp-menu-bar*)
     )





