

(in-package :id3)



(defun load-table ()
      (let ((file
                 (ask-user-for-existing-pathname
                 "Data Base to Load"
                :stream  *id3-main-window*
                :allowed-types '(("Load ID3 table" . "*.tab")("All Files"  . "*.*"))
                :host  (concatenate 'string *pail-directory* "id3\\tables\\")
                ) ))
          (when file
                 (progn
                      (load file)
                      (setf *current-table* (car *list-of-tables*))
                      (set-dialog-item-value
                            (find-named-object ':table-input *id3-message-window*)
                            (table-name *current-table*))
                      (setq *current-table-editor*
                            (table-to-editor *current-table* *id3-main-window*
                                 (list 'add-example 'delete-example
                                         'add-attribute 'delete-attribute 'close-table)))
                      (setq *current-table-file* (file-namestring file))
                      (set-menu-after-load)))))



(defun close-table ()
      (let ((save (if (table-needs-saving-p *current-table-editor*)
                                 (ask-save-changes *current-table-editor*)
                                 :no)))
          (unless (eql save :cancel)
                (progn
                     (when (eql save :yes)
                            (progn
                                 (setq *current-table* (editor-to-table *current-table-editor*))
                                (save-table-as)
;;;                                  (dump-table-to-file *current-table*
;;;                                        (concatenate 'string *pail-directory* "id3\\tables\\" *current-table-file*))
                                ))
                     (set-dialog-item-value
                           (find-named-object ':target-attribute *id3-message-window*)
                           "Untitled")
                     (set-dialog-item-value
                           (find-named-object ':tree-output *id3-message-window*)
                           "Untitled")
                     (set-dialog-item-value
                           (find-named-object ':table-input *id3-message-window*)
                           "No Table")
                     (dolist (tree *opened-trees*)
                           (when (windowp tree) (close tree)))
                     (setq *opened-trees* nil)
                     (dolist (rules *opened-rules*)
                           (when (windowp rules) (close rules)))
                     (setq *opened-rules* nil)
                     (close *current-table-editor*)
                    (setq *current-table-editor* nil)
                     (set-menu-before-load)))))



(defun select-output-tree ()
      (let (trees tree-target output-tree)
          (dolist (tree *opened-trees*)
                (when (windowp tree)
                       (push (target tree) trees)))
          (setq tree-target
                (select-item-from-list
                      *id3-main-window*
                      trees
                      "Select output tree with target"))
          (when tree-target
                 (progn
                      (dolist (tree *opened-trees*)
                            (when (windowp tree)
                              (when (eql (target tree) tree-target)
                                   (setq output-tree tree))))
                      (select-window output-tree)))))



(defun set-target-attribute ()
      (if (null *current-table*)
         (format-display *id3-output-window* "Sorry, no table defined")
         (progn
              (when (table-needs-saving-p *current-table-editor*)
                     (setq *current-table* (editor-to-table *current-table-editor*)))
              (let ((target-attribute
                           (select-item-from-list
                                 *id3-main-window*
                                 (attributes *current-table*)
                                 "Select target attribute")))
                  (when target-attribute
                         (setq *target-attribute* target-attribute)
                         (set-menu-item-available-p
                              (find-named-object ':classify *id3-classify-menu*) t)
                         (set-dialog-item-available-p
                              (find-named-object ':classify *out-dialog*) t)
                         (set-dialog-item-value
                               (find-named-object ':target-attribute *id3-message-window*)
                               *target-attribute*))))))



(defun start-classify ()
      (cond ((not *current-table*)
                   (format-display *id3-output-window*
                        "No target attribute specified!"))
                  ((not *target-attribute*)
                   (format-display *id3-output-window*
                        "No target attribute specified!"))
                  ((not (member *target-attribute* (attributes *current-table*))) 
                   (format-display *id3-output-window*
                        "Invalid attribute for current table"))
                  (t (when (table-needs-saving-p *current-table-editor*)
                             (setf *current-table* (editor-to-table *current-table-editor*)))
                     (let ((classification nil))
                         (setq classification
                               (setq *current-decision-tree*
                                     (classify *target-attribute* *current-table*)))
                         (format-display *id3-output-window*
                              "~%Generated a decision tree.")
                         (format-display *id3-output-window*
                              "~&(see <Decision tree> window)")
                         (multiple-value-bind (clashes examples)
                                 (clash-p *current-table* *target-attribute*)
                                (format-display *id3-output-window*
                                     (format nil "~&Processed ~a unique example(s)." examples))
                                (when (plusp clashes)
                                       (format-display *id3-output-window*
                                            (format nil "~&There were ~a clash(es) for this target" clashes))
                                       (when *accept-clashes*
                                              (format-display *id3-output-window*
                                                   "~&Clashes were handled"))))
                         (push
                               (open-dialog () 'id3-browser *id3-main-window* :pop-up-p nil
                                     :user-scrollable nil :user-closable nil :user-resizable t
                                     :target *target-attribute*
                                     :title (format nil "ID3 - Browser.  Target: ~A" *target-attribute*)
                                     :starting-tree classification)
                               *opened-trees*)
                         (set-dialog-item-value
                               (find-named-object ':tree-output *id3-message-window*)
                               *target-attribute*)
                         (set-menu-item-available-p
                          (find-named-object ':query *id3-classify-menu*) t)
                         (set-menu-item-available-p
                          (find-named-object ':select-output-tree *id3-file-menu*) t)
                         (set-menu-item-available-p
                          (find-named-object ':get-rules *id3-classify-menu*) t)))))



(defun id3-query ()
      (if (not *current-decision-tree*)
         (format-display *id3-output-window* 
              "No decision tree generated (Classify)")
         (query2 *id3-output-window* *current-decision-tree*)))



(defun get-rules ()
      (when *current-decision-tree*
             (let* ((tree-to-convert *current-decision-tree*)
                       (rule-set (tree-to-rules tree-to-convert)))
                 (push 
                       (open-stream 'id3-rule-window *id3-main-window* :output
                             :title (format nil "ID3 - Rules. Target: ~A"
                                           (dialog-item-value
                                               (find-named-object
                                                   ':tree-output
                                                  *id3-message-window*)))
                             :visible-box (make-box 0 0 600 300)
                             :font (make-font :modern nil 14)
                             :user-shrinkable nil :window-border :dialog-box
                             :user-scrollable t :user-resizable nil)
                       *opened-rules*)
                 (print-rule-set  rule-set (first *opened-rules*))
                 (first *opened-rules*))))



(defun set-verbose ()
      (if *verbose*
         (progn
              (set-menu-item-selected-p
               (find-named-object ':set-verbose *id3-classify-menu*)
               nil)
              (setq *verbose* nil))
         (progn
              (set-menu-item-selected-p
               (find-named-object ':set-verbose *id3-classify-menu*)
               t)
              (setq *verbose* t))))



(defun accept-clashes ()
      (if *accept-clashes*
         (progn
              (set-menu-item-selected-p
               (find-named-object ':accept-clashes *id3-classify-menu*)
               nil)
              (setq *accept-clashes* nil))
         (progn
              (set-menu-item-selected-p
               (find-named-object ':accept-clashes *id3-classify-menu*)
               t)
              (setq *accept-clashes* t)))) 



(defun save-table-as ()
     (let ((current-table-name (table-name *current-table-editor*)))
         (multiple-value-bind (new-name old-name value)
                (ask-user-for-string
                     "Please, type in the new table name"
                     current-table-name "OK" "Cancel")
               (when (string= value "OK")
                    (let ((new-file (pop-up-save-file-dialog
                                              *id3-main-window*
                                              (make-pathname :host nil :name *pail-directory*)
                                              "Save table as"
                                              "Please, type in the new table file."
                                              (file-namestring *current-table-file*)
                                              "id3\\tables\\")))
                        (when new-file
                             (setf (table-name *current-table-editor*) new-name)
                             (setf (stream-title *current-table-editor*) new-name)
                             (setf *current-table* (editor-to-table *current-table-editor*))
                             (set-dialog-item-value
                                  (find-named-object ':table-input *id3-message-window*)
                                  (table-name *current-table-editor*))
                             (dump-table-to-file *current-table* new-file)
                             (setf (table-needs-saving-p *current-table-editor*) nil)))))))
          


(defmethod dump-table-to-file ((table table) &optional (filename t))
      (with-open-file
           (out filename 
                 :direction :output 
                 :if-does-not-exist :create
                 :if-exists :supersede)
           (format out ";;; -*- Mode: LISP; Package: id3; Syntax: Common-lisp; -*-~%~%")
           (format out "(in-package :id3)~%~%~%")
           (format out ";;;")
           (format out (table-name table))
           (format out "~%~%(setf *readable* t)~%~%")
           (format out "(push (make-table~%")
           (format out "            :table-name ~S~%" (table-name table))
           (format out "            :attributes~22T'(~{~13a~})~%" (attributes table))
           (format out "            :rows~20T'(~{~%~18T(~{~13a~})~}))" (rows table))
           (format out "~%       *list-of-tables*)~%~%t~%")))



(defun add-attribute ()
      (setq *current-table-editor*
            (insert-new-attribute *current-table-editor* *id3-main-window*)))



(defun delete-attribute ()
      (let* ((list-of-attributes (cdar (contents *current-table-editor*)))
                (del-attribute (select-item-from-list
                                                *id3-main-window*
                                                list-of-attributes 
                                                "Choose attribute to delete")))
          (when del-attribute
                 (setq *current-table-editor*
                       (get-rid-of-attribute 
                             *current-table-editor* 
                             del-attribute 
                             *id3-main-window*)))))

 

(defun add-example ()
      (setq *current-table-editor*
            (insert-new-row *current-table-editor* *id3-main-window*)))



(defun delete-example ()
      (let* ((lista nil)
                (list-of-examples
                   (dolist (item (cdr (contents *current-table-editor*)) (reverse lista))
                         (push (car item) lista)))
                (del-example (select-item-from-list
                                                *id3-main-window*
                                                list-of-examples 
                                                "Choose example to delete")))
          (setq *current-table-editor*
                (when del-example
                       (get-rid-of-row 
                             *current-table-editor* 
                             del-example 
                             *id3-main-window*)))))



(defun menu-expand-wildcards ()
      (let ((new-table (expand-wildcards *current-table*)))
          (when new-table
                 (setq *current-table* new-table)
                 (window-close *current-table-editor*)
                 (setq *current-table-editor* (table-to-editor *current-table*)))))



(defun remove-duplication ()
      (let ((new-table (reduce-data *current-table*)))
          (when (< (number-of-rows new-table) (number-or-rows *current-table*))
                 (setq *current-table* new-table)
                 (window-close *current-table-editor*)
                 (setq *current-table-editor* (table-to-editor *current-table*)))))
    

