;;; -*- Mode: LISP; Package: id3; Syntax: Common-lisp; -*-
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-exm.cl
;;; Short Desc: Examples for wild explorations
;;; Version:    2.0
;;; Status:     Review
;;; Last Mod:   5.2.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; Precondition: pail-make with *gin-p*=nil

(in-package :id3)

(defvar e1 nil)
(defvar e2 nil)
(defvar e3 nil)
(defvar e4 nil)
(defvar e5 nil)
(defvar e6 nil)

(setf *readable* t)

; Now starting wild explorations



;;; e1 the ordinary example

(setf e1 (make-table
                 :table-name "ordinary example"
                 :attributes '(profit      age         competition type)
                 :rows      '((down        old         no          software)
                                    (down        midlife     yes         software)
                                    (up          midlife     no          hardware)
                                    (down        old         no          hardware)
                                    (up          new         no          hardware)
                                    (up          new         no          software)
                                    (up          midlife     no          software)
                                    (up          new         yes         software)
                                    (down        midlife     yes         hardware)
                                    (down        old         yes         software))))

(push e1 *list-of-tables*)



;;; e2 is e1 with a clash

(setf e2 (make-table
                 :table-name "Example with a clash"
                 :attributes '(profit      age         competition type)
                 :rows      '((down        old         no          software)
                                    (down        midlife     yes         software)
                                    (up          midlife     no          hardware)
                                    (down        old         no          hardware)
                                    (up          new         no          hardware)
                                    (up          new         no          software)
                                    (up          midlife     no          software)
                                    (up          new         yes         software)
                                    (down        midlife     no          hardware)
                                    (down        old         yes         software))))

(push e2 *list-of-tables*)



;;; e3 is an example where the target attribute values can be lists

(setf e3 (make-table
                 :table-name "Target attribute values as lists"
                 :attributes '(profit      age         competition type)
                 :rows      '((down        old         no          software)
                                    ((up down)   midlife     yes         software)
                                    ((up down)   midlife     no          software)
                                    (down        old         no          hardware)
                                    (up          new         no          hardware)
                                    (up          new         no          software)
                                    (up          new         yes         software)
                                    (down        old         yes         software))))

(push e3 *list-of-tables*)



;;; e5 si an example with wildcards

(setf e5 (make-table
                 :table-name "Example with wildcards"
                 :attributes '(profit      age         competition type)
                 :rows      '((down        *           no          software)
                                    (down        midlife     yes         software)
                                    (up          midlife     no          hardware)
                                    (down        old         *           *)
                                    (up          new         no          hardware)
                                    (up          new         no          software)
                                    (up          midlife     no          software)
                                    (up          new         yes         software)
                                    (down        midlife     yes         hardware)
                                    (down        old         yes         software))))

(push e5 *list-of-tables*)



;;; e6 is an example with numbers

(setf e6 (make-table
                 :table-name "Example with numbers"
                 :attributes '(profit      age         competition type)
                 :rows      '((down        20          no          software)
                                    (down        8           yes         software)
                                    (up          5           no          hardware)
                                    (down        18          no          hardware)
                                    (up          1           no          hardware)
                                    (up          2           no          software)
                                    (up          6           no          software)
                                    (up          3           yes         software)
                                    (down        5           yes         hardware)
                                    (down        15          yes         software))))

(push e6 *list-of-tables*)

nil

