(in-package :lcs)



(defparameter ga-parameters nil)

(defun make-ga-parameters ()
   (setq ga-parameters 
      (let (dialog)
         (setq dialog 
            (open-dialog 
               (list 
                  (make-dialog-item :widget 'button :groupstart nil 
                     :tabstop nil :box #.(make-box 60 285 120 310) 
                     :font (make-font nil :arial 16 '(:bold)) :name 
                     :ga-help :title "Help")
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 228 280 252) :value *crowding-subpop*
                     :font (make-font nil :courier\ new 16 nil) :name 
                     :crowding-subpop-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 188 280 212) :value *crowding-factor*
                     :font (make-font nil :courier\ new 16 nil) :name 
                     :crowding-factor-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 148 280 172) :value *proportion-select*
                     :font (make-font nil :courier\ new 16 nil) :name 
                     :proportion-select-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 108 280 132) :value *mutation-probability*
                     :font (make-font nil :courier\ new 16 nil) :name 
                     :mutation-p-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 68 280 92) :value *crossover-probability*
                      :font (make-font nil :courier\ new 16 nil) :name 
                     :crossover-p-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :set-value-fn 'change-ga-parameter :box 
                     #.(make-box 220 28 280 52) :value *ga-count*
                      :font (make-font nil :courier\ new 16 nil) :name 
                     :ga-count-val)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 230 200 250) :value 
                     "crowding subpopulation" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :crowding-subpop)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 190 200 210) :value 
                     "crowding factor" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :crowding-factor)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 150 200 170) :value 
                     "proportion select" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :proportion-select)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 110 200 130) :value 
                     "mutation probability" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :mutation-p)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 70 200 90) :value 
                     "cross-over probability" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :crossover-p)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 40 30 200 50) :value 
                     "GA period" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :ga-period)
                  (make-dialog-item :widget 'default-button :groupstart nil 
                     :tabstop nil :set-value-fn 'save-ga-parameters 
                     :box #.(make-box 220 285 280 310) :font 
                     (make-font nil :arial 16 '(:bold)) :name :ga-ok 
                     :title "OK")
                  (make-dialog-item :widget 'button :groupstart nil 
                     :tabstop nil :set-value-fn 'set-ga-default-values
                     :box #.(make-box 140 285 200 310) :value t :font 
                     (make-font nil :arial 16 '(:bold)) :name :default 
                     :title "Default"))
               'dialog *lcs-main-window* :name :ga-parameters
                   :title "GA Parameters"
                   :font (make-font :swiss :system 20 '(:bold))
               :user-movable t :user-resizable nil :user-closable nil
               :user-shrinkable nil :user-scrollable nil 
                  :window-border :dialog-box
               :background-color (make-rgb :red 0 :green 128 :blue 128) 
               :pop-up-p nil :visible-box #.(make-box 0 0 315 338))))))


(defun ga-parameters ()
    (make-ga-parameters))
