(in-package :lcs)



(defun save-ga-parameters (widget new-value old-value)
      (setf *ga-count*
          (dialog-item-value (nth 6 (dialog-items ga-parameters))))
      (setf *crossover-probability*
          (dialog-item-value (nth 5 (dialog-items ga-parameters))))
      (setf *mutation-probability*
          (dialog-item-value (nth 4 (dialog-items ga-parameters))))
      (setf *proportion-select*
          (dialog-item-value (nth 3 (dialog-items ga-parameters))))
      (setf *crowding-factor*
          (dialog-item-value (nth 2 (dialog-items ga-parameters))))
      (setf *crossover-subpop*
          (dialog-item-value (nth 1 (dialog-items ga-parameters))))
      (close ga-parameters)
      (set-menu-after-step))


(defun set-ga-default-values  (widget new-value old-value)
     (ga-default-values)
     (set-dialog-item-value (nth 6 (dialog-items ga-parameters)) *ga-count*)
     (set-dialog-item-value (nth 5 (dialog-items ga-parameters)) *crossover-probability*)
     (set-dialog-item-value (nth 4 (dialog-items ga-parameters)) *mutation-probability*)
     (set-dialog-item-value (nth 3 (dialog-items ga-parameters)) *proportion-select*)
     (set-dialog-item-value (nth 2 (dialog-items ga-parameters)) *crowding-factor*)
     (set-dialog-item-value (nth 1 (dialog-items ga-parameters)) *crowding-subpop*))
     

(defun change-ga-parameter  (widget new-value old-value)
       (set-dialog-item-value widget (eval new-value)))

(defun ga-graphics ()
     (if (not ga-graphics-on?)
        (progn
           (setf ga-graphics-on? t)
           (set-menu-item-selected-p
              (find-named-object :ga-graphics *lisp-menu-bar*) t)
            (ga-population))
        (progn
           (setf ga-graphics-on? nil)
           (set-menu-item-selected-p
              (find-named-object :ga-graphics *lisp-menu-bar*) nil)
            (close ga-population))))

(defun graphics-ga-init ()
     (when ga-graphics-on?
          (let ((p (population-string-ga-last)))
              (set-dialog-item-range (nth 3 (dialog-items ga-population)) p))))

(defun graphics-ga-end ()
     (when ga-graphics-on?
       (let ((p (population-string-ga-new)))
         (set-dialog-item-range (nth 0 (dialog-items ga-population)) p))))
              

(defvar counter 0)

(defun population-string-ga-last ()
     (setf counter 0)
     (mapcar #'cl-string-ga-last (population *evolution*)))

(defun cl-string-ga-last (l)
     (concatenate 'string
         (write-to-string (setf counter (1+ counter)))
         ".    "
         (cl-string (the-condition l))
         " : "
         (cl-string (the-action l))
         (format nil "    ~5,2F" (strength l))))

(defun population-string-ga-new ()
     (setf counter 0)
     (mapcar #'cl-string-ga-new (population *evolution*)))

(defun cl-string-ga-new (l)
     (concatenate 'string
         (write-to-string (setf counter (1+ counter)))
         ".    "
         (cl-string (the-condition l))
         " : "
         (cl-string (the-action l))
         (format nil "    ~5,2F" (strength l))
         "   "
         (if (> (parent1 l) 0) (write-to-string (parent1 l)) "")
         "   "
         (if (> (parent2 l) 0) (write-to-string (parent2 l)) "")))
         
     
