;;; *******************************
;;; *    PORTABLE  AI  LAB   -   IDSIA   *
;;; *******************************
;;;
;;; Filename:      bucket.lsp
;;; Short Desc:  Bucket brigade algorithm
;;; Version:         1.0
;;; Status:           Review
;;; Last Mod:      01.09.94
;;; Author:          Roberto Limeres
;;;
;;; Copyright (c) 1994 Instituto Dalle Molle (IDSIA), University  of
;;; Zurich, Swiss Federal Institte of Technology Lausanne
;;;
;;; Permision is granted to any individual  or  institution  to  use,
;;; copy, modify, and distribute this software, provided that this
;;; complete  copyright  and  permission  notice  is   maintained,
;;; intact, in all copies and supporting documentation.
;;;
;;; IDSIA provides this  software  "as  is"  without  expresed  or
;;; implied warranty.
;;;

;;; --------------------------------------------------
;;; Change History:
;;; Files required:         bucket.lsp     (this file)
;;;                                      declare.lsp    (declaration file)
;;;                                      util.lsp             (random and uttility functions)
;;; --------------------------------------------------

(in-package :lcs)


;;; ====================================================
;;; Method AOC
;;; Apportionement of credit
;;; ====================================================

(defmethod aoc ((p population))
          (match-classifiers p)
          (auction p)
          (taxcollector p)
          (clearinghouse p))
         

(defmethod copy-population ((p population))
      (mapcar #'copy-classifier (population p)))
          

(defmethod copy-classifier ((cl classifier))
      (make-instance 'classifier
             :condition (copy-list (the-condition cl))
             :action (copy-list (the-action cl))
             :strength (strength cl)
             :bid (bid cl)
             :ebid (ebid cl)))
    

;;; ====================================================
;;; Method MATCH-CLASSIFIERS
;;; Match message list and classifier list
;;; ====================================================

(defmethod match-classifiers ((p population))
      (let ((result nil))
          (dolist (cl (match-list p))
               (setf (matchflag (first cl)) nil))
          (setf (match-list p) nil)
          (dolist (cl (population p))
                (setf result nil)
                (dolist (mess (message-list p) result) 
                      (when (match (the-condition cl) (message mess))
                             (progn
                                  (setf (matchflag cl) t)
                                  (setf result (cons mess result)))))
                (when result
                       (setf (match-list p) (acons cl result (match-list p)))))))
	
(defun match (the-condition the-message)
      (if the-condition
         (when (or (= (car the-condition) *wildcard*)
                            (= (car the-condition) (car the-message)))
                (match (cdr the-condition) (cdr the-message)))
         t))


;;; ====================================================
;;; Method AUCTION
;;; Slection of winner classifiers
;;; ====================================================

(defmethod auction ((p population))
      (let ((result nil))
          (dolist (cl (winners p))
               (setf (winner-flag (first cl)) nil))
          (setf (winners p)
                  (firstn *message-list-size*
                      (dolist (a-match (match-list p) result)
                              (let ((cl (first a-match)))
                                  (setf (bid cl) (* (* *cbid*
                                                            (+ *bid1*
                                                                (* *bid2* (specificity cl))))
                                                         (strength cl)))
                                  (setf (ebid cl) (+ (* (* *cbid*       
                                                                  (+ *ebid1*   
                                                                      (* *ebid2* (specificity cl))))
                                                               (strength cl))
                                                            (noise *bidmu* *bidsigma*)))
                                  (setf result (intr-sort a-match result 'maxebid))))))
          (dolist (cl (winners p))
               (setf (winner-flag (first cl)) t))))


;;; ====================================================
;;; Method TAXCOLLECTOR
;;; Life tax and bid tax payement
;;; ====================================================

(defmethod taxcollector ((p population))
      (when (or (> *lifetax* 0.0)
                         (> *bidtax* 0.0))
             (dolist (cl (population p))
                   (setf (strength cl)
                             (- (- (strength cl)
                                    (* *lifetax* (strength cl)))
                                (* (* (if (matchflag cl) 1.0 0.0)
                                         *bidtax*)
                                    (strength cl)))))))


;;; ====================================================
;;; Method CLEARINGHOUSE
;;; Winners' payement
;;; ====================================================

(defmethod clearinghouse  ((p population))
     (setf (message-list p) nil)
     (dolist (win (winners p))
          (let ((cl (first win)) (win-count (count-old (cdr win))))
              (setf (message-list p)
                      (cons (make-instance 'message :message (the-action cl) :by-classifier cl)
                                (message-list p)))
              (setf (strength cl) (- (strength cl) (bid cl)))
              (dolist (old-win (cdr win))
                   (when (not (equal (by-classifier old-win) 'input))
                      (setf (strength (by-classifier old-win))
                           (+ (strength (by-classifier old-win))
                               (/ (bid cl) count-old))))))))


(defun count-old (m-list)
     (let ((counter 0))
         (dolist (m m-list counter)
              (if (not (equal (by-classifier m) 'input)) (incf counter)))))
          

;;; ====================================================
;;; Utility functions
;;; ====================================================

(defun maxstrength (cl1 cl2)
      (if cl2
         (> (strength cl1) (strength cl2))
         t))

(defun maxebid (cl1 cl2)
      (if cl2
         (> (ebid (first cl1)) (ebid (first cl2)))
         t))

