;;; **************************************
;;; *    PORTABLE  AI  LAB   -   IDSIA   *
;;; **************************************
;;;
;;; Filename:      declare.lsp
;;; Short Desc:   Declaration of variables and class of CS
;;; Version:         1.0
;;; Status:           Review
;;; Last Mod:      01.09.94
;;; Author:           Roberto Limeres
;;;
;;; Copyright (c) 1994 Instituto Dalle Molle (IDSIA), University  of
;;; Zurich, Swiss Federal Institte of Technology Lausanne
;;;
;;; Permision is granted to any individual  or  institution  to  use,
;;; copy, modify, and distribute this software, provided that this
;;; complete  copyright  and  permission  notice  is   maintained,
;;; intact, in all copies and supporting documentation.
;;;
;;; IDSIA provides this  software  "as  is"  without  expresed  or
;;; implied warranty.
;;;

;;; --------------------------------------------------
;;; Change History:
;;; Files required:    declare.cl          (this file)
;;;                            util.cl                 (random and utility functions)
;;; --------------------------------------------------

(in-package :lcs)

(defclass lcs-main-dialog (dialog)
      ())

(defmethod bring-window-to-front :after ((ld lcs-main-dialog))
        (in-package :lcs)
        (set-lcs-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Learning Classifier System module"))
;;; ====================================================
;;; Type declaration 
;;; ====================================================

(defvar *bit*              '(0 1))
(defvar *trit*              '(0 1 -1))
(defvar *wildcard*     -1)


;;; ====================================================
;;; CS parameters declaration
;;; ====================================================

(defparameter *default-population-size*      100)
(defparameter *default-message-list-size*  1)
(defparameter *default-condition-length*     6)
(defparameter *default-action-length*          1)
(defparameter *default-initial-strength*       10.0)
(defparameter *default-cbid*                        0.1)
(defparameter *default-bid1*                        0.250)
(defparameter *default-bid2*                        0.125)
(defparameter *default-ebid1*                      0.250)
(defparameter *default-ebid2*                      0.125)
(defparameter *default-bidtax*                     0.01)
(defparameter *default-lifetax*                     0.0)

(defparameter *population-size*      100)
(defparameter *message-list-size*  1)
(defparameter *condition-length*     6)
(defparameter *action-length*          1)
(defparameter *initial-strength*       10.0)
(defparameter *cbid*                        0.1)
(defparameter *bid1*                        0.250)
(defparameter *bid2*                        0.125)
(defparameter *ebid1*                      0.250)
(defparameter *ebid2*                      0.125)
(defparameter *bidmu*                     0.0)
(defparameter *bidsigma*                0.075)
(defparameter *bidtax*                     0.01)
(defparameter *lifetax*                     0.0)


;;; ====================================================
;;; Global variables declaration
;;; ====================================================

(defvar *evolution* nil)
(defvar *ga-flag*     0)
(defvar *loop*          t)
(defvar cs-graphics-on? nil)
(defvar ga-graphics-on? nil)
(defvar *application-window* nil)

(defparameter application-loaded? nil)

;;; ====================================================
;;; GA parameters declaration
;;; ====================================================

(defparameter *default-ga-count* 500)
(defparameter *default-crossover-probability*  1.0)
(defparameter *default-mutation-probability*    0.02)
(defparameter *default-proportion-select*         0.2)
(defparameter *default-crowding-factor*            3)
(defparameter *default-crowding-subpop*         3)

(defparameter *ga-count* 500)
(defparameter *crossover-probability*  1.0)
(defparameter *mutation-probability*    0.02)
(defparameter *mutations-p*                  t)
(defparameter *crossover-events*        0)
(defparameter *mutation-events*           0)
(defparameter *proportion-select*         0.2)
(defparameter *crowding-factor*            3)
(defparameter *crowding-subpop*         3)


;;; ====================================================
;;; Class CLASSIFIER
;;; ====================================================

(defclass classifier ()
       ((condition
              :type list
              :initarg :condition
              :accessor the-condition)
        (action
              :type list
              :initarg :action
              :accessor the-action)
        (strength
             :type float
             :initarg :strength
             :accessor strength)
        (bid
            :type float
            :initform 0.0
            :initarg :bid
            :accessor bid)
        (ebid
              :type float
              :initform 0.0
              :initarg :ebid
              :accessor ebid)
        (specificity
              :type integer
              :initform 0.0
              :accessor specificity)
        (parent1
             :type integer
             :initform 0
             :initarg :parent1
             :accessor parent1)
        (parent2
             :type integer
             :initform 0
             :initarg :parent2
             :accessor parent2)
        (matchflag
               :initform nil
               :accessor matchflag)
        (winner-flag                
             :initform nil
             :accessor winner-flag)))


;;; ====================================================
;;; Initialzation methods for class CLASSIFIER
;;; ====================================================

(defmethod initialize-instance
       :before ((cl classifier)
                       &key (the-condition (random-list *condition-length* *trit*))
                       (the-action (random-list *action-length* *bit*))
                       (strength 0.0)
                       (p1 0)
                       (p2 0))
      (setf (the-condition cl) the-condition)
      (setf (the-action cl) the-action)
      (setf (strength cl) strength)
      (setf (parent1 cl) p1)
      (setf (parent2 cl) p2))

(defmethod initialize-instance :after ((cl classifier) &rest x)
      (setf (specificity cl) (countspecificity (the-condition cl))))

(defun countspecificity (l &optional (accu 0.0) (leng (length l)))
      (if (not l) accu
         (if (= (car l) *wildcard*)
            (countspecificity (cdr l) accu leng)
            (countspecificity (cdr l) (+ accu 1.0) leng))))


;;; ====================================================
;;; Class MESSAGE
;;; ====================================================

(defclass message ()
      ((message
        :type list
        :initarg :message
        :accessor message)
       (by-classifier
        :initarg :by-classifier
        :accessor by-classifier)))

;;; ====================================================
;;; Initialization methods for class MESSAGE
;;; ====================================================

(defmethod initialize-instance ((m message) &key message (by-classifier 'input))
     (setf (message m) message)
     (setf (by-classifier m) by-classifier))

;;; ====================================================
;;; Class POPULATION
;;; ====================================================

(defclass population ()
       ((population
              :type list
              :initarg :population
              :accessor population)
        (message-list
             :type list
             :initform nil
             :initarg :message-list
             :accessor message-list)
        (min-strength
             :type float
             :initform 0.0
             :initarg :min-strength
             :accessor min-strength)
        (max-strength
               :type float
               :initform 0.0
               :initarg :max-strength
               :accessor max-strength)
        (avg-strength
              :type float
              :initform 0.0
              :initarg :avg-strength
              :accessor avg-strength)
        (sum-strength
              :type float
              :initform 0.0
              :initarg :sum-strength
              :accessor sum-strength)
        (match-list
               :type list
               :initform nil
               :accessor match-list)
        (winners
             :type list
             :initform nil
             :accessor winners)))


;;; ====================================================
;;; Initialization methods for class POPULATION
;;; ====================================================

(defmethod initialize-instance
       :before ((p population)
                       &key (population (initializate-population *population-size*)))
      (setf (population p) population))

(defun initializate-population (population-size)
      (let ((result nil))
          (dotimes (i population-size result)
                (push (make-instance 'classifier :strength *initial-strength*) result))))
     

;;; ====================================================
;;; Class MESSAGE-LIST
;;; ====================================================

(defclass message-list ()
       ((messages
               :type list              ;??????? c'est necessaire?
               :initform nil
               :initarg :messages
               :accessor messages)))
