;;; *******************************
;;; *    PORTABLE  AI  LAB   -   IDSIA   *
;;; *******************************
;;;
;;; Filename:      init.lsp
;;; Short Desc:  Procedures of initialization of CS
;;; Version:         1.0
;;; Status:           Review
;;; Last Mod:      09.01.94
;;; Author:          Roberto Limeres
;;;
;;; Copyright (c) 1994 Instituto Dalle Molle (IDSIA), University  of
;;; Zurich, Swiss Federal Institte of Technology Lausanne
;;;
;;; Permision is granted to any individual  or  institution  to  use,
;;; copy, modify, and distribute this software, provided that this
;;; complete  copyright  and  permission  notice  is   maintained,
;;; intact, in all copies and supporting documentation.
;;;
;;; IDSIA provides this  software  "as  is"  without  expresed  or
;;; implied warranty.
;;;

;;; --------------------------------------------------
;;; Change History:
;;; Files required:      init.lsp               (this file)
;;;                                   declare.lsp      (declaration file)  
;;; --------------------------------------------------

(in-package :lcs)

;;; ====================================================
;;; Method INITIALIZATION
;;; Selection of initial population
;;; ====================================================

(defmethod init-system ()
     (setf cs-graphics-on? nil)
     (setf ga-graphics-on? nil)
     (setf *evolution* (make-instance 'population))
     (setf *ga-flag* 0))

(defun initialization ()
     (set-menu-after-step)
     (when ga-graphics-on?
       (set-dialog-item-range (find-named-object :last-pop ga-population) nil)
       (set-dialog-item-range (find-named-object :new-pop ga-population) nil))
     (when cs-graphics-on?
       (set-dialog-item-range (find-named-object :last-pop cs-population) nil)
       (set-dialog-item-range (find-named-object :new-pop cs-population) nil)
       (set-dialog-item-range
           (find-named-object :last-message-list show-message-list) nil)
       (set-dialog-item-range
           (find-named-object :new-message-list show-message-list) nil))
     (setf *application-window* (init-application))
     (evaluate *evolution*))



(defun set-default-values ()
    (ga-default-values)
    (cs-default-values))


(defun ga-default-values ()
     (setf *ga-count* *default-ga-count*)
     (setf *crossover-probability* *default-crossover-probability*)
     (setf *mutation-probability* *default-mutation-probability*)
     (setf *proportion-select* *default-proportion-select*)
     (setf *crowding-factor* *default-crowding-factor*)
     (setf *crowding-subpop* *default-crowding-subpop*))

(defun cs-default-values ()
     (setf *population-size* *default-population-size*)
     (setf *message-list-size* *default-message-list-size*)
     (setf *condition-length* *default-condition-length*)
     (setf *action-length* *default-action-length*)
     (setf *initial-strength* *default-initial-strength*)
     (setf *cbid* *default-cbid*)
     (setf *bid1* *default-bid1*)
     (setf *bid2* *default-bid2*)
     (setf *ebid1* *default-ebid1*)
     (setf *ebid2* *default-ebid2*)
     (setf *bidtax* *default-bidtax*)
     (setf *lifetax* *default-lifetax*))
             



(defun set-menu-after-load ()
       (set-menu-item-available-p (find-named-object :load-application *lisp-menu-bar*) nil)
       (set-dialog-item-title (first *lcs-buttons*) "Close")
       (set-menu-item-available-p (find-named-object :close-application *lisp-menu-bar*) t)
       (set-menu-item-available-p (find-named-object :init *lisp-menu-bar*) t)
       (set-menu-item-available-p (find-named-object :run *lisp-menu-bar*) t)
       (set-dialog-item-available-p (third *lcs-buttons*) t)
       (set-menu-item-available-p (find-named-object :step *lisp-menu-bar*) t)
       (set-dialog-item-available-p (second *lcs-buttons*) t)
       (set-menu-item-available-p (find-named-object :run-ga *lisp-menu-bar*) t))


(defun set-menu-after-close ()
      (when ga-graphics-on?
             (set-dialog-item-range (find-named-object :last-pop ga-population) nil)
             (set-dialog-item-range (find-named-object :new-pop ga-population) nil))
      (when cs-graphics-on?
             (set-dialog-item-range (find-named-object :last-pop cs-population) nil)
             (set-dialog-item-range (find-named-object :new-pop cs-population) nil)
             (set-dialog-item-range
                   (find-named-object :last-message-list show-message-list) nil)
             (set-dialog-item-range
                   (find-named-object :new-message-list show-message-list) nil))
      (set-menu-item-available-p (find-named-object :load-application *lisp-menu-bar*) t)
       (set-dialog-item-title (first *lcs-buttons*) "Load")
      (set-menu-item-available-p (find-named-object :close-application *lisp-menu-bar*) nil)
      (set-menu-item-available-p (find-named-object :init *lisp-menu-bar*) nil)
      (set-menu-item-available-p (find-named-object :run *lisp-menu-bar*) nil)
      (set-dialog-item-available-p (third *lcs-buttons*) nil)
      (set-menu-item-available-p (find-named-object :stop *lisp-menu-bar*) nil)
      (set-menu-item-available-p (find-named-object :step *lisp-menu-bar*) nil)
      (set-dialog-item-available-p (second *lcs-buttons*) nil)
      (set-menu-item-available-p (find-named-object :run-ga *lisp-menu-bar*) nil))
     


(defun set-menu-after-step ()
     (set-menu-item-available-p (find-named-object :init *lisp-menu-bar*) t)
     (set-menu-item-available-p (find-named-object :run *lisp-menu-bar*) t)
     (set-menu-item-available-p (find-named-object :stop *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :step *lisp-menu-bar*) t)
      (set-dialog-item-available-p (second *lcs-buttons*) t)
     (set-menu-item-available-p (find-named-object :run-ga *lisp-menu-bar*) t))



(defun set-menu-running ()
      (set-menu-item-available-p (find-named-object :close-application *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :init *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :run *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :stop *lisp-menu-bar*) t)
     (set-menu-item-available-p (find-named-object :step *lisp-menu-bar*) nil)
      (set-dialog-item-available-p (second *lcs-buttons*) nil)
      (set-dialog-item-title (third *lcs-buttons*) "Stop")
     (set-menu-item-available-p (find-named-object :run-ga *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :cs-par *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :ga-par *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :cs-graphics *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :ga-graphics *lisp-menu-bar*) nil))

(defun set-menu-after-run ()
     (set-menu-after-step)
       (set-menu-item-available-p (find-named-object :close-application *lisp-menu-bar*) t)
      (set-dialog-item-title (third *lcs-buttons*) "Run")
     (set-menu-item-available-p (find-named-object :cs-par *lisp-menu-bar*) t)
     (set-menu-item-available-p (find-named-object :ga-par *lisp-menu-bar*) t)
     (set-menu-item-available-p (find-named-object :cs-graphics *lisp-menu-bar*) t)
     (set-menu-item-available-p (find-named-object :ga-graphics *lisp-menu-bar*) t))

     


(defun stop-or-run ()
       (if (string= (dialog-item-title (third *lcs-buttons*)) "Run")
          (run-loop)
          (stop-loop)))



(defun load-or-close ()
       (if (string= (dialog-item-title (first *lcs-buttons*)) "Load")
          (load-application)
          (close-application)))