;;; *******************************
;;; *    PORTABLE  AI  LAB   -   IDSIA   *
;;; *******************************
;;;
;;; Filename:      csio.lsp
;;; Short Desc:  Interface Rule Engine - Environment
;;; Version:        1.0
;;; Status:          Review
;;; Last Mod:     01.09.94
;;; Author:          Roberto Limeres
;;;
;;; Copyright (c) 1994 Instituto Dalle Molle (IDSIA), University  of
;;; Zurich, Swiss Federal Institte of Technology Lausanne
;;;
;;; Permision is granted to any individual  or  institution  to  use,
;;; copy, modify, and distribute this software, provided that this
;;; complete  copyright  and  permission  notice  is   maintained,
;;; intact, in all copies and supporting documentation.
;;;
;;; IDSIA provides this  software  "as  is"  without  expresed  or
;;; implied warranty.
;;;

;;; --------------------------------------------------
;;; Change History:
;;; Files required:       csio.lsp            (this file)
;;;                                    declare.lsp     (declaration file)
;;;                                    An application file
;;; --------------------------------------------------

(in-package :lcs)

;;; ====================================================
;;; Method DETECTORS
;;; ====================================================

; ******* esto hay que ampliarlo:
; ******* - que parte de message-list?
; ******* - la llamada a environment es correcta?

(defun detectors ()
     (dolist (mess (environment))
      (setf (message-list *evolution*)
              (cons (make-instance 'message :message mess)
                        (message-list *evolution*)))))


;;; ====================================================
;;; Method REINFORCEMENT
;;; ====================================================

; ******* lo mismo que detectors

(defmethod effectors ((p population))
      (dolist (win (winners p))
           (let ((cl (first win))
                  (reinf (reinforcement (the-action (first win)))))
               (setf (strength cl) (+ (strength cl) (first reinf)))
               (if (second reinf)
                  (setf (message-list p) (delete cl (message-list p) :key #'by-classifier))))))

