(in-package :lcs)

(defparameter show-message-list nil)

(defun make-show-message-list ()
      (setq show-message-list 
            (let (dialog)
                (setq dialog 
                      (open-dialog ()
                            'dialog *lcs-main-window* :name :show-message-list 
                            :title "Message List"
                            :font (make-font :swiss :system 16 '(:bold)) 
                            :user-movable t :user-resizable nil :user-closable nil 
                            :user-shrinkable nil :user-scrollable nil 
                            :window-border :dialog-box
                            :background-color (make-rgb :red 0 :green 128 :blue 128) 
                            :pop-up-p nil :window-exterior
                            (make-box
                                   20
                                   (- (box-height (window-interior *lcs-main-window*)) 180)
                                   (- (round (/ (box-width (window-interior *lcs-main-window*)) 2)) 50)
                                   (- (box-height (window-interior *lcs-main-window*)) 20))))
                (update-dialog dialog
                      (list 
                         (make-dialog-item :widget 'static-text
                                :background-color t
                                :box (make-box
                                                (+ (round (/ (box-width (window-interior dialog)) 2)) 30)
                                                5
                                                (- (box-width (window-interior dialog)) 5)
                                                25)
                                :value "Output message list"
                                :font (make-font nil :arial 16 '(:bold))
                                :name :new-message-list-text)
                         (make-dialog-item :widget 'static-text
                                :background-color t
                                :box (make-box
                                                30 5
                                                (- (round (/ (box-width (window-interior dialog)) 2)) 5)
                                                25)
                                :value "Input message list"
                                :font (make-font nil :arial 16 '(:bold))
                                :name :last-message-list-text)
                         (make-dialog-item :widget 'single-item-list 
                                :box (make-box 
                                                (+ (round (/ (box-width (window-interior dialog)) 2)) 5)
                                                30
                                                (- (box-width (window-interior dialog)) 5)
                                                (- (box-height (window-interior dialog)) 5))
                                :font (make-font nil :times\ new\ roman 12 '(:bold)) 
                                :name :new-message-list)
                         (make-dialog-item :widget 'single-item-list 
                                :box (make-box
                                                5 30
                                                (- (round (/ (box-width (window-interior dialog)) 2)) 5)
                                                (- (box-height (window-interior dialog)) 5))
                                :font (make-font nil :times\ new\ roman 12 '(:bold)) 
                                :name :last-message-list)))
                dialog)))

(defun show-message-list ()
      (make-show-message-list))
