;;; *******************************
;;; *    PORTABLE  AI  LAB   -   IDSIA   *
;;; *******************************
;;;
;;; Filename:      main.lsp
;;; Short Desc:  Principal procedure of CS
;;; Version:         1.0
;;; Status:           Review
;;; Last Mod:      09.01.94
;;; Author:          Roberto Limeres
;;;
;;; Copyright (c) 1994 Instituto Dalle Molle (IDSIA), University  of
;;; Zurich, Swiss Federal Institte of Technology Lausanne
;;;
;;; Permision is granted to any individual  or  institution  to  use,
;;; copy, modify, and distribute this software, provided that this
;;; complete  copyright  and  permission  notice  is   maintained,
;;; intact, in all copies and supporting documentation.
;;;
;;; IDSIA provides this  software  "as  is"  without  expresed  or
;;; implied warranty.
;;;

;;; --------------------------------------------------
;;; Change History:
;;; Files required:       main.lsp           (this file)
;;;                                    declare.lsp      (declaration file)
;;;                                    stats.lsp           (stattistics and report functions)
;;;                                    csio.lsp             (interface engine - environment)
;;;                                    bucket.lsp       (bucket brigade algorithm)
;;;                                    ga.lsp                (genetic algorithm)
;;; --------------------------------------------------



(in-package :lcs)

;;; ====================================================
;;; Main program for Classifier Systems
;;; ====================================================

(defun lcs ()
     (setq pail-lib::*lcs-module-loaded* t)
     (in-package :lcs)
     (create-lcs-window)
     (set-lcs-menubar)
     (create-lcs-dialog)
     (init-system)
     )

(defun load-application ()
      (let ((file
                  (pc::pop-up-load-file-dialog
                   *lcs-main-window*
                   nil
                   "Load File"
                   "Problem to load"
                   "*.lcs"
                   (concatenate 'string *pail-directory* "lcs\\problems\\")
                   :load)))
          (when file
                 (when (load file)
                        (progn
                             (setf *ga-flag* 0)
                             (set-default-values)
                             (setf *application-window* (init-application))
                             (set-menu-after-load))))))

     
(defun close-application ()
     (close *application-window*)
     (setf application-loaded? nil)
     (set-menu-after-close))
     

(defun cycle ()
     (when cs-graphics-on?
         (setf (population *evolution*)
                 (my-sort 'maxstrength (population *evolution*))))   
     (graphics-cs-init)
     (detectors)
     (show-message-list-init)  
     (aoc *evolution*)
     (show-message-list-end)
     (effectors *evolution*)
     (evaluate *evolution*)
     (graphics-cs-end)
     (incf *ga-flag*)
     (when (= *ga-flag* *ga-count*) (run-ga)))



(defun run-ga ()
     (setf (population *evolution*)
             (my-sort 'maxstrength (population *evolution*)))     
     (graphics-ga-init)
     (ga *evolution*)
     (graphics-ga-end)
     (setf *ga-flag* 0)
     (setf *ga-count* (* 2 *ga-count*)))



(defun run-cycle ()
     (cycle)
     (set-menu-after-step))

(defun now-run-ga ()
     (run-ga)
     (set-menu-after-step))

(defun stop-loop ()
     (setf *loop* nil)
     (set-menu-after-step))
     

(defun run-loop ()
     (set-menu-running)
     (setf *loop* t)
     (loop until (not *loop*)
         collect 
          (progn
              (process-pending-events)
              (cycle)))
     (set-menu-after-run))
    


(defun exit-system ()
     (remove-from-window-menu (object-name *lcs-main-window*))
      (close *lcs-main-window*)
      (setq *lcs-main-window* nil)
      (setq pail-lib::*lcs-module-loaded* nil)
      (make-available :lcs))



