(in-package :lcs)


(defparameter *lcs-output-window* nil)

(defparameter *lcs-buttons* nil)



(defparameter *lcs-file-menu* nil)

(defun lcs-new ()
     (:new *lcs-main-window*))


(defun lcs-close ()
     (let ((window (front-window *lcs-main-window*)))
     (:close window)))

(defun lcs-print ()
     (:print (front-window *lcs-main-window*)))

(defun lcs-open ()
      (pail-open *lcs-main-window*))                  
             
(defun lcs-save ()
      (pail-save *lcs-main-window*))                  
             
(defun lcs-save-as ()
      (pail-save-as *lcs-main-window*))                


(setq *lcs-file-menu*
      (make-menu-item :title "~File" :value
             (open-menu 
                   (list 
                      (make-menu-item :name 'lcs-new
                             :title '"~New" :value 'lcs-new
                             :event-synonym '(control-key #\N) 
                             :available-p t)
                      (make-menu-item :name ':open
                             :title '"~Open..." :value 'lcs-open 
                             :event-synonym '(control-key #\O) 
                             :available-p t)
                      (make-menu-item :name ':close
                             :title '"Close" :value 'lcs-close 
                             :available-p t)
                      menu-separator
                      (make-menu-item :name ':save
                             :title '"~Save" :value 'lcs-save
                             :event-synonym '(control-key #\S)
                             :available-p t)
                      (make-menu-item :name ':save-as
                             :title '"Save ~As..." :value 'lcs-save-as 
                             :available-p t)
                      menu-separator
                      (make-menu-item :name ':load-application
                             :title '"~Load Problem..." :value 'load-application
                             :available-p t)
                      (make-menu-item :name ':close-application
                             :title '"Close Problem"
                             :value 'close-application
                             :available-p nil)
                      menu-separator
                      (make-menu-item :name ':print
                             :title '"~Print..." :value 'lcs-print 
                             :event-synonym '(control-key #\P)
                             :available-p t)
                      menu-separator
                      (make-menu-item :name ':quit :title 
                             '"E~xit" :value 'exit-system
                             :event-synonym '(control-key #\X)
                             :available-p t))
                   'pop-up-menu *lisp-main-window*  
                   :selection-function 'funcall-menu-item)))



(defparameter *lcs-main-menu* nil)

(setq *lcs-main-menu*
      (make-menu-item :title '"~Classifier System" :value 
             (open-menu 
                   (list 
                      (make-menu-item :name ':init
                             :title '"~Init" :value '(initialization)
                             :available-p nil)
                      menu-separator
                      (make-menu-item :name ':run
                             :title '"~Run" :value '(run-loop) 
                             :available-p nil)
                      (make-menu-item :name ':stop
                             :title '"~Stop" :value '(stop-loop) 
                             :available-p nil)
                      menu-separator
                      (make-menu-item :name ':step
                             :title '"S~tep" :value '(run-cycle) 
                             :available-p nil)
                      menu-separator
                      (make-menu-item :name ':run-ga
                             :title '"Run ~GA" :value '(now-run-ga) 
                             :available-p nil))
                   'pop-up-menu *lisp-main-window*
                   :selection-function 'eval-menu-item)))



(defparameter *lcs-aoc-menu* nil)

(setq *lcs-aoc-menu*
      (make-menu-item :title '"~Bucket Brigade" :value 
             (open-menu 
                   (list 
                      (make-menu-item :name ':cs-par
                             :title '"~Parameters" :value '(cs-parameters) 
                             :available-p t)
                      menu-separator
                      (make-menu-item :name ':cs-graphics 
                             :title '"~Graphics On" :value '(cs-graphics)
                             :available-p t))
                   'pop-up-menu *lisp-main-window*
                   :selection-function 'eval-menu-item)))



(defparameter *lcs-ga-menu* nil)

(setq *lcs-ga-menu*
      (make-menu-item :title '"~Genetic Algorithm" :value 
             (open-menu 
                   (list 
                      (make-menu-item :name ':ga-par
                             :title '"~Parameters" :value '(ga-parameters) 
                             :available-p t)
                      menu-separator
                      (make-menu-item :name ':ga-graphics 
                             :title '"~Graphics On" :value '(ga-graphics)
                             :available-p t ))
                   'pop-up-menu *lisp-main-window*
                   :selection-function 'eval-menu-item)))



(defvar *lcs-demo-menu* nil)

(setq *lcs-demo-menu*
      (make-menu-item :title "~Demos" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "Demo 1"
                             :value 'lcs-demo-1 :available-p nil)
                      (make-menu-item :title "Demo 2"
                             :value 'lcs-demo-2 :available-p nil)
                      (make-menu-item :title "Demo 3"
                             :value 'lcs-demo-3 :available-p nil))
                   'pop-up-menu *lisp-main-window* :name '*lcs-demo-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))



(defun create-lcs-window ()
           (setq *lcs-main-window*
            (open-dialog () 'lcs-main-dialog *lisp-main-window* :pop-up-p nil
                  :name ':lcs-main
                  :title "LCS Main" :user-closable nil
                  :background-color (make-rgb :red 0 :green 128 :blue 128) 
                  :window-exterior (clipping-box *lisp-main-window*))))

(defun set-lcs-menubar ()
     (clean-up-menubar)
         (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Tools
                :value *pail-tool-menu*))
     (add-to-menu *lisp-menu-bar*
          *lcs-file-menu*)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Edit
                :value *pail-edit-menu*))
      (add-to-menu *lisp-menu-bar* *lcs-main-menu*)
     (add-to-menu *lisp-menu-bar* *lcs-aoc-menu*)
     (add-to-menu *lisp-menu-bar* *lcs-ga-menu*)
     (add-to-menu *lisp-menu-bar* *lcs-demo-menu*)
     (add-to-menu *lisp-menu-bar* *pail-window-menu*)  
     )

(defun create-lcs-dialog ()
      (let* ((*number-of-buttons* 4)           
                (box (window-interior *lcs-main-window*))
                (h-indent (round (* 0.2 (box-width box))))
                (v-indent (round (* 0.2 (- (box-height box) 20))))
                (h-size (- (box-width box) (* 2 h-indent)))
                (button-width (round (/ h-size *number-of-buttons*)))
                (button-height 25)
                (help-button nil)
                (out-dialog nil))
          (setq out-dialog
                (open-dialog () 'dialog *lcs-main-window*
                      :pop-up-p nil
                      :title "LCS: Output"
                      :user-closable nil
                      :user-shrinkable t
                      :user-resizable nil
                      :user-scrollable nil
                      :user-movable t
                      :window-border :dialog-box
                      :window-interior
                      (make-box 
                             h-indent 
                             (+ v-indent button-height)
                             (- (box-width box) h-indent)
                             (- (box-height box) v-indent))))
          (setq *lcs-output-window*
                (open-stream
                      'text-edit-window out-dialog :output
                      :name ':csp-output
                      :user-closable nil
                      :user-shrinkable nil
                      :user-resizable nil
                      :user-scrollable t
                      :user-movable nil
                      :font (make-font :modern nil 14)
                      :window-exterior
                      (make-box
                             0 25
                             (box-width (visible-box out-dialog))
                             (box-height (visible-box out-dialog)))))
          (setq help-button
                (make-dialog-item :widget 'button
                       :title "Help"
                       :set-value-fn #'(lambda (&rest x) (lcs-help))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p nil
                       :box (make-box
                                       0 0 (round (/ (box-width (visible-box out-dialog)) *number-of-buttons*)) 25)))
          (push
                (make-dialog-item :widget 'button
                       :title "Run"
                       :set-value-fn #'(lambda (&rest x) (stop-or-run))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p nil
                       :box (make-box
                                       (round (/ (box-width (visible-box out-dialog)) *number-of-buttons*)) 0
                                       (round (/ (* 2 (box-width (visible-box out-dialog))) *number-of-buttons*)) 25))
                *lcs-buttons*)
           (push
                (make-dialog-item :widget 'button
                       :title "Step"
                       :set-value-fn #'(lambda (&rest x) (run-cycle))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p nil
                       :box (make-box
                                       (round (/ (* 2 (box-width (visible-box out-dialog))) *number-of-buttons*)) 0
                                       (round (/ (* 3 (box-width (visible-box out-dialog))) *number-of-buttons*)) 25))
                *lcs-buttons*)
           (push
                (make-dialog-item :widget 'button
                       :title "Load"
                       :set-value-fn #'(lambda (&rest x) (load-or-close))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p t
                       :box (make-box
                                       (round (/ (* 3 (box-width (visible-box out-dialog))) *number-of-buttons*)) 0
                                       (box-width (visible-box out-dialog)) 25))
                *lcs-buttons*)
          (update-dialog out-dialog (cons help-button *lcs-buttons*))))
      
     
