(in-package :lcs)

(defparameter cs-parameters nil)

(defun make-cs-parameters ()
   (setq cs-parameters 
      (let (dialog)
         (setq dialog 
            (open-dialog 
               (list 
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 150 18 210 42) :value 
                     *population-size* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :population-size-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 150 58 210 82) :value 
                     *message-list-size* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :message-list-size-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 150 100 210 122) 
                     :value *condition-length* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :condition-length-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 150 138 210 162) 
                     :value *action-length* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :action-length-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 150 178 210 202) 
                     :value *initial-strength* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :initial-strength-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 370 18 430 42) :value 
                     *cbid* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :cbid-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 370 58 430 82) :value 
                     *bid1* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :bid1-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 370 98 430 122) :value 
                     *bid2* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :bid2-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 370 138 430 162) 
                     :value *bidtax* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :bid-tax-val)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                     :tabstop t :box #.(make-box 370 178 430 202) 
                     :value *lifetax* :font 
                     (make-font nil :courier\ new 16 nil) :name 
                     :life-tax-val)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 300 180 360 200) :value "life tax" 
                     :font (make-font nil :arial 16 '(:bold)) :name 
                     :life-tax)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 300 140 360 160) :value "bid tax" 
                     :font (make-font nil :arial 16 '(:bold)) :name 
                     :bid-tax)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 300 100 360 120) :value "bid2" :font 
                     (make-font nil :arial 16 '(:bold)) :name :bid2)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 300 60 360 80) :value "bid1" :font 
                     (make-font nil :arial 16 '(:bold)) :name :bid1)
                  (make-dialog-item :widget 'default-button :groupstart nil 
                     :tabstop nil :box #.(make-box 370 235 430 260) 
                     :set-value-fn 'save-cs-parameters
                     :font (make-font nil :arial 16 '(:bold)) :name :ok 
                     :title "OK")
                  (make-dialog-item :widget 'button :groupstart nil 
                     :tabstop nil :box #.(make-box 270 235 330 260) 
                     :set-value-fn 'set-cs-default-values
                     :font (make-font nil :arial 16 '(:bold)) :name :default
                     :title "Default")
                  (make-dialog-item :widget 'button :groupstart nil 
                     :tabstop nil :box #.(make-box 170 235 230 260) 
                     :font (make-font nil :arial 16 '(:bold)) :name 
                     :help :title "Help")
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t  
                     :box #.(make-box 300 20 360 40) :value "cbid" :font 
                     (make-font nil :arial 16 '(:bold)) :name :cbid)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 20 180 140 200) :value 
                     "initial strength" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :initial-strength)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 20 140 140 160) :value "action length" 
                     :font (make-font nil :arial 16 '(:bold)) :name 
                     :action-length)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 20 100 140 120) :value 
                     "condition length" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :condition-length)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 20 60 140 80) :value 
                     "message list size" :font 
                     (make-font nil :arial 16 '(:bold)) :name 
                     :message-list-size)
                  (make-dialog-item :widget 'static-text :groupstart t 
                     :tabstop nil :background-color t :box 
                     #.(make-box 20 20 140 40) :value "population size" 
                     :font (make-font nil :arial 16 '(:bold)) :name 
                     :population-size))
               'dialog *lisp-main-window* :name :cs-parameters :title 
               "CS-parameters" :font 
               (make-font :swiss :system 20 '(:bold)) :window-state 
               :normal :user-movable t :user-resizable nil :user-closable nil
               :user-shrinkable nil :user-scrollable nil 
               :window-border :dialog-box
               :background-color (make-rgb :red 0 :green 128 :blue 128) 
               :pop-up-p nil :visible-box #.(make-box 0 0 450 270))))))



(defun cs-parameters ()
    (make-cs-parameters))
