(in-package :lcs)

(defun save-cs-parameters (widget new-value old-value)
      (setf *population-size*
          (dialog-item-value (nth 0 (dialog-items cs-parameters))))
      (setf *message-list-size*
          (dialog-item-value (nth 1 (dialog-items cs-parameters))))
      (setf *condition-length*
          (dialog-item-value (nth 2 (dialog-items cs-parameters))))
      (setf *action-length*
          (dialog-item-value (nth 3 (dialog-items cs-parameters))))
      (setf *initial-strength*
          (dialog-item-value (nth 4 (dialog-items cs-parameters))))
      (setf *cbid*
          (dialog-item-value (nth 5 (dialog-items cs-parameters))))
      (setf *bid1*
          (dialog-item-value (nth 6 (dialog-items cs-parameters))))
      (setf *ebid1*
          (dialog-item-value (nth 6 (dialog-items cs-parameters))))
      (setf *bid2*
          (dialog-item-value (nth 7 (dialog-items cs-parameters))))
      (setf *ebid2*
          (dialog-item-value (nth 7 (dialog-items cs-parameters))))
      (setf *bidtax*
          (dialog-item-value (nth 8 (dialog-items cs-parameters))))
      (setf *lifetax*
          (dialog-item-value (nth 9 (dialog-items cs-parameters))))
      (close cs-parameters)
     (set-menu-item-available-p (find-named-object :run *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :stop *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :step *lisp-menu-bar*) nil)
     (set-menu-item-available-p (find-named-object :run-ga *lisp-menu-bar*) nil))
     

(defun set-cs-default-values (widget new-value old-value)
     (cs-default-values)
     (set-dialog-item-value (nth 0 (dialog-items cs-parameters)) *population-size*)
     (set-dialog-item-value (nth 1 (dialog-items cs-parameters)) *message-list-size*)
     (set-dialog-item-value (nth 2 (dialog-items cs-parameters)) *condition-length*)
     (set-dialog-item-value (nth 3 (dialog-items cs-parameters)) *action-length*)
     (set-dialog-item-value (nth 4 (dialog-items cs-parameters)) *initial-strength*)
     (set-dialog-item-value (nth 5 (dialog-items cs-parameters)) *cbid*)
     (set-dialog-item-value (nth 6 (dialog-items cs-parameters)) *bid1*)
     (set-dialog-item-value (nth 7 (dialog-items cs-parameters)) *bid2*)
     (set-dialog-item-value (nth 8 (dialog-items cs-parameters)) *bidtax*)
     (set-dialog-item-value (nth 9 (dialog-items cs-parameters)) *lifetax*))


(defun change-cs-parameter  (widget new-value old-value)
       (set-dialog-item-value widget (eval new-value)))

(defun cs-graphics ()
     (if (not cs-graphics-on?)
        (progn
           (setf cs-graphics-on? t)
           (set-menu-item-selected-p
              (find-named-object :cs-graphics *lisp-menu-bar*) t)
            (cs-population)
            (show-message-list))
        (progn
           (setf cs-graphics-on? nil)
           (set-menu-item-selected-p
              (find-named-object :cs-graphics *lisp-menu-bar*) nil)
            (close cs-population)
            (close show-message-list))))
        
        

(defun graphics-cs-init ()
     (when cs-graphics-on?
       (let ((p (population-string-last)))
         (set-dialog-item-range (nth 3 (dialog-items cs-population))
              (cons "classifier          strength " p)))))

(defun graphics-cs-end ()
     (when cs-graphics-on?
       (let ((p (population-string-new)))
         (set-dialog-item-range (nth 0 (dialog-items cs-population))
              (cons "classifier          strength     bid " p)))))
              


(defun population-string-last ()
     (mapcar #'cl-string2-last (population *evolution*)))

(defun population-string-new ()
     (mapcar #'cl-string2-new (population *evolution*)))



(defun cl-string2-last (l)
     (concatenate 'string
         (cl-string (the-condition l))
         " : "
         (cl-string (the-action l))
         (format nil "    ~5,2F" (strength l))
         (when (winner-flag l) "    Win")))

(defun cl-string2-new (l)
     (concatenate 'string
         (cl-string (the-condition l))
         " : "
         (cl-string (the-action l))
         (format nil "    ~5,2F" (strength l))
         (when (matchflag l) (format nil "   ~5,2F" (bid l)))
         (when (winner-flag l) "    Win")))

(defun cl-string (l &optional accu)
     (if l
        (cl-string
         (cdr l)
         (concatenate 'string accu
             (case (car l)
                 (1 "1")
                 (0 "0")
                 (-1 "#"))))
        accu))

     
(defun show-message-list-init ()
     (when cs-graphics-on?
       (let ((m-l (message-list-string)))
         (set-dialog-item-range 
            (find-named-object :last-message-list show-message-list) m-l))))

(defun show-message-list-end ()
     (when cs-graphics-on?
       (let ((m-l (message-list-string)))
         (set-dialog-item-range 
            (find-named-object :new-message-list show-message-list) m-l))))


(defun message-list-string ()
     (mapcar #'ml-string2 (message-list *evolution*)))

(defun ml-string2 (l)
     (concatenate 'string
         (cl-string (message l))
         "     "
         (if (equal (by-classifier l) 'input) "INPUT" "")))
            