(in-package :lcs)

(defparameter cs-population nil)

(defun make-cs-population ()
      (setq cs-population 
            (open-dialog ()
                  'dialog *lcs-main-window* :name :cs-population
                  :title "CS population"
                  :font (make-font :swiss :system 16 '(:bold))
                  :user-movable t :user-resizable nil :user-closable nil 
                  :user-shrinkable nil :user-scrollable nil 
                  :window-border :dialog-box
                  :background-color (make-rgb :red 0 :green 128 :blue 128) 
                  :pop-up-p nil
                  :window-exterior
                  (make-box
                         20 20
                         (- (round (/ (box-width (window-interior *lcs-main-window*)) 2)) 50)
                         (- (box-height (window-interior *lcs-main-window*
                                                   )) 200))))
      (update-dialog cs-population
            (list 
               (make-dialog-item :widget 'single-item-list 
                      :box (make-box
                                      (+ (round (/ (box-width (window-interior cs-population)) 2)) 5)
                                      30
                                      (- (box-width (window-interior cs-population)) 5)
                                      (- (box-height (window-interior cs-population)) 5))
                      :font (make-font nil :times\ new\ roman 12 '(:bold))
                      :name :new-pop)
               (make-dialog-item :widget 'static-text
                      :background-color t
                      :box (make-box
                                      (+ (round (/ (box-width (window-interior cs-population)) 2)) 30)
                                      5
                                      (- (box-width (window-interior cs-population)) 5)
                                      25)
                      :value "New population"
                      :font (make-font nil :arial 16 '(:bold))
                      :name :new-pop-text)
               (make-dialog-item :widget 'static-text
                      :background-color t
                      :box (make-box
                                      30 5
                                      (- (round (/ (box-width (window-interior cs-population)) 2)) 5)
                                      25)
                      :value "Last population" 
                      :font (make-font nil :arial 16 '(:bold))
                      :name :last-pop-text)
               (make-dialog-item :widget 'single-item-list 
                      :box (make-box
                                      5 30
                                      (- (round (/ (box-width (window-interior cs-population)) 2)) 5)
                                      (- (box-height (window-interior cs-population)) 5))
                      :font (make-font nil :times\ new\ roman 12 '(:bold))
                      :name :last-pop)))
      cs-population)

(defun cs-population ()
   (make-cs-population))
