;;; *******************************
;;; *    PORTABLE  AI  LAB   -   IDSIA   *
;;; *******************************
;;;
;;; Filename:      stats.lsp
;;; Short Desc:  Report procedures for CS
;;; Version:         1.0
;;; Status:           Review
;;; Last Mod:      09.01.94
;;; Author:          Roberto Limeres
;;;
;;; Copyright (c) 1994 Instituto Dalle Molle (IDSIA), University  of
;;; Zurich, Swiss Federal Institte of Technology Lausanne
;;;
;;; Permision is granted to any individual  or  institution  to  use,
;;; copy, modify, and distribute this software, provided that this
;;; complete  copyright  and  permission  notice  is   maintained,
;;; intact, in all copies and supporting documentation.
;;;
;;; IDSIA provides this  software  "as  is"  without  expresed  or
;;; implied warranty.
;;;

;;; -------------------------------------------------
;;; Change History:
;;; Files required:      stats.lsp          (this file)
;;;                                   declare.lsp     (declaration file)
;;; -------------------------------------------------

(in-package :lcs)


;;; ====================================================
;;; Accumulator
;;; ====================================================

(defvar *acc* 0.0)


;;; ====================================================
;;; Re-evaluation of population statistics
;;; ====================================================

(defmethod evaluate ((p population))
      (mapcar #'evaluate (population p)))

(defmethod evaluate :before ((p population))
      (setq *acc* 0.0))

(defmethod evaluate :after ((p population))
      (setf (sum-strength p) *acc*)
      (setf (avg-strength p) (/ *acc* *population-size*))
      (setf (max-strength p) (strength (find-best (population p))))
      (setf (min-strength p) (strength (find-worst (population p)))))

(defmethod evaluate ((cl classifier))
      (if (> (strength cl) 0.0) (setf *acc* (+ *acc* (strength cl)))))


;;; ====================================================
;;; Utility functions
;;; ====================================================

(defun find-best (l &optional (max (car l)))
      (if l
         (if (> (strength (car l)) (strength max))
            (find-best (cdr l) (car l))
            (find-best (cdr l) max))
         max))

(defun find-worst (l &optional (min (car l)))
      (if l
         (if (< (strength (car l)) (strength min))
            (find-worst (cdr l) (car l))
            (find-worst (cdr l) min))
         min))


;;; ====================================================
;;; Method REPORT
;;; Report population statistics
;;; ====================================================

(defmethod report ((p population))
      (format t "~%~%Classifier    Strength    bid      ebid~%")
      (format t     "----------------------------------------~%~%")
      (dolist (cl (population p))
            (format t "~A    ~5,2F      ~5,2F    ~5,2F~%"
                 (format-classifier cl)
                 (strength cl)
                 (bid cl)
                 (ebid cl)))
      (format t "~%~%MATCH-LIST~%~%")
      (dolist (cl (match-list p))
            (format t "~A    ~A~%"
                 (format-classifier(first cl))
                 (second cl)))
      (format t "~%~%WINNERS~%~%")
      (dolist (cl (winners p))
            (format t "~A~%"
                 (format-classifier cl))))


;;; ====================================================
;;; Method FORMAT-CLASSIFIER
;;; Convert a classifier to a string
;;; ====================================================

(defmethod format-classifier ((cl classifier))
      (let ((the-string ""))
          (dolist (cond (the-condition cl))
                (setf the-string
                          (concatenate 'string the-string
                                (case cond
                                      ((0)  "0")
                                      ((1)  "1")
                                      ((-1) "#")))))
          (setf the-string 
                    (concatenate 'string the-string ":["))
          (dolist (act (the-action cl))
                (setf the-string
                          (concatenate 'string the-string
                                (case act
                                      ((0)  "0")
                                      ((1)  "1")))))
          (setf the-string 
                    (concatenate 'string the-string "]"))))
