;;; *******************************
;;; *    PORTABLE  AI  LAB   -   IDSIA   *
;;; *******************************
;;;
;;; Filename:      util.lsp
;;; Short Desc:  General porpose procedures
;;; Version:         1.0
;;; Status:           Review
;;; Last Mod:      09.01.94
;;; Author:          Roberto Limeres
;;;
;;; Copyright (c) 1994 Instituto Dalle Molle (IDSIA), University  of
;;; Zurich, Swiss Federal Institte of Technology Lausanne
;;;
;;; Permision is granted to any individual  or  institution  to  use,
;;; copy, modify, and distribute this software, provided that this
;;; complete  copyright  and  permission  notice  is   maintained,
;;; intact, in all copies and supporting documentation.
;;;
;;; IDSIA provides this  software  "as  is"  without  expresed  or
;;; implied warranty.
;;;

;;; --------------------------------------------------
;;; Change History:
;;; Files required:     util.lsp              (this file)
;;;                                  declare.lsp     (declaration file)
;;; --------------------------------------------------

(in-package :lcs)


;;; ====================================================
;;; Random functions
;;; ====================================================

(defun rndom ()
      (random 1.0))

(defun flip (p)
      (< (random 1.0) p))

(defun rnd (n)
      (random n))

(defun rnd-element (l)
      (if l 
         (car (nthcdr (rnd (length l)) l))))

(defun rnd-element-1 (l but-not-this)
      (if l
         (rnd-element (set-difference l (list but-not-this)))))

(defun random-list (length type)
      (if (> length 0)
         (cons (rnd-element type)
               (random-list (1- length) type))))
	   
;;; ====================================================
;;; Sort functions
;;; ====================================================

(defun firstn (n l)
      (when (> n 0)
           (if (> n (length l))
              l            
              (cons (car l) (firstn (1- n) (cdr l))))))

(defun my-sort (boolean-function l)
      (let ((result nil))
          (dolist (elem l result)
                (setq result (intr-sort elem result boolean-function)))))

(defun intr-sort (elem l boolean-function)
      (if (apply boolean-function (list elem (car l)))
         (cons elem l)
         (cons (car l) (intr-sort elem (cdr l) boolean-function))))


;;; ====================================================
;;; Decode functions
;;; ====================================================

(defun decode (l &optional (accu 0) (i 0))
      (if l
         (decode (cdr l)
          (+ accu
              (* (expt 2 i)
                  (if (= (car l) -1) 0.5 (car l))))
          (1+ i))
         accu))


;;; ====================================================
;;; Identity function (for tests)
;;; ====================================================

(defun ident (x) x)


;;; ====================================================
;;; Normal distributed random numbers, after 
;;; ACM algorithm 167 / Box-Muller Method
;;; ====================================================

(defvar rndcalcflag t)
(defvar rndx1 0.0)
(defvar rndx2 0.0)

(defun noise-aux ()
      (if rndcalcflag
         (let ((tt (* 6.2831853072 (random 1.0))))
             (setf rndx1 (sqrt (* -2.0 (log (random 1.0)))))
             (setf rndx2 (* rndx1 (sin tt)))
             (setf rndcalcflag nil)
             (* rndx1 (cos tt)))
         (progn
              (setf rndcalcflag t)
              rndx2)))

(defun noise (mu sigma)
      (+ (* (noise-aux) sigma) mu))