;; >>> dublchar.lsp
;; NOT merged (and probably will never be)

;; This works around the curiosity where if text-edit-pane will double
;; characters typed into it if some ancestor of the pane is a dialog.
;; We can keep this around as a patch for the occaissional customer who
;; puts a text-edit-pane (as opposed to a multi-line-editable-text widget)
;; onto a dialog, but it's probably not worth the expense of checking
;; for this upon every typed characters to put this hack into the
;; master source code.  See <qqq> below for changes.  For [pcspr1743].
;; Probably will not merge this since it has to check through all
;; the ancestors of the text-edit-pane with each keystroke and therefore
;; may add a bit of inefficiency, while it's probably unusual that a
;; user will need to put a text-edit-pane or -window (as opposed
;; to a multi-line-editable-text widget) onto a dialog window.

(in-package 'text-edit)

;; not in a user lisp
(defparameter text-widget-cursor-keys
   `(,vk-left ,vk-right ,vk-up ,vk-down
     ,vk-home ,vk-end ,vk-pagedown ,vk-pageup ,vk-delete))

;; from textedit\tewmess.lsp
(defmethod event ((tep text-edit-pane) (event-number (eql virtual-key-down))
                  buttons data time)
   (let ((dialog-item (slot-value tep 'pc::dialog-item)))
      ;; added this cond clause (chee 11/92 for [pcbug256])
      ;; for some reason this removes the double chars
      (cond (dialog-item
               (select data
                  ;; Allow tabbing out of a multi-line widget, as long
                  ;; as you can tab into it; otherwise we may want to
                  ;; interpret the tab within the widget.
                  ((vk-tab vk-backtab)
                   (if (logtest alt-key buttons) ;; <8>
                      (call-next-method)
                      (when (dialog-item-tabstop dialog-item)
                         (cg::tab-to-next-widget dialog-item
                          (eq data vk-backtab)))) ;; <2>
                   )
                  ;; Unclear why these are the only keys we need to
                  ;; pass back to Windows; passing back characters causes
                  ;; doubling of typed characters
                  (#.text-widget-cursor-keys (call-next-method))
                  ))
            (t
               ;; must treat delete and enter specially
               (select data
                  (vk-delete (:delete tep))
                  (vk-enter (return-to-reader tep))
                  (t (unless (and (on-dialog-p tep) ;; <qqq>
                                  (not (member data text-widget-cursor-keys
                                          :test #'eq)))
                        (call-next-method))))))))

;; new function
(defun on-dialog-p (window)
   ;; Returns non-NIL if some ancestor of WINDOW is a dialog
   (let ((parent (window-parent window)))
      (and (windowp parent)
           (or (dialogp parent)
               (on-dialog-p parent)))))

;; from textedit\tewmess.lsp
(defmethod event ((tep text-edit-pane) (event-number (eql character))
				       buttons data time)
  (when (input-stream-p tep)
    (case data 
      (#\Backspace (delete-previous-character tep))
      (#\Newline 
       (if (on-dialog-p tep) ;; <qqq>
          #+old (slot-value tep 'pc::dialog-item) ;; <qqq>
          ;; if a widget, not an editor window, insert cr/lf
          ;; (chee 11/92 for [pcbug258] (why is this necessary?))
          (device-write-string tep crlf-only 0 2)
          (simple-insert-character tep #\Newline)))
       (t
         (insert-character tep data))
       )))

