;;; -*- Mode: LISP; Package: pail-lib; Syntax: Common-lisp; -*-
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   browser.cl
;;; Short Desc: implements class for browsers
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   12.5.92 dta
;;; Author:     DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; --------------------------------------------------------------------------
;;; Change History: 
;;; Written 4.1.91
;;; Extended 10.6.91 to support some default menues
;;; Extended 22.10.91 to add scrollbars and multiple trees
;;; 12.5.92 Added overall browser functions (title items) 
;;; --------------------------------------------------------------------------
;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================
;;;
;;;
(in-package :pail-lib)

(export '(pail-open pail-new pail-close pail-save pail-save-as))


(defclass pail-edit-window (text-edit-window)
      ())

(defmethod pail-open (window)
      (let ((path (pop-up-open-file-dialog
                                window
                                nil
                                "Open File"
                                "Enter file to open"
                                "*.*"
                                nil)))
          (when path
                 (te::load-file
                      (open-stream 'pail-edit-window window :input) path))))


(defmethod pail-save (window)
      (let ((win (front-window window)))
      (when (equal (class-of win) (find-class 'pail-edit-window))
             (:save (front-window window)))))


(defmethod pail-save-as (window)
      (let ((win (front-window window)))
      (when (equal (class-of win) (find-class 'pail-edit-window))
             (te::save-file (front-window window)))))
      