;;; -*- Mode: LISP; Package: pail-lib; Syntax: Common-lisp; -*-
(in-package :pail-lib)

;;; ==============================================================================
;;; Paolo Cattaneo - January 1993
;;; ==============================================================================

(export
          '(sequence-window
            menu-bar-button
            delete-from-sequence-from-menu-button
            delete-from-sequence
            add-to-sequence
            add-to-sequence-from-menu-button
            reset-table
            save-p
            wsequence))



(defvar *button-bar-height* 25)

(defvar *button-bar-font*
      (make-font nil :arial 16 '(:bold)))

(defvar *sequence-font*
      (make-font :modern nil 14))



(defclass sequence-window (dialog)
       ((wsequence         
               :initarg :wsequence
               :accessor wsequence
               :initform nil)
        (filename :initarg :filename
         :initform ""
         :accessor filename)
        (prompt 
                       :initarg :prompt
                       :initform ""
                       :accessor prompt)
        (save-function :initarg :save-function
         :initform nil
         :accessor save-function)
        (button-menu-bar      
              :initarg :button-menu-bar
              :initform '(("Add" 'add-to-sequence-from-menu-button)
                                 ("Delete" 'delete-from-sequence-from-menu-button)
                                 ("Close" 'close-sequence-window))
              :accessor button-menu-bar)))


(defun close-sequence-window (item)
      (close item))


(defclass sps (single-item-list) 
       ((sequence-needs-saving-p 
              :initarg :save-p
              :accessor save-p
              :initform nil)))



(defclass menu-bar-button (button)
       ((view-container
            :initarg :view-container
            :initform nil
            :accessor view-container)))



(defmethod initialize-instance :after ((sw sequence-window) &rest otherkeys &key sequence)
      (let ((buttons (create-buttons sw))
             (size (if (< 2 (length sequence)) (length sequence)
                              2)))
          (setf (wsequence sw) 
                    (make-dialog-item :widget 'sps
                           :box (make-box 0 0 0 0)
                           :font *sequence-font*
                           :range sequence))
          (update-dialog sw
                (push (wsequence sw) buttons))
          (resize-window sw (make-position
                                                       (max (* 8 (max-length sequence))
                                                                 (* 60 (length (button-menu-bar sw))))
                                                       (min (+ *button-bar-height* (* 15 size))
                                                                (round ( * 0.7 (box-height (clipping-box *screen*)))))))))



(defmethod resize-window :after ((sw sequence-window) position)
      (let* ((items (dialog-items sw))
                (number-of-buttons (length (cdr items)))
                (button-h-size (round (/ (box-width (window-interior sw))
                                                             number-of-buttons)))
                (button-v-size *button-bar-height*)
                (button-h-pos 0))
          (set-dialog-item-box (first items)
                (make-box
                       0 *button-bar-height*
                       (box-width (window-interior sw))
                       (box-height (window-interior sw))))
          (dolist (item (cdr items))
                (set-dialog-item-box item
                      (make-box
                             button-h-pos
                             0
                             (+ button-h-pos button-h-size)
                             button-v-size))
                (setf button-h-pos (+ button-h-pos button-h-size)))))
      


(defun max-length (s &optional (result 0))
      (if s
         (max-length (cdr s) (max result (length (car s))))
         result))



(defmethod delete-from-sequence-from-menu-button ((item menu-bar-button))
      (let ((container (view-container item)))
          (delete-from-sequence container
                (dialog-item-value (wsequence container)))
          (resize-window container)))



(defun my-delete ( a b)
      (let ((result nil))
          (dolist (item b (reverse result))
                (when (string/= item a)
                       (push item result)))))
          


(defmethod delete-from-sequence ((sw sequence-window) selected-cell)
      (let* ((sps  (wsequence sw))
                (cells (dialog-item-range sps))
                (new-cells (my-delete selected-cell cells)))
          (when (yes-or-no-p
                             (concatenate 'string
                                   "Are you sure you want do delete "
                                   selected-cell))
                 (progn
                      (set-dialog-item-range sps new-cells)
                      (setf (save-p sps) t)
                      (set-dialog-item-value sps nil)
                      (dialog-item-range sps)))))



(defmethod add-to-sequence-from-menu-button ((mbb menu-bar-button))
     (let ((sw (view-container mbb)))
      (multiple-value-bind (item other value)
              (ask-user-for-string 
                    "Please, enter a new item"
                    "" "Cancel" "Add")
             (when (and
                                    (string/= value "Cancel")
                                    (string/= item ""))
                    (add-to-sequence sw item)
                  (resize-window
                      sw 
                      (make-position
                           (max (* 8 (max-length sequence))
                                                                 (* 60 (length (button-menu-bar sw))))
                                                       (min (+ *button-bar-height* (* 15 (length sequence)))
                                                            (round ( * 0.7 (box-height (clipping-box *screen*)))))))))))



(defmethod add-to-sequence ((sw sequence-window) item)
      (let ((sps (wsequence sw)))
          (set-dialog-item-range sps
                (append (dialog-item-range sps)
                      (list (string-upcase item))))
          (setf (save-p sps) t)
          (dialog-item-range sps)))






(defmethod create-buttons ((s sequence-window))
      (let* ((buttons (button-menu-bar s))
                (number-of-buttons (length buttons))
                (button-h-size (round (/ (box-width (window-interior s))
                                                             number-of-buttons)))
                (button-v-size *button-bar-height*)
                (button-h-pos 0)
                (result nil))
          (dolist (b buttons result)
                (push
                      (make-dialog-item :widget 'menu-bar-button
                             :font *button-bar-font*
                             :box (make-box 0 0 0 0)
                             :view-container s
                             :title (first b)
                             :set-value-fn `(lambda (item new old)
                                                            (funcall ,(cadr b) item)))
                      result)
                (setf button-h-pos (+ button-h-pos button-h-size)))))

      
      
;;; (defmethod size-menubar-buttons ((s sequence-window))
;;;       (let* ((buttons (button-menu-bar s))
;;;                 (number-of-buttons (length buttons))
;;;                 (button-h-size (round (/ (point-h (view-size s)) number-of-buttons)))
;;;                 (button-v-size *button-bar-height*)
;;;                 (button-h-pos 0))
;;;           (do-subviews (button s 'menu-bar-button)
;;;            (set-view-position button (make-point button-h-pos 0))
;;;            (set-view-size button (make-point button-h-size button-v-size))
;;;            (setf button-h-pos (+ button-h-pos button-h-size)))))
           
