;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   trees.cl  
;;; Short Desc: class definition for trees
;;; Version:    2.0
;;; Status:     Review
;;; Last Mod:   5.2.91 TW
;;; Author:     DTA SK TW
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;
;;; -*- Mode: LISP; Package: PAIL-LIB; Syntax: Common-lisp; -*-
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;; Moved from trees.cl because the class rule-set need not always be
;;; loaded  before the trees file.
;;; --------------------------------------------------------------------------

(in-package :pail-lib)

(export '(tree-to-rules))



;;; Given a decision tree, produces a rule set with the same behavior.

(defmethod tree-to-rules ((dtree decision-tree))
      (make-instance 'rule-set
             :name-part "Rule-set"
             :rule-set-part
             (mapcar #'make-rule-from-path
                    (get-paths dtree))))



(defun make-rule-from-path (path)
      (make-instance 'rule
             :name-part "ID3-Rule"
             :if-part
             (do* ((l path (cddr l))
                       (result nil
                            (cons (list (second l) (first l)) result)))
                      ((null (cddr l)) result))
             :then-part (list (second path) (first path))))



;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
