;;; -*- Mode: LISP; Package: rbs; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rbs-ex1.cl
;;; Short Desc: 1st demo for rbs
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :rbs)



(defun start-demo-1 ()
      (when 
               (create-demo-dialog  
                :window-title "RBS Demos"
                :title "Rule Based Systems"
                :subtitle "A First Demo"
                :helpfile "rbs\\help\\rbs-d1.asc"
                :window *rbs-main-window*)
             (progn
                  (setq *rbs-demo-running* t)
                  (catch 'stop-demo (main-demo-1))
                  (setq *rbs-demo-running* nil))))


(defun main-demo-1 ()
      (format-demo "This is the first RBS demo.

")
      
      (demo-loop)
      (format-demo "First we load the Initial Data Base.

")

      (demo-loop)
      (setq *current-db-file*
            (concatenate 'string
                  *pail-directory*
                  "rbs\\database\\family.dbf"))
      (setq *database*
            (rd-object-file 'assertion-database *current-db-file*))
      (create-database-window (list-of-assertions *database*))
      (setq *result-database* nil)
      (set-menu-after-load-data-base)

      (demo-loop)
      (format-demo "Now we load the Rule Base.

")

      (demo-loop)
      (setq *current-rb-file*
            (concatenate 'string
                  *pail-directory*
                  "rbs\\rulebase\\family.rbf"))
      (setq *f-rulebase*
            (rd-object-file 'rule-database *current-rb-file*))
      (setq *b-rulebase*
            (rd-object-file 'horn-rule-database *current-rb-file*))
      (create-rulebase-window (list-of-rules (or *f-rulebase* *b-rulebase*)))
      (set-menu-after-load-rule-base)
      
      (demo-loop)
      (format-demo "We call the backward chainining procedure.
We look for the goal (sibling ?x ?y)

")
      (demo-loop)
      (backchain '((sibling ?x ?y)) *b-rulebase* *database*)
      (demo-loop)
      (format-demo "We call the forward chainining procedure.

")

      (demo-loop)
      (forward-chain)
      (demo-loop)
      
      (format-demo "We can look at the tree forming
the new assertions.

")
      
      (demo-loop)

      (set-dialog-item-value
            (wsequence *result-database-dialog*)
            (car (last (dialog-item-range
                                   (wsequence *result-database-dialog*)))))
      (view-data-tree)
      
      (demo-loop)
      (format-demo "End of Demo")
      (demo-loop)
      
      (close-database-window)
      (close-rulebase-window))
      
