;;; -*- Mode: LISP; Package: rbs; Syntax: Common-lisp;
;;; -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   evalpat.cl
;;; Short Desc: built in predicates for rbs
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4.94 - MR
;;; Author:     Michael Rosner
;;;
;;; --------------------------------------------------------------------------
;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
 
;;; --------------------------------------------------------------------------
   
;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
   

(in-package :rbs)



(defconstant *special* '(= < > *is *isvar *neq *pvars *eval *lisp))



(defun is-special (p)
      (and (listp p) (member (car p) *special*)))



(defun renveval (p)
      (mapcar #'(lambda (x)
                               (if (is-special x)
                                  (evalspecial (car x) (cdr x) nil nil)
                                  x))
             p))


  
;;; EVALUATION OF BUILT-IN PREDICATES

;;; levalpat <pattern> <environment> => <environment> if success
                                     => *fail* otherwise

(defun levalpat (p e)
      (let ((result (evalspecial (car p) (cdr p) (varsin p nil) e)))
          (cond ((eq result *fail*) *fail*)
                      (t result))))



;;; evalspecial <predicate arguments variables alist>
;;  note that the last clause of the case permits an ordinary lisp
;;  function to be used provided that:
;;
;; - it is on the *special* list
;; - it does not modify the environment
;; - it does not return nil when success is intended

(defun evalspecial (pred args vars env)
      (case pred
            (*is (unify (car args) (eval (enveval (cadr args) env)) env))
            (*isvar (cond ((isvar (lookupval (car args))) env)
                                      (t *fail*)))
            (= (unify (car args) (cadr args) env))
            (*neq 
                  (setq args (enveval args env))
                  (cond ((eq (car args) (cadr args)) *fail*)
                              (t env)))
            (*pvars 
                  (terpri)
                  (mapc
                         (function (lambda (x)
                                                (format t "~%~A = ~A" x (lookupval x env))))
                         vars)
                  env)
            (*lisp (eval (car args)))
            (t
                (let ((result (apply pred (renveval (enveval args env)))))
                    (cond (result env)
                                (t *fail*))))))
  
    

;;; revalpat <pattern> <rule> <env> <database>
;;; returns nil for special forms to indicate
;;; that the database has not changed, and thus
;;; that rules need not be applied again.
;;; revalpat also encodes the implicit assumption
;;; that rhs is added to the database.

(defun revalpat (p r env db)
      (setq p (enveval p (car env)))
      (setq p (renveval p))
      (when (store (make-assertion p) db (cons r (cdr env)))
             (format-display *rbs-output-window*
                  "Adding asssertion ~A~%" p)
             t))
             

    



