(in-package :rbs)



;;; forward chain <ruleset> on database <db>
;;

(defun f-chain (ruleset db)
      (let ((more t)
              (change nil))
          (format-display *rbs-output-window*
               " ~%~% Forward chaining...~%~%")
          (loop
              (cond
                          (more
                                 (setq more nil)
                                 (mapc (lamda (r)
                                                  (and (xrule r db)
                                                           (setq change t)
                                                           (setq more t)))
                                        (itemlist ruleset)))
                          (t (return change))))
          (format-display *rbs-output-window*
               "~% Forward chainer finished.~%")
          change))
          


;;;execute a single rule. If the xrule returns true
;;;then something (eg the database) is assumed to have
;;;changed and ruleset will be applied again.

(defun xrule (r db)
      (let ((listenv (fetch (lhs r) db))
              (new nil))
          (and listenv
                   (mapc
                          (lamda (e)
                              (mapc (lamda (p) (and (xrhs p r e db)
                                                                         (setq new t)))
                                     (rhs r)))
                          listenv))
          new))	  	  



;;; xrhs <pattern> <rule> <env> <database>
;;; returns nil for special forms to indicate
;;; that the database has not changed, and thus
;;; that rules need not be applied again.
;;; revalpat also encodes the implicit assumption
;;; that rhs is added to the database.

(defun xrhs (p r env db)
      (cond 
                  ((is-special p)
                   (format-display *rbs-output-window*
                        " Special assertion ~A~%" p)
                   (evalspecial (car p) (cdr p) (varsin p nil) (car env))
                   nil)
                  (t (revalpat p r env db))))
                     
;;;                       (setq p (enveval p (car env)))
;;;                      (when (store (make-assertion p) db  (make-reason r env))
;;;                             (format-display *rbs-output-window*
;;;                                  " Adding assertion ~A~%" p)
;;;                             t))))
;;;                             


(defun make-reason (rule fetch-result)
  (cons rule (cdr fetch-result)))




