;;; -*- Mode: LISP; Package: rbs; Syntax: Common-lisp; -*-

(in-package :rbs)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   rbs-browser.cl
;;; Short Desc: A browser to show proof trees
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================



(defparameter *description-trees* nil)
      
      
      
(defclass rbs-tree (tree)
       ((rule
             :initarg :rule
             :initform nil
             :accessor rule)))

        
        
(defclass rbs-browser (browser)
       ((rule-descriptions
             :initarg :rule-descriptions
             :initform nil
             :accessor rule-descriptions)))



(defmethod window-close ((a rbs-browser))
     (dolist (descriptions (rule-descriptions a))
          (when (windowp descriptions)
               (window-close descriptions)))
     (close a))




(defclass rbs-browser-dialog (dialog)
      ())

(defmethod initialize-instance :after ((a rbs-browser-dialog)  &rest keys)
     (push a (rule-descriptions a)))

(defmethod window-close ((a rbs-browser-dialog))
     (delete a (rule-descriptions a))
     (close a))




(defmethod pail-lib::browser-select-item ((b rbs-browser) item mousestate)
      (let* ((description (dialog-item-title item))
                (meaning (read-from-string description))
                (result (rule-to-string meaning))
                (resultA (first result))
                (resultB (second result))
                (browser-item-description
                 (open-dialog ()
                       'dialog (wtree b)
                       :user-closable nil :user-movable nil
                       :user-resizable nil :user-shrinkable nil
                       :user-scrollable nil :pop-up-p nil
                       :window-border :dialog-box
                       :font (make-font :modern nil 10 '(:bold))
                       :window-exterior
                       (make-box
                              (- (box-right (dialog-item-box item))
                                 (position-x (scroll-position (wtree b))))
                              (- (box-top (dialog-item-box item))
                                 (position-y (scroll-position (wtree b))))
                              (- (+ (box-right (dialog-item-box item)) 60
                                      (* 5 (lengthm result)))
                                 (position-x (scroll-position (wtree b))))
                              (- (+ (box-top (dialog-item-box item)) 33)
                                 (position-y (scroll-position (wtree b))))))))
          (update-dialog browser-item-description
                (list
                   (make-dialog-item :widget 'static-text
                          :box (make-box 5 2 (+ (* 5 (lengthm result)) 10) 12)
                          :value resultA)
                   (make-dialog-item :widget 'static-text
                          :box (make-box 5 12 (+ (* 5 (lengthm result)) 10) 32)
                          :value resultB)
                   (make-dialog-item :widget 'default-button
                          :box (make-box
                                          (+ 15 (* 5 (lengthm result)))
                                          1
                                          (+ 45 (* 5 (lengthm result)))
                                          22)
                          :set-value-fn
                          `(lambda (item new old) (close ,browser-item-description))
                          :name ':close
                          :title "Close"
                          :font (make-font :modern nil 10 '(:bold)))))))
       
                

(defun lengthm (a)
      (max (length (first a)) (length (second a))))
        

(defun rule-to-string (assertion)
      (let (assert assert1)
          (dolist (item (contents *result-database*))
                (when (equal (car assertion) (car item))
                       (setq assert1 item)
                       (return)))
          (dolist (item (cdadr assert1)) 
                (when (equal assertion (car item))
                       (setq assert item)
                       (return)))
          (if (equal (cadr assert) t)
             '("PREMISE" "")
             (rule-form2 (caadr assert)))))



(defun assertion-tree (assertion)
      (let ((tree (assertion-to-tree assertion)))
          (when tree
                 (push 
                       (open-dialog () 'rbs-browser *rbs-main-window* :pop-up-p nil
                             :user-scrollable nil :user-closable nil :user-resizable t
                             :title (write-to-string assertion)
                             :starting-tree tree)
                       *description-trees*))))




(defun assertion-to-tree (assertion)
      (let (assert assert1)
          (dolist (item (contents *result-database*))
                (when (equal (car assertion) (car item))
                       (setq assert1 item)
                       (return)))
          (dolist (item (cdadr assert1)) 
                (when (equal assertion (car item))
                       (setq assert item)
                       (return)))
          (if (equal (cadr assert) t)
             (progn
                  (pop-up-message-dialog *rbs-main-window* nil
                        (format nil
                             "~A~%is a premise"
                             assertion)
                        nil "OK")
                  nil)
             (progn
             (make-instance 'rbs-tree
                    :content (write-to-string assertion)
                    :rule (caadr assert)
                    :descendants (rbs-descendants
                                                     (lhs (caadr assert))
                                                     (reverse (cadadr assert))))))))
       
        

(defun rbs-descendants (lhs assertions &optional tail)
      (if (and lhs assertions (not (eq (car assertions) t)))
         (rbs-descendants
          (cdr lhs)
          (cdr assertions)
          (push 
                (if (equal (cadar assertions) t)
                   (make-instance 'rbs-tree
                          :content (caar assertions))
                   (make-instance 'rbs-tree
                          :content (caar assertions)
                          :rule (caadar assertions)
                          :descendants (rbs-descendants
                                                       (lhs (caadar assertions))
                                                       (reverse (cadr (cadar assertions))))))
                tail))
         tail))
                        



(defun dismatch (pattern items &optional tail)
      (if pattern 
         (if (isvar (car pattern))
            (dismatch
                (cdr pattern)
                (cdr items)
                (push (car items) tail))
            (dismatch
                (cdr pattern)
                items
                (push (car pattern) tail)))
         (reverse tail)))

      