
(in-package :rbs)

(defparameter *rbs-main-window* nil)
(defparameter *rbs-output-window* nil)
(defparameter *out-dialog* nil)

(defparameter *last-bw-goal* nil)



(defclass rbs-main-dialog (dialog)
      ())

(defmethod bring-window-to-front :after ((rd rbs-main-dialog))
        (in-package :rbs)
        (set-rbs-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Rule Based Systems module"))

(defmethod window-close ((d rbs-main-dialog))
     (when (yes-or-no-p "Do you really want to
quit the RBS module")
          (remove-from-window-menu (object-name *rbs-main-window*))
          (close d)
          (setf d nil)
          (quit-rbs)))


(defmethod redisplay-window :after ((d rbs-main-dialog) &optional box)
      (in-package :rbs))



(defclass rbs-database-window (sequence-window) 
       ())

(defclass rbs-rulebase-window (sequence-window)
       ())



(defmethod window-close ((clw rbs-database-window))
      (catch 'cancel
            (when (save-p (wsequence clw))
                   (let ((save (ask-save-changes *database-dialog*)))
                       (when (eql save :cancel) (throw 'cancel nil))
                       (when (eql save :yes)
                              (unless (save-database) (throw 'cancel nil)))))
            (close clw)))



(defmethod window-close ((cgw rbs-rulebase-window))
      (catch 'cancel
            (when (save-p (wsequence cgw))
                   (let ((save (ask-save-changes *rulebase-dialog*)))
                       (when (eql save :cancel) (throw 'cancel nil))
                       (when (eql save :yes)
                              (unless (save-rulebase) (throw 'cancel nil)))))
            (close cgw)))



(defparameter *database* nil)
(defparameter *f-rulebase* nil)
(defparameter *b-rulebase* nil)
(defparameter *result-database* nil)
(defparameter *database-dialog* nil)
(defparameter *rulebase-dialog* nil)
(defparameter *result-database-dialog* nil)
(defparameter *current-db-file* nil)
(defparameter *current-rb-file* nil)
