(in-package :rbs)



(defun create-database-window (sequence)
     (let (not-close)
         (when (windowp *database-dialog*)
              (setq not-close (not (window-close *database-dialog*))))
         (unless not-close
              (when (windowp *result-database-dialog*)
                   (close-result-database-window))
              (setq *database-dialog*
                   (open-dialog ()
                        'rbs-database-window *rbs-main-window* :pop-up-p nil
                        :background-color (make-rgb :red 0 :green 128 :blue 128) 
                        :user-closable t :user-scrollable nil :user-resizable t
                        :user-shrinkable t 
                        :sequence sequence
                        :button-menu-bar '(
                                                      ("Save" 'save-database-window)
                                                      ("Close" 'close-database-window)
                                                      ("Add" 'add-assertion)
                                                      ("Delete" 'delete-assertion))
                        :title "Initial Data Base"
                        :visible-box (make-box 0 0 0 0))))))


(defmethod user-close ((rrw rbs-database-window))
      (close-database-window))

(defun create-result-database-window (sequence)
      (when (windowp *result-database-dialog*)
             (close-result-database-window))
      (setq *result-database-dialog*
            (open-dialog ()
                  'rbs-database-window *rbs-main-window* :pop-up-p nil
                  :background-color (make-rgb :red 0 :green 128 :blue 128) 
                  :user-closable nil :user-scrollable nil :user-resizable t
                  :user-shrinkable t 
                  :sequence sequence
                  :button-menu-bar '(
                                                       ("Close" 'close-result-database-window)
                                                       ("View" 'view-data-tree))
                  :title "Final Data Base"
                  :visible-box (make-box 0 0 0 0)))
      (set-menu-item-available-p
       (find-named-object ':view-assertion *rbs-database-menu*) t))


(defun save-database-window (&rest x)
     (catch 'cancel
            (when (save-p (wsequence *database-dialog*))
                   (let ((save (ask-save-changes *database-dialog*)))
                       (when (eql save :cancel) (throw 'cancel nil))
                       (when (eql save :yes)
                              (unless (save-database) (throw 'cancel nil)))))))
     
(defun close-database-window (&rest x)
      (when (window-close *database-dialog*)
             (when (windowp *result-database-dialog*)
                    (close-result-database-window))
             (set-menu-before-load-data-base))
      t)



(defun close-result-database-window (&rest x)
      (window-close *result-database-dialog*)
      (setq *result-database* nil)
      (when *description-trees*
             (dolist (item *description-trees*)
                   (when (windowp item)
                          (close item))))
      (set-menu-item-available-p
           (find-named-object ':view-assertion *rbs-database-menu*) nil)
      t)



(defun add-assertion (&optional item) 
      (multiple-value-bind (assertion other value)
              (ask-user-for-string
                    "Entry new assertion"
                    "" "Add" "Cancel")
             (when (and (string= value "Add") (string/= assertion ""))
                    (format-display *rbs-output-window* "~%")
                    (when (store (make-assertion (read-from-string assertion)) *database*)
                           (add-to-sequence *database-dialog* assertion)))))



(defun delete-assertion (&optional item) 
      (if (dialog-item-value (wsequence *database-dialog*))
         (let ((asserts (delete-from-sequence
                               *database-dialog*
                               (dialog-item-value (wsequence *database-dialog*)))))
             (when asserts
                    (setf *database* (sequence-to-database *database* asserts))))
         (pop-up-message-dialog *rbs-main-window* nil
               "You must select a item first!" nil "OK")))



(defun sequence-to-database (db asserts)
      (make-instance 'assertion-database
             :itemlist t
             :sexp (mapcar #'read-from-string asserts)))


(defun save-dbs-database () 
      (when (save-database) 
             (setf (stream-title *database-dialog*)
                       (concatenate 'string 
                             "Data Base : "  
                             (file-namestring *current-db-file*)))))



(defun save-database ()
      (let ((filename (pop-up-save-file-dialog
                                        *rbs-main-window*
                                        (make-pathname :host nil :name *pail-directory*)
                                        "Save Data Base File"
                                        "Please, type in the new data base file."
                                        (file-namestring *current-db-file*)
                                        (concatenate 'string 
                                            *pail-directory* "rbs\\database\\"))))
          (when filename
                 (savedata filename)
               (setf *current-db-file* filename))))


(defun savedata (filename)
      (when filename
             (progn
                  (with-open-file 
                       (port filename :direction :output :if-exists :supersede)
                       (format-display *rbs-output-window*
                            "~% Saving Data Base to ~A~%" filename)
                       (format port "(~%")
                       (dumpdata (list-of-assertions *database*) port)
                       (format port "~%)"))
                  (setf (save-p (wsequence *database-dialog*)) nil)
                  t)))



(defun dumpdata (database port)
      (mapc #'(lambda (entry)
                           (print (read-from-string entry) port))
             database))



(defun view-data-tree (&optional item) 
      (let ((assertion (dialog-item-value (wsequence *result-database-dialog*))))
          (if assertion
             (assertion-tree (read-from-string assertion))
             (pop-up-message-dialog *rbs-main-window* nil
                   "You must select a item first!" nil "OK"))))
