;;; -*- Mode: LISP; Package: rbs; Syntax: Common-lisp; -*-
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   rbs-init.lisp
;;; Short Desc: general user interface for the  RBS tool
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4. april 1992 - PC
;;; Author(s):  Paolo Cattaneo
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; 
;;; 
;;; --------------------------------------------------------------------------

(in-package :rbs)

(defun rbs ()
     (setq pail-lib::*rbs-module-loaded* t)
     (in-package :rbs)
     (create-rbs-window)
     (set-rbs-menubar)
     ;  (set-help-rbs)
     )



(defun set-help-rbs ()
  (set-help :general "rbs\\help\\rbs-desc.hlp"))
            


(defun create-rbs-window ()
      (let* ((*number-of-buttons* 5)           
              (box (clipping-box *lisp-main-window*))
              (h-indent (round (* 0.2 (box-width box))))
              (v-indent (round (* 0.2 (- (box-height box) 20))))
              (h-size (- (box-width box) (* 2 h-indent)))
              (button-width (round (/ h-size *number-of-buttons*)))
                (button-height 25)
                (out-dialog nil)
              (height (box-height (clipping-box *lisp-main-window*)))
              (width (box-width (clipping-box *lisp-main-window*))))
          (unless *rbs-main-window*
              (setq *rbs-main-window*
                   (open-dialog ()
                       'rbs-main-dialog *lisp-main-window* :pop-up-p nil
                        :title "RBS Main" :name ':rbs-main
                        :background-color (make-rgb :red 0 :green 128 :blue 128) 
                        :window-exterior (clipping-box *lisp-main-window*))))
         (add-to-window-menu
               (stream-title *rbs-main-window*)
               (object-name *rbs-main-window*))
          (setq out-dialog (setq *out-dialog*
                (open-dialog
                      (list
                           (make-dialog-item :widget 'button
                                 :title "Help"
                                  :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (rbs-help))
                                 :box (make-box
                                       0
                                       0
                                       button-width
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Forward"
                                 :available-p nil
                                 :name ':chain
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (forward-chain))
                                 :box (make-box
                                       (round (/ (- (box-width (window-interior *rbs-main-window*)) (* 2 h-indent)) 5))
                                       0
                                       (* 2 (round (/ (- (box-width (window-interior *rbs-main-window*)) (* 2 h-indent)) 5)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Backward"
                                 :available-p nil
                                 :name ':b-chain
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (backward-chain))
                                 :box (make-box
                                       (* 2 (round (/ (- (box-width (window-interior *rbs-main-window*)) (* 2 h-indent)) 5)))
                                       0
                                       (* 3 (round (/ (- (box-width (window-interior *rbs-main-window*)) (* 2 h-indent)) 5)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Load Data"
                                 :name ':load-data-base
                                 :available-p t
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (load-data-base))
                                 :box (make-box
                                       (* 3 (round (/ (- (box-width (window-interior *rbs-main-window*)) (* 2 h-indent)) 5)))
                                       0
                                       (* 4 (round (/ (- (box-width (window-interior *rbs-main-window*)) (* 2 h-indent)) 5)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Load Rules"
                                 :name ':load-rule-base
                                 :available-p t
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (load-rule-base))
                                 :box (make-box
                                       (* 4 (round (/ (- (box-width (window-interior *rbs-main-window*)) (* 2 h-indent)) 5)))
                                       0
                                       (- (box-width (window-interior *rbs-main-window*)) (* 2 h-indent))
                                       button-height)))
                  'dialog *rbs-main-window*
                  :pop-up-p nil
                  :title "RBS: Output"
                  :user-closable nil
                  :user-shrinkable t
                  :user-resizable nil
                  :user-scrollable nil
                  :user-movable t
                  :window-border :dialog-box
                  :window-interior
                  (make-box 
                         h-indent 
                         v-indent
                         (- (box-width (window-interior *rbs-main-window*)) h-indent)
                         (- (box-height (window-interior *rbs-main-window*)) v-indent)))))
          (setq *rbs-output-window*
               (open-stream 'text-edit-window out-dialog :output
                     :title "Rule Based Systems"
                     :user-closable nil :user-resizable nil
                     :user-scrollable t :user-movable nil :user-shrinkable nil 
                     :font (make-font :modern nil 14)
                     :name ':rbs-output
                     :window-exterior
                     (make-box
                             0 25
                             (box-width (visible-box out-dialog))
                             (box-height (visible-box out-dialog)))))))



(defvar *rbs-file-menu* nil)

(defun rbs-new ()
     (:new *rbs-main-window*))

(defun rbs-close ()
     (let ((window (front-window *rbs-main-window*)))
        (if window (window-close window)
           (window-close *rbs-main-window*))))

(defun rbs-print ()
     (:print (front-window *rbs-main-window*)))

(defun rbs-open ()
      (pail-open *rbs-main-window*))                  
             
(defun rbs-save ()
      (pail-save *rbs-main-window*))                  
             
(defun rbs-save-as ()
      (pail-save-as *rbs-main-window*))                


(setq *rbs-file-menu*
     (make-menu-item :title "~File" :value
           (open-menu 
                (list 
                   (make-menu-item :title "~New"
                         :value 'rbs-new :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\N))
                   (make-menu-item :title "~Open"
                         :value 'rbs-open :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\O))
                   (make-menu-item :title "~Close"
                         :value 'rbs-close :available-p t
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "Load Data Base..."
                         :value 'load-data-base :available-p t
                         :selected-p nil :font nil)
                   (make-menu-item :title "Load Rule Base..."
                         :value 'load-rule-base :available-p t
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "~Save"
                         :value 'rbs-save :available-p nil
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\S))
                   (make-menu-item :title "Save ~As"
                         :value 'rbs-save-as :available-p t
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "~Print"
                         :value 'rbs-print :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\S))
                   menu-separator
                   (make-menu-item :name :help :title "~Help"
                         :value 'rbs-file-help :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\H))
                   (make-menu-item :title "E~xit from RBS"
                         :value 'rbs-exit :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\X)))
                'pop-up-menu *lisp-main-window* :name '*rbs-file-menu* :title '"" 
                :selection-function 'funcall-menu-item)))
     
     
(defun rbs-exit ()
     (window-close *rbs-main-window*))

(defun quit-rbs ()
    ; (window-close *rbs-main-window*)
     (setq *database* nil)
     (setq *result-database* nil)
     (setq *f-rulebase* nil)
     (setq *b-rulebase* nil)
     (setq *current-db-file* nil)
     (setq *current-rb-file* nil)
     (setq pail-lib::*rbs-module-loaded* nil)
     (make-available :rbs)
     (select-window pail-lib::*pail-main-window*)
     (in-package :pail-lib))
  



(defvar *rbs-database-menu* nil)

(setq *rbs-database-menu*
     (make-menu-item :title "~Data Base" :value
           (open-menu 
                (list 
                   (make-menu-item :title "New Data Base"
                         :value 'new-data-base
                         :available-p t
                         :selected-p nil
                         :font nil)
                   (make-menu-item :title "Load Data Base..."
                         :value 'load-data-base :available-p t
                         :selected-p nil :font nil)
                   (make-menu-item :title "Save Data Base"
                          :name ':save-data-base
                         :value 'save-database :available-p nil
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "Add Assertion"
                          :name ':add-assertion
                         :value 'add-assertion :available-p nil
                         :selected-p nil :font nil)
                   (make-menu-item :title "Delete Assertion"
                          :name ':del-assertion
                         :value 'delete-assertion :available-p nil
                         :selected-p nil :font nil)
                   (make-menu-item :title "View Assertion Tree"
                          :name ':view-assertion
                         :value 'view-data-tree :available-p nil
                         :selected-p nil :font nil))
                'pop-up-menu *lisp-main-window* :name '*rbs-database-menu* :title '"" 
                :selection-function 'funcall-menu-item)))
                   

(defun new-data-base ()
     (setq *current-db-file* (concatenate 'string *pail-directory* "rbs\\database\\untitled.dbf"))
     (setf *database* (make-instance 'assertion-database :sexp nil))
     (create-database-window (list-of-assertions *database*))
     (setq *result-database* nil)
     (set-menu-after-load-data-base))
         
(defun load-data-base ()
     (let ((file 
                (ask-user-for-existing-pathname
                 "Data Base to Load"
                :stream  *rbs-main-window*
                :allowed-types '(("Data Base Files" . "*.dbf")("All Files"  . "*.*"))
                :host (concatenate 'string *pail-directory* "rbs\\database\\")
                )))
         (when file
                (setq *current-db-file* file)
                (setq *database*
                      (rd-object-file 'assertion-database *current-db-file*))
                (create-database-window (list-of-assertions *database*))
                (setq *result-database* nil)
                (set-menu-after-load-data-base))))



(defun set-menu-after-load-data-base ()
      (when (or *f-rulebase* *b-rulebase*)
             (when *f-rulebase*
                    (set-dialog-item-available-p
                     (find-named-object ':chain *out-dialog*) t)
                    (set-menu-item-available-p
                     (find-named-object ':chain *rbs-forward-menu*) t))
             (set-dialog-item-available-p
              (find-named-object ':b-chain *out-dialog*) t)
             (set-menu-item-available-p
              (find-named-object ':b-chain *rbs-forward-menu*) t))
      (set-menu-item-available-p
       (find-named-object ':save-data-base *rbs-database-menu*) t)
      (set-menu-item-available-p
       (find-named-object ':add-assertion *rbs-database-menu*) t)
      (set-menu-item-available-p
       (find-named-object ':del-assertion *rbs-database-menu*) t)
      (set-menu-item-available-p
       (find-named-object ':view-assertion *rbs-database-menu*) nil))



(defun set-menu-before-load-data-base ()
      (setq *database* nil)
      (setq *last-bw-goal* nil)
      (setq *result-database* nil)
      (set-dialog-item-available-p
       (find-named-object ':chain *out-dialog*) nil)
      (set-dialog-item-available-p
       (find-named-object ':b-chain *out-dialog*) nil)
      (set-menu-item-available-p
       (find-named-object ':chain *rbs-forward-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':b-chain *rbs-forward-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':save-data-base *rbs-database-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':add-assertion *rbs-database-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':del-assertion *rbs-database-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':view-assertion *rbs-database-menu*) nil))
      



(defvar *rbs-rulebase-menu* nil)

(setq *rbs-rulebase-menu*
     (make-menu-item :title "~Rule Base" :value
           (open-menu 
                (list 
                   (make-menu-item :title "New Rule Base"
                         :value 'new-rule-base :available-p t
                         :selected-p nil :font nil)
                   (make-menu-item :title "Load Rule Base..."
                         :value 'load-rule-base :available-p t
                         :selected-p nil :font nil)
                   (make-menu-item :title "Save Rule Base"
                          :name ':save-rule-base
                         :value 'save-rulebase :available-p nil
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "Add Rule"
                          :name ':add-rule
                         :value 'add-rbs-rule :available-p nil
                         :selected-p nil :font nil)
                   (make-menu-item :title "Delete Rule"
                          :name ':del-rule
                         :value 'delete-rbs-rule :available-p nil
                         :selected-p nil :font nil))
                'pop-up-menu *lisp-main-window* :name '*rbs-rulebase-menu* :title '"" 
                :selection-function 'funcall-menu-item)))


(defun new-rule-base ()
     (setf *current-rb-file* (concatenate 'string *pail-directory* "rbs\\rulebase\\untitled.rbf"))
     (setf *f-rulebase* (make-instance 'rule-database :sexp nil))
     (setf *b-rulebase* (make-instance 'horn-rule-database :sexp nil))
     (create-rulebase-window (list-of-rules (or *f-rulebase* *b-rulebase*)))
     (set-menu-after-load-rule-base))

(defun load-rule-base ()
      (let ((file 
                (ask-user-for-existing-pathname
                 "Rule Base to Load"
                :stream  *rbs-main-window*
                :allowed-types '(("Rule Base Files" . "*.rbf")("All Files"  . "*.*"))
                :host (concatenate 'string *pail-directory* "rbs\\rulebase\\")
                )))
          (when file
                 (setq *current-rb-file* file)
                 (setq *f-rulebase*
                       (rd-object-file 'rule-database *current-rb-file*))
                 (setq *b-rulebase*
                       (rd-object-file 'horn-rule-database *current-rb-file*))
                (create-rulebase-window (list-of-rules (or *f-rulebase* *b-rulebase*)))
                (set-menu-after-load-rule-base))))


(defun edit-rule-base ()
      (show-rule-set *f-rulebase*))
                 
      


(defun set-menu-after-load-rule-base ()
      (when *database*
             (when *f-rulebase*
                    (set-dialog-item-available-p
                     (find-named-object ':chain *out-dialog*) t)
                    (set-menu-item-available-p
                     (find-named-object ':chain *rbs-forward-menu*) t))
             (set-dialog-item-available-p
              (find-named-object ':b-chain *out-dialog*) t)
             (set-menu-item-available-p
              (find-named-object ':b-chain *rbs-forward-menu*) t))
      (set-menu-item-available-p
       (find-named-object ':save-rule-base *rbs-rulebase-menu*) t)
      (set-menu-item-available-p
       (find-named-object ':add-rule *rbs-rulebase-menu*) t)
      (set-menu-item-available-p
       (find-named-object ':del-rule *rbs-rulebase-menu*) t))



(defun set-menu-before-load-rule-base ()
      (setq *f-rulebase* nil)
      (setq *b-rulebase* nil)
      (setq *last-bw-goal* nil)
      (set-dialog-item-available-p
       (find-named-object ':chain *out-dialog*) nil)
      (set-dialog-item-available-p
       (find-named-object ':b-chain *out-dialog*) nil)
      (set-menu-item-available-p
       (find-named-object ':chain *rbs-forward-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':b-chain *rbs-forward-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':save-rule-base *rbs-rulebase-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':add-rule *rbs-rulebase-menu*) nil)
      (set-menu-item-available-p
       (find-named-object ':del-rule *rbs-rulebase-menu*) nil))



(defvar *rbs-forward-menu* nil)

(setq *rbs-forward-menu*
      (make-menu-item :title "~Chain" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "Forward"
                             :name ':chain
                             :value 'forward-chain :available-p nil
                             :selected-p nil :font nil)
                      (make-menu-item :title "Backward"
                             :name ':b-chain
                             :value 'backward-chain :available-p nil
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "Help"
                             :available-p nil
                             :value 'parser-help))
                   'pop-up-menu *lisp-main-window* :name '*rbs-forward-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))



(defun forward-chain ()
      (when (windowp *result-database-dialog*)
             (close-result-database-window))
      (setq *result-database*
            (make-instance 'assertion-database
                   :itemlist t
                   :sexp (copy-list (sexp *database*))
                   :contents (copy-list (contents *database*))
                   :content-type (content-type *database*)
                   :itemcount (itemcount *database*)
                   :indices (copy-list (indices *database*))))
      (f-chain *f-rulebase* *result-database*)
      (create-result-database-window (list-of-assertions *result-database*)))
 


(defun backward-chain ()
      (setq *gensym-counter* 0)
      (multiple-value-bind (str other value)
              (ask-user-for-string
                    "Which is the goal?" (write-to-string *last-bw-goal*) "OK" "Cancel")
              (when (and (string/= str "") (string= value "OK"))
                     (if (listp (read-from-string str))
                        (progn 
                             (setq *last-bw-goal* (read-from-string str))
                             (backchain
                                   (list (read-from-string str))
                                   *b-rulebase* *database*))
                        (pop-up-message-dialog *rbs-main-window* nil
                              "Bad sintax !!" nil "OK")))))


                   
(defvar *rbs-demo-menu* nil)

(setq *rbs-demo-menu*
     (make-menu-item :title "~Demos" :value
           (open-menu 
                (list 
                   (make-menu-item :title "Demo 1"
                         :available-p t
                         :value 'demo-1)
                   (make-menu-item :title "Demo 2"
                         :available-p nil
                         :value 'demo-1)
                   (make-menu-item :title "Demo 3"
                         :available-p nil
                         :value 'demo-1))
                'pop-up-menu *lisp-main-window* :name '*rbs-parser-menu* :title '"" 
                :selection-function 'funcall-menu-item)))




(defun demo-1 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-1))


(defun demo-2 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-2))

(defun demo-3 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-3))


                                                  

(defun set-rbs-menubar ()
     (clean-up-menubar)
;;;      (setq *lisp-menu-bar*
;;;           (open-stream 'menu-bar *lisp-main-window* :io))
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Tools
                :value *pail-tool-menu*))
     (add-to-menu *lisp-menu-bar*
          *rbs-file-menu*)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Edit
                :value *pail-edit-menu*))
     (add-to-menu *lisp-menu-bar*
          *rbs-forward-menu*)
     (add-to-menu *lisp-menu-bar*
          *rbs-database-menu*)
     (add-to-menu *lisp-menu-bar*
          *rbs-rulebase-menu*)
     (add-to-menu *lisp-menu-bar*
          *rbs-demo-menu*)
     (add-to-menu *lisp-menu-bar*
          *pail-window-menu*)  
    ; (set-window-menu *rbs-main-window* *lisp-menu-bar*)
     )


