(in-package :rbs)



(defun create-rulebase-window (sequence)
     (let (not-close)
         (when (windowp *rulebase-dialog*)
              (setq not-close (not (window-close *rulebase-dialog*))))
         (unless not-close
              (setq *rulebase-dialog*
                   (open-dialog ()
                        'rbs-rulebase-window *rbs-main-window* :pop-up-p nil
                        :background-color (make-rgb :red 0 :green 128 :blue 128) 
                        :user-closable t :user-scrollable nil :user-resizable t
                        :user-shrinkable t 
                        :sequence sequence
                        :button-menu-bar '(
                                                      ("Save" 'save-rulebase-window)
                                                      ("Close" 'close-rulebase-window)
                                                      ("Add" 'add-rbs-rule)
                                                      ("Delete" 'delete-rbs-rule))
                        :title (if *f-rulebase* "Rule Base" "Backward Rule Base")
                        :visible-box (make-box 0 0 0 0))))))


(defmethod user-close ((rrw rbs-rulebase-window))
      (close-rulebase-window))

(defun close-rulebase-window (&rest x)
      (when (window-close *rulebase-dialog*)
             (when *result-database* (close-result-database-window))
             (set-menu-before-load-rule-base))
      t)


(defun save-rulebase-window (&rest x)
      (catch 'cancel
            (when (save-p (wsequence *rulebase-dialog*))
                   (let ((save (ask-save-changes *rulebase-dialog*)))
                       (when (eql save :cancel) (throw 'cancel nil))
                       (when (eql save :yes)
                              (unless (save-rulebase) (throw 'cancel nil)))))))
           



(defun add-rbs-rule (&optional item) 
     (let (rule)
         (multiple-value-bind (lhs other value)
                (ask-user-for-string
                     "Enter LHS in the form: 
<pattern1> AND <pattern2> ... AND <pattern>"
                     "" "OK" "Cancel")
               (when (and (string= value "OK") (string/= lhs ""))
                    (multiple-value-bind (rhs other value)
                           (ask-user-for-string
                                "Enter RHS of rule in the form: 
<assert1> AND <assert2> AND <assertn>"
                                "" "Add" "Cancel")
                          (when (and (string= value "Add") (string/= rhs ""))
                               (setq rule (list (hide-clauses lhs) (hide-clauses rhs)))
                               (format-display *rbs-output-window* "~%")
                               (when (store (make-instance 'horn-rule :sexp rule) *b-rulebase*)
                                    (when *f-rulebase* (store (make-instance 'rule :sexp rule) *f-rulebase*))
                                    (add-to-sequence
                                         *rulebase-dialog*
                                         (rule-form (car (last (itemlist (or *f-rulebase* *b-rulebase*)))))))))))))



(defun delete-rbs-rule (&optional item) 
      (let ((rule (dialog-item-value (wsequence *rulebase-dialog*))))
          (if rule
             (let ((rules (delete-from-sequence
                                        *rulebase-dialog*
                                        rule)))
                 (when rules
                        (setf (itemlist *b-rulebase*) (pop-rule rule (itemlist *b-rulebase*)))
                        (when *f-rulebase* (setf (itemlist *f-rulebase*) (pop-rule rule (itemlist *f-rulebase*))))
                        (setf (itemcount *b-rulebase*) (1- (itemcount *b-rulebase*)))
                        (when *f-rulebase* (setf (itemcount *f-rulebase*) (1- (itemcount *f-rulebase*))))))
             (pop-up-message-dialog *rbs-main-window* nil
                   "You must select a rule first!" nil "OK"))))


      
(defun pop-rule (rule rules &optional tail)
      (if rules
         (if (string= rule (rule-form (car rules)))
            (pop-rule rule (cdr rules) tail)
            (pop-rule rule (cdr rules) (append tail (list (car rules)))))
         tail))




(defun save-rbs-rulebase () 
      (when (save-rulebase) 
             (setf (stream-title *rulebase-dialog*)
                       (concatenate 'string 
                             "Rule Base : "  
                             (file-namestring *current-db-file*)))))



(defun save-rulebase ()
     (let ((filename (pop-up-save-file-dialog
                                 *rbs-main-window*
                                 (make-pathname :host nil :name *pail-directory*)
                                 "Save Rule Base File"
                                 "Please, type in the new rule base file."
                                 (file-namestring *current-rb-file*)
                                 (concatenate 'string *pail-directory*
                                     "rbs\\rulebase\\"))))
         (when filename
              (saverule filename)
              (setq *current-rb-file* filename))))



(defun saverule (filename)
      (when filename
             (progn
                  (with-open-file 
                       (port filename :direction :output :if-exists :supersede)  
                       (format-display *rbs-output-window*
                            "~% Saving rule Base to ~A~%" filename)
                       (format port "(~A-database~%~%" (content-type (or *f-rulebase* *b-rulebase*)))
                       (dumprule (itemlist (or *f-rulebase* *b-rulebase*)) port)
                       (format port ")"))
                  (setf (save-p (wsequence *rulebase-dialog*)) nil)
                  t)))



(defun dumprule (rulebase port)
      (mapc #'(lambda (entry)
                           (format port
                                "(~A~% ~A)~%~%" (lhs entry) (rhs entry)))
             rulebase))

(defun hide-clauses (string)
     (multiple-value-bind (form index)
            (read-from-string string nil :eof)
           (unless (eq form :eof)
                (when (listp form)
                     (cons form
                         (when (eq 0 (search "AND"
                                                 (setf string (string-trim '(#\Space #\Tab)
                                                                       (subseq string index)))
                                                 :test #'char-equal))
                              (hide-clauses (subseq string 3))))))))