;;; -*- Mode: LISP; Package: RBS; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA
;;;
;;; ************************************************************************
;;;
;;; Filename:   util.cl
;;; Short Desc: general utility algorithms
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   2.94
;;; Author:     Rosner
;;;
;;; Copyright (c) 1994 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


(in-package :rbs)



(defmacro lamda  (&rest x)
      (list 'function (cons 'lambda x)))



;;;rd-collection <class>
;; class must be a "collection" type - ie a class containing several
;; objects of the same type (eg a set of rules; a set of assertions etc)
;; n.b. error checking is not properly done

;;;rd-collection-file <class> <filename> => result of rd-collection-stream
;;                                          nil if filename does not exist

(defun rd-collection-file (class fn)
      (with-open-file
           (s fn
               :direction :input
               :if-does-not-exist nil)
           (rd-collection-stream class s)))
   


;;; rd-collection-stream <class><stream>

(defun rd-collection-stream (class s)
      (let ((new (make-instance class))
              (item nil))
          (format-display *rbs-output-window*
               "~%~% Loading ~A...~%~%" (string-upcase (file-namestring s)))
          (loop
              (cond ((eq (setq item (read s nil '*eof*)) '*eof*)
                           (close s)
                           (return new))
                          (t (add-to-collection item new))))
          (case class
                ('database
                 (format-display *rbs-output-window*
                      "~% ~A loaded.~%" (string-upcase (file-namestring s))))
                ('ruleset 
                 (format-display *rbs-output-window*
                      "~% ~A rules loaded.~%" (length (rules new)))))
          new))
          



;;; rd-object-file <classname> <filename>

(defun rd-object-file (class fn)
      (with-open-file
           (s fn
               :direction :input
               :if-does-not-exist nil)
           (rd-object-stream class s)))


   
;;; rd-object-stream <classname> <stream>

(defun rd-object-stream (class s)
      (let ((sexp (read s nil '*eof*))
              new new-class)
          (unless (eq sexp '*eof*)
                (unless (listp (car sexp))
                      (setq new-class (car sexp))
                      (setq sexp (cdr sexp)))
                (case class
                      ('assertion-database
                       (format-display *rbs-output-window*
                            "~%~% Loading Data Base ~A...~%~%" (string-upcase (file-namestring s)))
                       (setq new (make-instance class :sexp sexp))
                       (format-display *rbs-output-window*
                            "~% ~A loaded.~%" (string-upcase (file-namestring s)))
                       new)
                      ('rule-database
                       (unless (equal new-class 'horn-rule-database)
                             (format-display *rbs-output-window*
                                  "~%~% Loading Forward Rule Base ~A...~%~%" (string-upcase (file-namestring s)))
                             (setq new (make-instance class :sexp sexp))
                             (format-display *rbs-output-window*
                                  "~% ~A forward rules loaded from ~A.~%"
                                  (length (itemlist new)) (string-upcase (file-namestring s)))
                             new))
                      ('horn-rule-database
                       (format-display *rbs-output-window*
                            "~%~% Loading Backward Rule Base ~A...~%~%" (string-upcase (file-namestring s)))
                       (setq new (make-instance class :sexp sexp))
                       (format-display *rbs-output-window*
                            "~% ~A backward rules loaded from ~A.~%"
                            (length (itemlist new)) (string-upcase (file-namestring s)))
                       new)))))
                 
                 
          



(defun longest (slist)
      (let ((l 0)
              (lmax 0)
              (longest nil))
          (mapc
                 (function
                      (lambda (s)
                          (cond ((> (setq l (length s)) lmax)
                                       (setq lmax l)
                                       (setq longest s)))))
                 slist)
          longest))





