;;; -*- Mode: LISP; Package: pail-lib; Syntax: Common-lisp; -*-




(defun welcome-window (string package)
      (setq *welcome-tool-window* 
            (open-dialog ()
                  'dialog *pail-main-window* :name :tool-welcome
                  :title "Tool Loading" :font (make-font :swiss :system 16 '(:bold)) 
                  :window-state nil :user-movable nil :user-resizable nil 
                  :user-closable nil :user-shrinkable nil :user-scrollable nil 
                  :background-color (make-rgb :red 0 :green 128 :blue 128) 
                  :pop-up-p nil :window-interior 
                  (make-box 0 0
                         (box-width (window-exterior *pail-main-window*))
                         (- (box-height (window-exterior *pail-main-window*)) 20))))
      (update-dialog *welcome-tool-window*
            (list 
               (make-dialog-item :widget 'static-text :groupstart t 
                      :tabstop nil :background-color t :box 
                      #.(make-box 12 16 265 36) :value 
                      "Portable AI Laboratory" :font 
                      (make-font nil :arial 20 '(:bold)) :name 
                      :static-text1)
               (make-dialog-item :widget 'static-text :groupstart t 
                      :tabstop nil :background-color t :box 
                      #.(make-box 12 50 189 70) :value 
                      " Welcome to ..." :font 
                      (make-font nil :arial 14 '(:bold)) :name 
                      :static-text2)
               (make-dialog-item :widget 'static-text :groupstart t 
                      :tabstop nil :background-color t :box 
                      #.(make-box 12 75 280 125) :value string 
                      :font (make-font nil :arial 24 '(:bold)) :name 
                      :static-text3)
               (make-dialog-item :widget 'cancel-button :groupstart t 
                      :tabstop nil :background-color nil :box 
                      (make-box
                             160 (- (box-height (window-interior *pail-main-window*)) 25)
                             220 (- (box-height (window-interior *pail-main-window*)) 0))
                      :title "Cancel" 
                      :font (make-font nil :arial 16 '(:bold))
                      :set-value-fn
                      `(lambda (dialog-item new-value old-value)
                            (not-load-tool ,package))
                      :name :cancel-button)
               (make-dialog-item :widget 'default-button :groupstart t 
                      :tabstop nil :background-color nil :box 
                      (make-box
                             230 (- (box-height (window-interior *pail-main-window*)) 25)
                             290 (- (box-height (window-interior *pail-main-window*)) 0))
                      :title "Load" 
                      :font (make-font nil :arial 16 '(:bold))
                      :set-value-fn
                      `(lambda (dialog-item new-value old-value)
                            (load-dispatcher ,package))
                      :name :default-button))))
            

(defun close-welcome-dialog ()
      (close *welcome-tool-window*)
      (setq *welcome-tool-window* nil) t)


(defun not-load-tool (pack)
      (close-welcome-dialog)
      (set-dialog-item-available-p
       (find-named-object
          (read-from-string (concatenate 'string ":" pack))
          *pail-main-window*) t)
      (set-menu-item-available-p
       (find-named-object
          (read-from-string (concatenate 'string ":" pack))
          *lisp-menu-bar*) t))

(defun load-dispatcher (pack)
      (let (loading load-file)
          (when (windowp *pail-welcome-message*)
                 (close *pail-welcome-message*))
          (setq load-file
                (make-dialog-item :widget 'editable-text :groupstart t
                       :tabstop t :box
                       (make-box
                              12 (- (box-height (window-interior *pail-main-window*)) 23)
                              280 (- (box-height (window-interior *pail-main-window*)) 0))
                       :value "" :font (make-font nil :courier\ new 16 nil)
                       :name :load-text))
          (setq loading
                (make-dialog-item :widget 'static-text :groupstart t 
                       :tabstop nil :background-color t 
                       :box 
                       (make-box
                              220 (- (box-height (window-interior *pail-main-window*)) 50)
                              280 (- (box-height (window-interior *pail-main-window*)) 34))
                       :value " Loading..."
                       :font (make-font nil :arial 14 '(:bold))
                       :name :static-text3))
          (update-dialog *welcome-tool-window*
                (list
                   (find-named-object :static-text1 *welcome-tool-window*)
                   (find-named-object :static-text2 *welcome-tool-window*)
                   (find-named-object :static-text3 *welcome-tool-window*)
                   load-file
                   loading))
          (process-pending-events)
;OKKIO  (with-cursor waiting-cursor
;OKKIO  `
         (load (concatenate 'string *pail-directory* pack "\\" pack "-load.lsp"))
          (apply (read-from-string (concatenate 'string pack  "::"  pack)) nil)
          (close-welcome-dialog)))

;; (defun with-cursor (new-cursor s-sexp)
;;      (let ((old-cursor (cursor *welcome-tool-window*)))
;;          (set-cursor *welcome-tool-window* new-cursor)
;;          (eval s-sexp)
;;          (set-cursor *welcome-tool-window* old-cursor)))




(defun  init-id3 ()
  (welcome-window "Inductive Learning with ID3" "ID3"))

(defun  init-ebg ()
  (welcome-window "Explanation Based Generalization" "ebg"))

(defun  init-rbs ()
  (welcome-window "Rule Based Systems" "rbs"))

(defun  init-ka ()
  (welcome-window "Knowledge Aquisition Based on Repertory Grid" "ka"))

(defun  init-ga ()
  (welcome-window "Genetic Algorithms" "ga"))

(defun  init-atp ()
  (welcome-window "Automated Theorem Proving" "atp"))

(defun  init-atn ()
  (welcome-window "Augmented Transition Networks" "atn"))

(defun  init-cky ()
  (welcome-window "Chart Parsing" "cky"))

(defun  init-lcs ()
  (welcome-window "Learning Classifier Systems" "lcs"))

(defun  init-bp ()
  (welcome-window "Neural Networks: Back Propagation" "bp"))

(defun  init-tms ()
  (welcome-window "Truth Maintenance Systems" "tms"))

(defun  init-plans ()
  (welcome-window " STRIPS-like Planning" "plans"))


(defun  init-csp ()
  (welcome-window "Constraint Propagation" "csp"))

(defvar *id3-module-loaded* nil)
(defvar *ebg-module-loaded* nil)
(defvar *rbs-module-loaded* nil)
(defvar *ka-module-loaded* nil)
(defvar *ga-module-loaded* nil)
(defvar *atp-module-loaded* nil)
(defvar *atn-module-loaded* nil)
(defvar *cky-module-loaded* nil)
(defvar *lcs-module-loaded* nil)
(defvar *bp-module-loaded* nil)
(defvar *tms-module-loaded* nil)
(defvar *plans-module-loaded* nil)
(defvar *csp-module-loaded* nil)

