;;; -*- Mode: LISP; Package: pail-lib; Syntax: Common-lisp; -*-

(in-package :pail-lib)



(export '(pail
              about-pail
              *pail-tool-menu*
              *pail-edit-menu*
              *pail-window-menu*
              *pail-file-menu*
              add-to-window-menu
              remove-from-window-menu
                  clean-up-menubar
              make-available
              set-default-menubar
              return-to-pail
              set-pail-menubar
               window-close))

(defun find-menu-item (text)
     (dolist (item (menu-items *lisp-menu-bar*))
          (when (string= (menu-item-title item) text)
               (return item))))

(defvar *default-lisp-menu*
     (copy-list (menu-items *lisp-menu-bar*)))

(defvar *lisp-file-menu*
     (find-menu-item "~File"))

(defvar *lisp-edit-menu*
     (find-menu-item "~Edit"))


(defun set-default-menubar ()
     (clean-up-menubar)
     (dolist (item *default-lisp-menu*)
          (add-to-menu *lisp-menu-bar* item)))
     

(defun clean-up-menubar ()
     (dolist (item (menu-items *lisp-menu-bar*))
          (remove-from-menu *lisp-menu-bar* item)))
   


(defun pail ()
      (in-package :pail-lib)
      (set-pail-menubar)
     (make-pail-main-window)
      (if (not (windowp *pail-welcome-message*))
         (about-pail)
         (window-show *pail-welcome-message*)))
;  (gen-help-key-handler)
;  (tec-help-key-handler)
;  (set-help :general "help\\main-help.gen"
;            :technical "help\\main-help.tec")



(defvar *pail-file-menu* nil)
(defvar *pail-edit-menu* nil)
(defvar *pail-window-menu* nil)
(defvar *pail-tool-menu* nil)
(defvar *lisp-menu-bar* nil)
(defvar *pail-help-menu*)



(setq *pail-file-menu* 
     (open-menu
          (list
             (make-menu-item :name :exit :title '"~Exit Pail"
                   :value 'exit-pail :available-p t 
                   :selected-p nil :font nil :event-synonym 
                   '(control-key #\X)))
          'pop-up-menu *lisp-main-window* :name '*pail-window-menu* :title '"" 
          :selection-function 'funcall-menu-item))



(defun exit-pail ()
      (when *id3-module-loaded*
            (id3::quit-id3))
      (when *ebg-module-loaded*
            (ebg::quit-ebg))
      (when *rbs-module-loaded*
            (rbs::quit-rbs))
      (when *ga-module-loaded*
            (ga::quit-ga))
      (when *ka-module-loaded*
            (ka::quit-ka))
      (when *atp-module-loaded*
            (atp::quit-atp))
      (when *atn-module-loaded*
            (atn::quit-atn))
      (when *cky-module-loaded*
            (cky::quit-cky))
      (when *bp-module-loaded*
            (bp::quit-bp))
      (when *lcs-module-loaded*
            (lcs::exit-system))
      (when *tms-module-loaded*
            (tms::quit-tms))
      (when *plans-module-loaded*
            (plans::quit-plans))
      (when *csp-module-loaded*
            (csp::quit-csp))
      (close *pail-main-window*)
      (setq *pail-main-window* nil)
      (bwtf-unbound)
      (allegro::quit)
      )



;;; (dolist (item (menu-items *lisp-menu-bar*))
;;;       (when (string= "~Edit" (menu-item-title item))
;;;             (setf *pail-edit-menu* item)))


(setf *pail-edit-menu*
         (find-named-object :edit *lisp-menu-bar*))

(setq *pail-window-menu* 
      (make-menu-item
             :name 'windows
             :title '"~Active Tools"
             :value (open-menu (list)
                                'pop-up-menu *lisp-main-window* :name '*pail-window-menu* :title '"" 
                                :selection-function 'pail-lib::pshow-window)))



(setq *pail-tool-menu*
      (open-menu 
            (list 
               (make-menu-item :name :id3 :title 
                      '"Inductive Learning with ID3" :value 'init-id3 :available-p t
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f1))
               (make-menu-item :name :ebg :title 
                      '"Explanation Based Generalization" :value 'init-ebg :available-p nil 
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f2))
               (make-menu-item :name :rbs :title 
                      '"Rules Based Systems" :value 'init-rbs :available-p t
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f3))  
               (make-menu-item :name :ga :title 
                      '"Genetic Algorithms" :value 'init-ga :available-p t
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f4))       
               (make-menu-item :name :atp :title 
                      '"Automatic Theorem Proving" :value 'init-atp :available-p t 
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f5))
               (make-menu-item :name :atn :title 
                      '"Augmented Transition Networks" :value 'init-atn :available-p t 
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f6))
               (make-menu-item :name :cky :title 
                      '"Chart Parsing" :value 'init-cky :available-p t
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f7))
               (make-menu-item :name :lcs :title 
                      '"Learning Classifier Systems" :value 'init-lcs :available-p t 
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f8))
               (make-menu-item :name :bp :title 
                      '"Neural Networks: Back Propagation" :value 'init-bp :available-p t 
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f9))     
               (make-menu-item :name :tms :title 
                      '"Truth Maintenance Systems" :value 'init-tms :available-p nil 
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f10))
               (make-menu-item :name :plans :title 
                      '"Strips Planning" :value 'init-plans :available-p nil 
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f11))
               (make-menu-item :name :csp :title 
                      '"Constraint Propagation" :value 'init-csp :available-p t
                      :selected-p nil :font nil :event-synonym 
                      '(control-key pc:vk-f12)))
            'pop-up-menu *lisp-main-window* :name '*pail-tool-menu* :title '"" 
            :selection-function 'pail-lib::call-tool))



(setq *pail-help-menu* 
     (open-menu
          (list
             (make-menu-item :name :exit :title '"~Help"
                   :value 'pail-help :available-p nil
                   :selected-p nil :font nil :event-synonym 
                   'pc:vk-f1)
             menu-separator
             (make-menu-item :name :exit :title '"About ~Pail"
                   :value 'about-pail-option :available-p t 
                   :selected-p nil :font nil))
          'pop-up-menu *lisp-main-window* :name '*pail-help-menu* :title '"" 
          :selection-function 'funcall-menu-item))



(defun about-pail-option ()
  (if (not (windowp *pail-welcome-message*))
     (about-pail)
     (window-show *pail-welcome-message*)))


(defclass pail-main-dialog (dialog)
      ())

(defun bwtf-unbound ()
(eval '(defmethod bring-window-to-front :after ((pd pail-main-dialog))
          ()))
(eval '(defmethod bring-window-to-front :after ((tl top::toploop-window))
          ())))

(defmethod bring-window-to-front :after ((tl top::toploop-window))
   (set-default-menubar)
   (setf (stream-title *lisp-main-window*)
         "Allegro CL for Windows"))

(defmethod bring-window-to-front :after ((pd pail-main-dialog))
   (in-package :pail-lib)
   (set-pail-menubar)
   (setf (stream-title *lisp-main-window*)
         "Portable AI Laboratory"))

(defmethod bring-window-to-front :after ((tl top::toploop-window))
   (set-default-menubar)
   (setf (stream-title *lisp-main-window*)
         "Allegro CL for Windows"))

     


(defun make-pail-main-window ()
   (setq *pail-main-window* 
      (open-dialog ()
         'pail-main-dialog *lisp-main-window* :name ':pail :title "PAIL" 
         :font (make-font nil :times\ new\ roman 16 '(:bold))
         :window-state :normal :user-movable t :user-resizable 
         nil :user-closable nil :user-shrinkable t :user-scrollable nil
         :background-color (make-rgb :red 0 :green 0 :blue 0) 
         :pop-up-p nil :window-exterior
         (make-box
            (round (- (/ (box-width (clipping-box *lisp-main-window*)) 2) 150)) 100
            (round (+ (/ (box-width (clipping-box *lisp-main-window*)) 2) 150)) 300)))
   (set-window-menu *pail-main-window* *lisp-menu-bar*)
   (let* ((width (box-width (window-exterior *pail-main-window*)))
          (height (- (box-height (window-exterior *pail-main-window*)) 20))
          (x (round (/ width 5)))
          (y (round (/ height 3))))
      (update-dialog *pail-main-window*
         (list
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-id3)))
               :box (make-box 0 0 x y) :value t :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :id3 :title "ID3" :available-p t)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-ebg)))
               :box (make-box x 0 (* 2 x) y) :value t :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :ebg :title "EBG" :available-p nil)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-rbs)))
               :box (make-box (* 2 x) 0 (* 3 x) y) :value t :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :rbs :title "RBS" :available-p t)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-ga)))
               :box (make-box (* 3 x) 0 (* 4 x) y) :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :ga :title "GA" :available-p t)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-atp)))
               :box (make-box (* 4 x) 0 width y) :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :atp :title "ATP")
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-atn)))
               :box (make-box (* 4 x) y width (* 2 y)) :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :atn :title "ATN")
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-cky)))
               :box (make-box (* 4 x) (* 2 y) width height) :font 
               (make-font nil :arial 21 '(:bold))
               :name :cky :title "CKY" :available-p t)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-lcs)))
               :box (make-box (* 3 x) (* 2 y) (* 4 x) height) :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :lcs :title "LCS" :available-p t)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-bp)))
               :box (make-box (* 2 x) (* 2 y) (* 3 x) height) :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :bp :title "BP" :available-p t)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-tms)))
               :box (make-box x (* 2 y) (* 2 x) height) :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :tms :title "TMS" :available-p nil)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-plans)))
               :box (make-box 0 (* 2 y) x height) :value t :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :plans :title "Plans" :available-p nil)
            (make-dialog-item :widget 'button :groupstart nil 
               :tabstop nil :set-value-fn 
               '(lambda (dialog-item new-value old-value)
                   (progn
                      (set-dialog-item-available-p dialog-item nil)
                      (set-menu-item-available-p
                       (find-named-object (object-name dialog-item)
                          *lisp-menu-bar*) nil)
                      (init-csp)))
               :box (make-box 0 y x (* 2 y)) :value t :font 
               (make-font nil :arial 21 '(:bold)) 
               :name :csp :title "CSP" :available-p t)
            ;;;                    (make-dialog-item :widget 'picture-button
            ;;;                           :groupstart t
            ;;;                           :tabstop nil
            ;;;                          :background-color t
            ;;;                           :box (make-box x y (round (/ width 2)) (* 2 y))
            ;;;                          :name :button-help 
            ;;;                          :title "help.bmp"
            ;;;                           :available-p t)
            ;;;                    (make-dialog-item :widget 'picture-button 
            ;;;                          :groupstart t 
            ;;;                           :tabstop nil 
            ;;;                          :box (make-box (round (/ width 2)) y (* 4 x) (* 2 y))
            ;;;                        ;  :font (make-font nil :times\ new\ roman 32 '(:bold)) 
            ;;;                           :set-value-fn
            ;;;                           '(lambda (dialog-item new-value old-value)
            ;;;                                (exit-pail))
            ;;;                           :name :button-exit :title "exit.bmp")
            ))
      (add-to-window-menu
         (stream-title *pail-main-window*)
         (object-name *pail-main-window*))))



(defclass message (dialog) nil)      


(defmacro window-hide (w)
     (list 'shrink-window w t))

(defmacro window-show (w)
     (list 'select-window w))


(defmethod event :after
     ((pane message)
      (event (eql mouse-down))
      (shift t) (data t) (time t))
     (view-click-event-handler pane data))



(defmethod view-click-event-handler ((w message) where)   ;  new go-away-by-clicking
  (declare (ignore where))
  (window-hide w))                      ; hide instead of close



(defun about-pail ()
   (setq *pail-welcome-message*
      (open-dialog 
         (list 
            (make-dialog-item :widget 'static-text :groupstart t 
               :tabstop nil :background-color (make-rgb :red 0 :green 128 :blue 128)
               :box #.(make-box 23 113 283 144) :value 
               "Developed at IDSIA, 6900 Lugano, Switzerland.  1996 IDSIA, e-mail: pail@idsia.ch" 
               :font (make-font nil :arial 14 '(:bold)) :name 
               :static-text8)
            (make-dialog-item :widget 'static-text :groupstart t 
               :tabstop nil :background-color (make-rgb :red 0 :green 128 :blue 128)
               :box #.(make-box 23 68 261 102) :value "Laboratory" 
               :font (make-font nil :arial 36 '(:bold)) :name 
               :static-text67)
            (make-dialog-item :widget 'static-text :groupstart t 
               :tabstop nil :background-color (make-rgb :red 0 :green 128 :blue 128)
               :box #.(make-box 23 35 261 69) :value "Portable AI" 
               :font (make-font nil :arial 36 '(:bold)) :name 
               :static-text6)
            (make-dialog-item :widget 'static-text :groupstart t 
               :tabstop nil :background-color (make-rgb :red 0 :green 128 :blue 128)
               :box #.(make-box 23 17 126 32) :value 
               " Welcome to the..." :font 
               (make-font nil :arial 14 '(:bold)) :name 
               :static-text4))
         'message *pail-main-window* :name :dialog2 :title 
         "About PAIL" :font 
         (make-font :swiss :system 16 '(:bold)) :window-state nil 
         :user-movable nil :user-resizable nil :user-closable nil 
         :user-shrinkable nil :user-scrollable nil 
         :background-color (make-rgb :red 0 :green 128 :blue 128) 
         :pop-up-p nil :window-interior 
         (make-box 0 0
            (box-width (window-interior *pail-main-window*))
            (box-width (window-interior *pail-main-window*))))))


(defun set-pail-menubar ()
;;;       (setq *lisp-menu-bar*
;;;             (open-stream 'menu-bar *lisp-main-window* :io
;;;                   :font (make-font nil :times\ new\ roman 16 '(:bold))))
     (clean-up-menubar)
      (add-to-menu *lisp-menu-bar*
            (make-menu-item
                   :title '~Tools
                   :value *pail-tool-menu*))
      (add-to-menu *lisp-menu-bar*
            (make-menu-item
                   :title '~File
                   :value *pail-file-menu*))
      (add-to-menu *lisp-menu-bar*
            (make-menu-item
                   :name 'help
                   :title '~Help
                   :value *pail-help-menu*))
      (add-to-menu *lisp-menu-bar*
            *pail-window-menu*)
      ;(make-pail-main-window)
      )



(defun pshow-window (menu menu-item window &optional (stream *lisp-main-window*))
     (let ((win (find-named-object (menu-item-value menu-item) stream)))
         (select-window win)
         (unless (eql (object-name win) (menu-item-value menu-item))
            (pshow-window menu menu-item window win))))



(defun add-to-window-menu (title name)
     (add-to-menu (menu-item-value *pail-window-menu*)
          (make-menu-item
                :name (read-from-string
                               (concatenate 'string (write-to-string name) "-menu" ))
                :title title
                :value name
                :available-p t
                :selected-p nil 
                :font nil)))        



(defun remove-from-window-menu (name)
     (remove-from-menu (menu-item-value *pail-window-menu*)
         (find-named-object
            (read-from-string
                (concatenate 'string (write-to-string name) "-menu"))
            *pail-window-menu*)))


                
(defun call-tool (menu menu-item window)
     (set-menu-item-available-p menu-item nil)
     (set-dialog-item-available-p
         (find-named-object (object-name menu-item)
                                        *pail-main-window*)
         nil)
     (funcall (menu-item-value menu-item)))


(defmethod window-close ((w dialog))
     (close w))

(defmethod window-close ((w text-edit-window))
     (close w))


(defun make-available (name)
     (set-dialog-item-available-p
         (find-named-object name *pail-main-window*) t)
     (set-menu-item-available-p
       (find-named-object name *pail-tool-menu*) t))
     