;;; -*- Mode: LISP; Package: pail-lib; Syntax: Common-lisp; -*-
;;; **************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; **************************************************************************
;;;
;;; Filename:   pail-lib
;;; Short Desc: General library stuff
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   22.4.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;;
;;; Modification history
;;; 10.11.91   intern-all added to this file  -dta
;;;

(unless (find-package :pail-lib) (defpackage :pail-lib))

(in-package :pail-lib)

(export '(add-path
          add-subdir
          clear-loaded
          ensure-loaded 
          *readable*
          save-obj
          load-obj
          log2
          remove-nth
          format-display
          select-item-from-list
          ))

(defparameter *sourcefile-type* "lsp")
  

(defparameter *faslfile-type* "fsl")

(defparameter *welcome-tool-window* nil)


(defun load-file-verbose (file)
     (when *welcome-tool-window*
          (set-dialog-item-value
               (find-named-object :load-text *welcome-tool-window*)
               file)))

(defun compile-file-verbose (file)
         (when *welcome-tool-window*
          (set-dialog-item-value
               (find-named-object :load-text *welcome-tool-window*)
               file)))

(defun intern-all (list package)
  (cond ((null list) nil)
	((numberp list) list)
	((stringp list) list)
	((atom list) (intern (symbol-name list) package))
	(t (cons (intern-all (car list) package) (intern-all (cdr list) package)))))


(defun all-symbol-names (list) (string-right-trim '(#\Space) (Rall-symbol-names list)))


(defun Rall-symbol-names (list)
  (concatenate 'string
    (cond ((null list) nil)
	((numberp list) (write-to-string list))
	((stringp list) list)
	((atom list) (symbol-name list))
	(t (let ((result nil))
	     (eval `(concatenate 'string
		     "("
		     ,@ (dolist (c list
				  (reverse (cons
					    (string-right-trim '(#\Space) (car result))
					    (cdr result))))
		       (push (Rall-symbol-names c) result))
		     ")"))
	     )))
    " "))


(defvar *loaded* (make-hash-table))


(defun add-path (file-name path)
  (merge-pathnames file-name path))


(defun add-subdir (path &rest subdir)
  "Adds one ore several subdirectories to path"
  (make-pathname 
   :name (file-namestring path)
   :directory (append (pathname-directory path) subdir)))


(defun ensure-fasl (string &optional (force-compile nil))
     (declare (ignore force-compile))
     (let ((source (merge-pathnames
                               (make-pathname :type *sourcefile-type*)
                               string))
            (fasl (merge-pathnames
                          (make-pathname :type *faslfile-type*)
                          (concatenate
                              'string
                              (directory-namestring string)
                              "fasl\\"
                              (file-namestring string)))))
         (when (or (not (probe-file fasl))
                        (< (file-write-date fasl) (file-write-date source)))
              (compile-file-verbose 
               (format nil  "Compiling file: ~a" (file-namestring source)))
              (compile-file source :output-file fasl
                  :verbose (unless *welcome-tool-window* t)))
         t))


(defun ensure-loaded (string &key (source nil) (force nil) (force-compile nil))
     (let* ((not-found (gensym))
             (name-sym (pathname-name string))
             (loaded-p (gethash name-sym *loaded* not-found)))
         (if (or source *no-compiler*)
            (if force
               (progn
                   (load-file-verbose (format nil "Loading file: ~a " string))
                   (load (merge-pathnames 
                                  (make-pathname :type *sourcefile-type*) 
                                  string))
                   (setf (gethash name-sym *loaded*) t))
               (if (member loaded-p (list nil not-found))
                  (progn
                      (load-file-verbose (format nil "Loading file: ~a " string))
                      (load (merge-pathnames 
                                     (make-pathname :type *sourcefile-type*) 
                                     string) :verbose nil)                                     
                      (setf (gethash name-sym *loaded*) t))))
            (let ((new-fasl (ensure-fasl string force-compile)))
                (if force
                   (progn
                       (load-file-verbose (format nil "Loading file: ~a "
                                                        (file-namestring string)))
                       (load (merge-pathnames
                                      (make-pathname :type *faslfile-type*)
                                      (concatenate
                                          'string
                                          (directory-namestring string)
                                          "fasl\\"
                                          (file-namestring string))))
                       (setf (gethash name-sym *loaded*) t))
                   (if (or (member loaded-p (list nil not-found))
                            new-fasl)
                      (progn
                         (load-file-verbose (format nil "Loading file: ~a " 
                                                           (file-namestring string)))
                          (load (merge-pathnames
                                         (make-pathname :type *faslfile-type*)
                                         (concatenate
                                             'string
                                             (directory-namestring string)
                                             "fasl\\"
                                             (file-namestring string))))
                          (setf (gethash name-sym *loaded*) t))))))))


(defun clear-loaded ()
  (clrhash *loaded*))


;;; --------------------------------------------------------------------------
;;; OBJECT FUNCTIONS
;;; --------------------------------------------------------------------------


(defvar *readable* nil "Controls whether objects are printed readably")


;;; Saving and loading objects;  save is done with print
(defun save-obj (object &key (file-name "dump.cld"))
  (with-open-file (output file-name 
		   :direction :output 
		   :if-exists :supersede)
    (print object output)))


(defun load-obj (&key (file-name "dump.cld"))
  (with-open-file (input file-name :direction :input)
    (read input)))


;;; --------------------------------------------------------------------------
;;; MATH FUNCTIONS
;;; --------------------------------------------------------------------------


(defun log2 (n)                         ; log 0 seems implementation
  (if (= n 0) -100000000 (log n 2)))	; dependent indefinite or an error


;;; Given a non-negative integer n and a list, returns the list
;;; without its nth item (start counting at 0)
(defun remove-nth (n seq)
  (cond ((null seq) nil)
	((= n 0) (cdr seq))
        (t (cons (car seq) (remove-nth (- n 1) (cdr seq))))))



;;; misc =======


(defun format-display (where how &rest params)
  (apply #'format (append (list where how) params)))
           

(defun display-error (arg1)
;;   (format *top-listener* arg1)
   (format nil arg1))



(defun select-item-from-list (stream values-range prompt)
      (let* ((height (box-height (clipping-box *screen*)))
                (width (box-width (clipping-box *screen*)))
                (win (open-dialog 
                               (list
                                  (make-dialog-item :widget 'static-text
                                         :value prompt
                                         :box (make-box 70 10 390 30))
                                  (make-dialog-item :widget 'single-item-list
                                         :value (car values-range)
                                         :name ':sentences
                                         :range values-range
                                         :box (make-box 10 50  390 (+ 50 (* 22 (length values-range)))))
                                  (make-dialog-item :widget 'default-button
                                         :title "OK"
                                         :name ':ok
                                         :box (make-box 240 (+ 70 (* 22 (length values-range)))
                                                         310 (+ 100 (* 22 (length values-range))))
                                         :set-value-fn #'(lambda (item new old) (values t t)))
                                  (make-dialog-item :widget 'cancel-button
                                         :title "Cancel"
                                         :box (make-box 320 (+ 70 (* 22 (length values-range)))
                                                         390 (+ 100 (* 22 (length values-range))))
                                         :set-value-fn '(lambda (item new old) (values t t))))
                               'dialog stream :pop-up-p t
                               :title ""
                               :window-border :dialog-box
                               :user-closable nil :user-resizable nil :user-scrollable nil
                               :window-interior
                               (make-box
                                      (round (- (/ width 2) 200))
                                      (round (- (/ height 2) (/ (+ (* 22 (length values-range)) 110) 2)))
                                      (round (+ (/ width 2) 200))
                                      (round (+ (/ height 2) (/ (+ (* 22 (length values-range)) 110) 2)))))))
          (when (eql (find-named-object ':ok win) (pop-up-dialog win))
                 (dialog-item-value
                     (find-named-object ':sentences win)))))
                
                
                
;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
