/*
                                 EXL.C
                   Copyright Cheyenne C. Wills 1985
                          All Rights Reserved
 
  Permission is granted to freely distribute this code, but not for
profit, provided that this notice and the following disclaimer are
included in their entirety and without modifications of any sort.  This
work may not be sold, or modified and sold, or included in any other
work to be sold, (except for a nominal media charge), without the
written permission of the author.
 
  Permission is granted to modify the source code and distribute it in
modified form PROVIDED that the authors of any modifications identify
themselves with name and address following this header and that all such
modifications are clearly indicated as to location and purpose, with
descriptive comments that clearly indicate modified lines.
 
  The author would appreciate hearing of any modifications that may be
made, but makes no guarantees that such modifications will be
distributed with future releases of this program.
 
Author's address:
 
        Cheyenne C. Wills
        12 West Locust St.
        Mechanicsburg, Pa. 17055
       (717) 697-5198
 
Disclaimer:
 
  No guarantees or warranties of any kind: This code is distributed
"AS IS" without any warranty of any kind, either expressed or implied,
including, but not limited to the implied warranties of merchantability
and fitness for a particular purpose.  You are soley responsible for the
selection of the program to achieve your intended results and for the
results actually obtained.  Should the program prove defective, you (and
not the author) assume the entire cost of all necessary servicing,
repair, or correction.
 
  Neither the author nor anyone else who has been involved in the
creation, production or delivery of this program shall be liable for any
direct, indirect, consequential or incidental damages arising out of the
use or inability to use this program.
 
*/
char *VERSION = "EXL Version 1.0";
char *COPYR = "(c) Copyright Cheyenne Wills 1985";
 
/*
                               History:
Version    Date    Author                 Reason
-------  --------  ------  ---------------------------------------------
 1.0     01/15/85   CCW    Original code.
 
*/
/*
 
    exl [-i] cmd file1 [file2...filen] [- parms]
 
    where -i:
        indicates an internal dos command
        such as "DIR" or .BAT files.
 
    where cmd is any valid DOS command
 
    file1 file2...filen are any valid file specs (ex: d:\path\name.ext)
    including wild card characters.
 
    anything following the "-" are considered to be options to be
    appended to the end of the file.
    (note that a space must follow the -)
 
    ex:
    exl -i dir *.lst *.xx - /p
    would generate the commands:
 
    dir *.lst /p
    dir *.xx /p
*/
 
#include <stdio.h>
#include <dos.h>
#include <error.h>
 
char internal = 0;
char *cmd;          /* address of command */
char *options = "";      /* address of option string */
char path[FMSIZE];  /* Current path to file */
char cmdstr[127];   /* command string */
int rc;             /* return code */
extern int _oserr;         /* op sys error code */
 
char dta[128];
struct {
    char reserved[21];
    char attrib;
    struct {
        unsigned hh:5;
        unsigned mm:6;
        unsigned ss:5;
    } time;
    struct {
        unsigned yy:7;
        unsigned mm:4;
        unsigned dd:5;
    } date;
    long fsize;
    char filename[13];
} *dtap;
 
main(argc,argv)
int argc;
char **argv;
{
    int i;
    int j;
    char *c;
 
    fprintf(stderr,"%s %s\n",VERSION,COPYR);
 
    dtap = &dta;
 
    if(argc < 3) {
        fputs("EXL Format:\n",stderr);
        fputs("\tEXL [-i] cmd file1 [file2...filen] [- ] [options]\n",stderr);
        fputs("\tWhere: -i indicates command is an internal DOS command\n",stderr);
        fputs("\t\tcmd is the command to execute\n",stderr);
        fputs("\t\tfile1, file2...filen are filespecs to be processed\n",stderr);
        fputs("\t\t\"- \" marks options to follow\n",stderr);
        fputs("\t\toptions will be appended to the command string.\n",stderr);
        exit();
    }
    /* check to see if the first parm is a "-i" */
    if(strcmp(argv[1],"-i") == 0 || strcmp(argv[1],"-I") == 0) {
        i = 2;
        internal++;
    }
    else i = 1;
 
    /* Now locate the command and the options for the command */
    cmd = argv[i++];
    for(j=i;j<argc;j++){
        if(*argv[j] == '-') {
            options = argv[j+1];
            break;
        }
    }
    j--;
 
    for(c=cmd;*c;c++) *c=toupper(*c);
 
    for(;i <= j;i++) docmd(argv[i]);
}
 
/* process one filespec */
docmd(fname)
char *fname;
{
    char *args[3];
    struct fptr {
        struct fptr *next;
        char filen[13];
    } *fbase, *f, *malloc();
 
    if((rc=getfirst(fname))!=NULL) {
        fprintf(stderr,"\nFile Not Found [%s] rc=%d\n",fname,rc);
        askcont();
        return;
    }
    fbase = malloc(sizeof(struct fptr));
    f=fbase;
    f->next = NULL;
    strcpy(f->filen,dtap->filename);
 
    while( getnext() == NULL) {
        f->next = malloc(sizeof(struct fptr));
        f=f->next;
        f->next = NULL;
        strcpy(f->filen,dtap->filename);
    }
    for(f=fbase;f!=NULL;f=f->next) {
 
        if(internal) {
            strcpy(cmdstr,cmd);
            strcat(cmdstr," ");
        }
        else {
            cmdstr[0] = '\0';
            args[0] = cmd;
            args[1] = cmdstr;
            args[2] = NULL;
        }
        strcat(cmdstr,path);
        strcat(cmdstr,f->filen);
        strcat(cmdstr," ");
        strcat(cmdstr,options);
        if(internal) {
            printf("=>%s\n",cmdstr);
            rc=system(cmdstr);
        }
        else {
            printf("=>%s %s\n",cmd,cmdstr);
            rc=forkvp(cmd,&args);
        }
        if(rc!=0) {
            if(_oserr)
                fprintf(stderr,"\nUnable to invoke [%s] RC=%d\n",cmd,_oserr);
            else
                fprintf(stderr,"\nInvalid parm to [%s] parm=[%s]\n",cmd,cmdstr);
            askcont();
            goto Retstor;
        }
 
        rc=wait();
        if(rc) {
            fprintf(stderr,"\n%s RC=%d\n",cmd,rc);
            askcont();
        }
    }
Retstor:
    do { f=fbase->next; free(fbase); fbase=f; } while(f!=NULL);
}
 
getfirst(name)
char *name;
{
    int i;
    union REGS inregs,outregs;
 
    /* First set the address of the current DTA */
    bdos(0x1a,&dta);
 
    /* Parse out the path portion of the filename */
    for(i=strlen(name);
        i >= 0 && name[i]!='/' &&  name[i]!=':' && name[i]!='\\';
        i--);
    /* i now should contain the length of the path */
    if(i>0)     stccpy(&path,name,i+2);
    else path[0]='\0';
    inregs.h.ah = 0x4e;
    inregs.x.dx = (int)name;
    inregs.x.cx = 0x01 | 0x02 | 0x04 | 0x20;
    if(intdos(&inregs,&outregs) & 0x0001) return outregs.x.ax;
    else return NULL;
}
getnext()
{
    int r;
    union REGS inregs,outregs;
    inregs.h.ah = 0x4f;
    inregs.x.dx = (int)&dta;
 
    if(intdos(&inregs,&outregs) & 0x0001) return outregs.x.ax;
    else return NULL;
}
askcont()
{
    int c;
 
    fputs("\n**Error, do you want to continue? (y/n)",stderr);
    while( tolower(c=getch())!='y' &&
           tolower(c) != 'n'  );
    putch(c);
    if(c=='y') return;
    exit(rc);
}
