*
*                         Final Exam Program Problem
*                                   CS 320
*                                Winter, 1987
*
*                               Towers of Hanoi
*
*
*     This program solves the Towers of Hanoi problem for N disks, where N is
* supplied by the user.  It is assumed that the Tower initially resides on
* post A and is to be moved to post C using post B as the spare post.
*
*
*
ZERO       EQU       '0'
CR         EQU       $0D
LF         EQU       $0A
EOT        EQU       $00
           ORG       $0
START      EQU       *
*
*
* Get number of disks to move
*
*
           JSR       PUTIN            * binary number of disks is in D0
           JSR       NULINE
           JSR       NULINE           * skips two lines
*
*
* Do we need to quit?
*
*
           TST.B     D0
           BEQ       OUT              * 0 entered so quit
*
*
* Designate post names and call Hanoi
*
*
           MOVE.B    #'A',D1          * designate left post name as 'A'
           MOVE.B    #'B',D2          * designate middle post name as 'B'
           MOVE.B    #'C',D3          * designate right post name as 'C'
           CLR.W     D4               * # of moves printed on current line := 0
           JSR       HANOI            * call hanoi(N, 'A', 'B', 'C', 0)
           JSR       NULINE           * Take cursor off current line
           JSR       NULINE           * to double space before next print
OUT        JMP       $FFFFFFFE        * RETURN TO SIMULATOR CONTROL
*
*********************** Subroutines Follow **********************************
*
*
*  Subroutine HANOI (N, X, Y, Z, MovesOnLine)
*
*  Calculate and print the moves needed to move N disks from X to Z using Y
*  as a spare.  Each move is printed in the form XNZ meaning move disk N from
*  post X to post Z.  Inputs to this subroutine are expected as follows:
*
*     D0.B - N
*     D1.B - name of post X (an ASCII character)
*     D2.B - name of post Y (an ASCII character)
*     D3.B - name of post Z (an ASCII character)
*     D4.W - MovesOnLine
*
*  HANOI is a recursive routine.  Values are passed through registers D0, D1,
*  D2, D3 and D4 as indicated above. Since register transfer (not stack frame)
*  method of argument passing is used, HANOI must store the contents of D0-D3
*  before calling itself and restore those registers after the call. The EXG
*  instruction is useful for exchanging register contents.  In addition this
*  subroutine calls the subroutine PUTOUT to handle the printing of a move.
*
*
*
*
HANOI      EQU       *
           CMPI.B    #1,D0
           BEQ       BASIS
           MOVEM.L   D0-D3,-(A7)
           SUBQ.B    #1,D0
           EXG       D2,D3
           JSR       HANOI
           MOVEM.L   (A7)+,D0-D3
           BSR       PUTOUT
           MOVEM.L   D0-D3,-(A7)
           SUBQ.B    #1,D0
           EXG       D1,D2
           JSR       HANOI
           MOVEM.L   (A7)+,D0-D3
           RTS
BASIS      EQU       *
           JSR       PUTOUT
           RTS
*
*
********* End of subroutine HANOI *****************************************
*
*
*  Subroutine PUTOUT
*
*     This subroutine handles the printing of the move to be made. The format
* for expressing the move is XNY meaning move disk N from post X to post Y.
* Inputs to this subroutine are expected as follows:
*
*  D0.B - disk number in binary
*  D1.B - post to move from
*  D3.B - post to move to
*  D4.W - number of moves already printed on current line
*
*     This subroutine calls the subroutines PRINT and NULINE for all output.
*
*
*
PUTOUT     EQU       *
           MOVEM.L   D0,-(SP)
           MOVE.B    D1,D5
           JSR       PRINT
           MOVE.B    D0,D5
           ADD.B     #ZERO,D5
           JSR       PRINT
           MOVE.B    D3,D5
           JSR       PRINT
           MOVE.B    #' ',D5
           JSR       PRINT
           ADDQ.B    #1,D4
           CMPI.B    #10,D4
           BLT       OUTRET
           CLR       D4
           JSR       NULINE
OUTRET     EQU       *
           MOVEM.L   (SP)+,D0
           RTS
*
*
*
********** End of subroutine PutOut ****************************************
*
*
* Subroutine PRINT
*
*     This subroutine prints a single character.  The character to be printed
* is expected in the low-order byte of D5.  No values are returned to the cal-
* ling routine.  This subroutine uses the system defined instruction $F000 to
* perform the output.
*
*
PRINT     EQU       *
          MOVE.B    D0,SAVEREG
          MOVE.B    D5,D0
          DC.W      $F000
          MOVE.B    SAVEREG,D0
          RTS
SAVEREG   DS.B      1
*
*
*
*
******** End of subroutine PRINT *******************************************
*
*
* Subroutine NULINE
*
*     This subroutine moves the cursor to the start of a new line. It calls the
* subroutine PRINT to actually send the control characters.  The subroutine re-
* quires no input values and returns no values.
*
*
          DS.W      0
NULINE    EQU       *
          MOVEM.L   D5,-(SP)
          MOVE.B    #CR,D5
          JSR       PRINT
          MOVE.B    #LF,D5
          JSR       PRINT
          MOVEM.L   (SP)+,D5
          RTS
*
*
*
*
******** End of subroutine NULINE *****************************************
*
*
*   Subroutine PUTIN
*
*     This routine obtains the number (one byte, ASCII encoded) of disks to be
* moved.  Since the number of disks is limited to one digit, that number may be
* in the range of 0 to 9 only.  The subroutine quickly converts the number to
* binary and returns it through register D0.  No other registers are altered by
* this routine. No inputs to the subroutine by the calling routine are required.
* This subroutine calls the system defined instruction $A000 for input.
*
BEL        EQU       $07
PUTIN      EQU       *
           MOVEM.L   A0,-(SP)
           LEA       PROMPT,A0        * ask user for number N of disks to
PRMESS     CMPI.B    #EOT,(A0)        * be moved
           BEQ       RCV
           MOVE.B    (A0)+,D5
           JSR       PRINT
           BRA       PRMESS
RCV        DC.W      $A000
           CMPI.B    #$30,D0
           BLT       ERROR
           CMPI.B    #$39,D0
           BGT       ERROR
           SUBI.B    #ZERO,D0
           BRA       EXIT
ERROR      LEA       ERRMESS,A0
PRERRMESS  CMPI.B    #EOT,(A0)
           BEQ       ZEROUT
           MOVE.B    (A0)+,D5
           JSR       PRINT
           BRA       PRERRMESS
ZEROUT     MOVE.B    #0,D0
EXIT       MOVEM.L   (SP)+,A0
           RTS
INDATA     DS.B      4
PROMPT     DC.B      'Enter number (9 or less) of disks to move. (0 to quit): '
           DC.B      EOT
ERRMESS    DC.B      CR,LF,BEL,'WARNING:  The End is near!',EOT
*
*
*
************ End of subroutine PUTIN ****************************************
*
*
           ORG      $2178
           DC.L     $01020304,$05060708,$090A0B0C,$0D0E0F10,$11121314
           END      * of program
