*************************************************************************
*									*
*	This file contains the mnemonic strings for the 8080 opcodes.	*
*	These are used in tracing.					*
*									*
*************************************************************************

	globl mnops

	data
	page
	even

mnops	dc.l mnnop00,mnlxib,mnstaxb,mninxb,mninrb,mndcrb,mnmvib,mnrlca
	dc.l mnnop08,mndadb,mnldaxb,mndcxb,mninrc,mndcrc,mnmvic,mnrrca
	dc.l mnnop10,mnlxid,mnstaxd,mninxd,mninrd,mndcrd,mnmvid,mnral
	dc.l mnnop18,mndadd,mnldaxd,mndcxd,mninre,mndcre,mnmvie,mnrar
	dc.l mnnop20,mnlxih,mnshld,mninxh,mninrh,mndcrh,mnmvih,mndaa
	dc.l mnnop28,mndadh,mnlhld,mndcxh,mninrl,mndcrl,mnmvil,mncma
	dc.l mnnop30,mnlxis,mnsta,mninxs,mninrm,mndcrm,mnmvim,mnstc
	dc.l mnnop38,mndads,mnlda,mndcxs,mninra,mndcra,mnmvia,mncmc
	dc.l mnmovbb,mnmovbc,mnmovbd,mnmovbe,mnmovbh,mnmovbl,mnmovbm,mnmovba
	dc.l mnmovcb,mnmovcc,mnmovcd,mnmovce,mnmovch,mnmovcl,mnmovcm,mnmovca
	dc.l mnmovdb,mnmovdc,mnmovdd,mnmovde,mnmovdh,mnmovdl,mnmovdm,mnmovda
	dc.l mnmoveb,mnmovec,mnmoved,mnmovee,mnmoveh,mnmovel,mnmovem,mnmovea
	dc.l mnmovhb,mnmovhc,mnmovhd,mnmovhe,mnmovhh,mnmovhl,mnmovhm,mnmovha
	dc.l mnmovlb,mnmovlc,mnmovld,mnmovle,mnmovlh,mnmovll,mnmovlm,mnmovla
	dc.l mnmovmb,mnmovmc,mnmovmd,mnmovme,mnmovmh,mnmovml,mnhalt,mnmovma
	dc.l mnmovab,mnmovac,mnmovad,mnmovae,mnmovah,mnmoval,mnmovam,mnmovaa
	dc.l mnaddb,mnaddc,mnaddd,mnadde,mnaddh,mnaddl,mnaddm,mnaddaa
	dc.l mnadcb,mnadcc,mnadcd,mnadce,mnadch,mnadcl,mnadcm,mnadca
	dc.l mnsubb,mnsubc,mnsubd,mnsube,mnsubh,mnsubl,mnsubm,mnsubaa
	dc.l mnsbbb,mnsbbc,mnsbbd,mnsbbe,mnsbbh,mnsbbl,mnsbbm,mnsbba
	dc.l mnandb,mnandc,mnandd,mnande,mnandh,mnandl,mnandm,mnanda
	dc.l mnxrab,mnxrac,mnxrad,mnxrae,mnxrah,mnxral,mnxram,mnxraa
	dc.l mnorab,mnorac,mnorad,mnorae,mnorah,mnoral,mnoram,mnoraa
	dc.l mncmpb,mncmpc,mncmpd,mncmpe,mncmph,mncmpl,mncmpam,mncmpaa
	dc.l mnrnz,mnpopb,mnjnz,mnjmpa,mncnz,mnpushb,mnadi,mnrst0
	dc.l mnrz,mnret,mnjz,mnnopCB,mncz,mncall,mnaci,mnrst8
	dc.l mnrnc,mnpopd,mnjnc,mnout,mncnc,mnpushd,mnsui,mnrst10
	dc.l mnrc,mnnopD9,mnjc,mnin,mncc,mnnopDD,mnsbi,mnrst18
	dc.l mnrpo,mnpoph,mnjpo,mnxthl,mncpo,mnpushh,mnani,mnrst20
	dc.l mnrpe,mnpchl,mnjpe,mnxchg,mncpe,mnpreED,mnxri,mnrst28
	dc.l mnrp,mnpopp,mnjp,mndi,mncp,mnpushp,mnoria,mnrst30
	dc.l mnrm,mnsphl,mnjm,mnei,mncm,mnnopFD,mncpi,mnrst38

	page
*************************************************************************
*									*
*	Mnemonic Strings.  The first character flags operands.		*
*	Blank is nothing, A is an address, C is a constant.		*
*									*
*************************************************************************

mnnop00	dc.b " NOP$"
mnlxib	dc.b "ALXI B,$"
mnstaxb	dc.b " STAX B$"
mninxb	dc.b " INX B$"
mninrb	dc.b " INR B$"
mndcrb	dc.b " DCR B$"
mnmvib	dc.b "CMVI B,$"
mnrlca	dc.b " RLC$"
mnnop08	dc.b " ILLEGAL FOR 8080$"
mndadb	dc.b " DAD B$"
mnldaxb	dc.b " LDAX B$"
mndcxb	dc.b " DCX B$"
mninrc	dc.b " INR C$"
mndcrc	dc.b " DCR C$"
mnmvic	dc.b " MVI C$"
mnrrca	dc.b " RRC$"
mnnop10	dc.b " ILLEGAL FOR 8080$"
mnlxid	dc.b "ALXI D,$"
mnstaxd	dc.b " STAX D$"
mninxd	dc.b " INX D$"
mninrd	dc.b " INR D$"
mndcrd	dc.b " DCR D$"
mnmvid	dc.b "CMVI D,$"
mnral	dc.b " RAL$"
mnnop18	dc.b " ILLEGAL FOR 8080$"
mndadd	dc.b " DAD D$"
mnldaxd	dc.b " LDAX D$"
mndcxd	dc.b " DCX D$"
mninre	dc.b " INR E$"
mndcre	dc.b " DCR E$"
mnmvie	dc.b "CMVI E,$"
mnrar	dc.b " RAR$"
mnnop20	dc.b " ILLEGAL FOR 8080$"
mnlxih	dc.b "ALXI H,$"
mnshld	dc.b "ASHLD $"
mninxh	dc.b " INX H$"
mninrh	dc.b " INR H$"
mndcrh	dc.b " DCR H$"
mnmvih	dc.b "CMVI H,$"
mndaa	dc.b " DAA$"
mnnop28	dc.b " ILLEGAL FOR 8080$"
mndadh	dc.b " DAD H$"
mnlhld	dc.b "ALHLD $"
mndcxh	dc.b " DCX H$"
mninrl	dc.b " INR L$"
mndcrl	dc.b " DCR L$"
mnmvil	dc.b "CMVI L,$"
mncma	dc.b " CMA$"
mnnop30	dc.b " ILLEGAL FOR 8080$"
mnlxis	dc.b "ALXI S,$"
mnsta	dc.b "ASTA $"
mninxs	dc.b " INX S$"
mninrm	dc.b " INR M$"
mndcrm	dc.b " DCR M$"
mnmvim	dc.b "CMVI M,$"
mnstc	dc.b " STC$"
mnnop38	dc.b " ILLEGAL FOR 8080$"
mndads	dc.b " DAD S$"
mnlda	dc.b "ALDA $"
mndcxs	dc.b " DCX S$"
mninra	dc.b " INR A$"
mndcra	dc.b " DCR A$"
mnmvia	dc.b "CMVI A,$"
mncmc	dc.b " CMC$"
mnmovbb	dc.b " MOV B,B$"
mnmovbc	dc.b " MOV B,C$"
mnmovbd	dc.b " MOV B,D$"
mnmovbe	dc.b " MOV B,E$"
mnmovbh	dc.b " MOV B,H$"
mnmovbl	dc.b " MOV B,L$"
mnmovbm	dc.b " MOV B,M$"
mnmovba	dc.b " MOV B,A$"
mnmovcb	dc.b " MOV C,B$"
mnmovcc	dc.b " MOV C,C$"
mnmovcd	dc.b " MOV C,D$"
mnmovce	dc.b " MOV C,E$"
mnmovch	dc.b " MOV C,H$"
mnmovcl	dc.b " MOV C,L$"
mnmovcm	dc.b " MOV C,M$"
mnmovca	dc.b " MOV C,A$"
mnmovdb	dc.b " MOV D,B$"
mnmovdc	dc.b " MOV D,C$"
mnmovdd	dc.b " MOV D,D$"
mnmovde	dc.b " MOV D,E$"
mnmovdh	dc.b " MOV D,H$"
mnmovdl	dc.b " MOV D,L$"
mnmovdm	dc.b " MOV D,M$"
mnmovda	dc.b " MOV D,A$"
mnmoveb	dc.b " MOV E,B$"
mnmovec	dc.b " MOV E,C$"
mnmoved	dc.b " MOV E,D$"
mnmovee	dc.b " MOV E,E$"
mnmoveh	dc.b " MOV E,H$"
mnmovel	dc.b " MOV E,L$"
mnmovem	dc.b " MOV E,M$"
mnmovea	dc.b " MOV E,A$"
mnmovhb	dc.b " MOV H,B$"
mnmovhc	dc.b " MOV H,C$"
mnmovhd	dc.b " MOV H,D$"
mnmovhe	dc.b " MOV H,E$"
mnmovhh	dc.b " MOV H,H$"
mnmovhl	dc.b " MOV H,L$"
mnmovhm	dc.b " MOV H,M$"
mnmovha	dc.b " MOV H,A$"
mnmovlb	dc.b " MOV L,B$"
mnmovlc	dc.b " MOV L,C$"
mnmovld	dc.b " MOV L,D$"
mnmovle	dc.b " MOV L,E$"
mnmovlh	dc.b " MOV L,H$"
mnmovll	dc.b " MOV L,L$"
mnmovlm	dc.b " MOV L,M$"
mnmovla	dc.b " MOV L,A$"
mnmovmb	dc.b " MOV M,B$"
mnmovmc	dc.b " MOV M,C$"
mnmovmd	dc.b " MOV M,D$"
mnmovme	dc.b " MOV M,E$"
mnmovmh	dc.b " MOV M,H$"
mnmovml	dc.b " MOV M,L$"
mnhalt	dc.b " HLT$"
mnmovma	dc.b " MOV M,A$"
mnmovab	dc.b " MOV A,B$"
mnmovac	dc.b " MOV A,C$"
mnmovad	dc.b " MOV A,D$"
mnmovae	dc.b " MOV A,E$"
mnmovah	dc.b " MOV A,H$"
mnmoval	dc.b " MOV A,L$"
mnmovam	dc.b " MOV A,M$"
mnmovaa	dc.b " MOV A,A$"
mnaddb	dc.b " ADD B$"
mnaddc	dc.b " ADD C$"
mnaddd	dc.b " ADD D$"
mnadde	dc.b " ADD E$"
mnaddh	dc.b " ADD H$"
mnaddl	dc.b " ADD L$"
mnaddm	dc.b " ADD M$"
mnaddaa	dc.b " ADD A$"
mnadcb	dc.b " ADC B$"
mnadcc	dc.b " ADC C$"
mnadcd	dc.b " ADC D$"
mnadce	dc.b " ADC E$"
mnadch	dc.b " ADC H$"
mnadcl	dc.b " ADC L$"
mnadcm	dc.b " ADC M$"
mnadca	dc.b " ADC A$"
mnsubb	dc.b " SUB B$"
mnsubc	dc.b " SUB C$"
mnsubd	dc.b " SUB D$"
mnsube	dc.b " SUB E$"
mnsubh	dc.b " SUB H$"
mnsubl	dc.b " SUB L$"
mnsubm	dc.b " SUB M$"
mnsubaa	dc.b " SUB A$"
mnsbbb	dc.b " SBB B$"
mnsbbc	dc.b " SBB C$"
mnsbbd	dc.b " SBB D$"
mnsbbe	dc.b " SBB E$"
mnsbbh	dc.b " SBB H$"
mnsbbl	dc.b " SBB L$"
mnsbbm	dc.b " SBB M$"
mnsbba	dc.b " SBB A$"
mnandb	dc.b " ANA B$"
mnandc	dc.b " ANA C$"
mnandd	dc.b " ANA D$"
mnande	dc.b " ANA E$"
mnandh	dc.b " ANA H$"
mnandl	dc.b " ANA L$"
mnandm	dc.b " ANA M$"
mnanda	dc.b " ANA A$"
mnxrab	dc.b " XRA B$"
mnxrac	dc.b " XRA C$"
mnxrad	dc.b " XRA D$"
mnxrae	dc.b " XRA E$"
mnxrah	dc.b " XRA H$"
mnxral	dc.b " XRA L$"
mnxram	dc.b " XRA M$"
mnxraa	dc.b " XRA A$"
mnorab	dc.b " ORA B$"
mnorac	dc.b " ORA C$"
mnorad	dc.b " ORA D$"
mnorae	dc.b " ORA E$"
mnorah	dc.b " ORA H$"
mnoral	dc.b " ORA L$"
mnoram	dc.b " ORA M$"
mnoraa	dc.b " ORA A$"
mncmpb	dc.b " CMP B$"
mncmpc	dc.b " CMP C$"
mncmpd	dc.b " CMP D$"
mncmpe	dc.b " CMP E$"
mncmph	dc.b " CMP H$"
mncmpl	dc.b " CMP L$"
mncmpam	dc.b " CMP M$"
mncmpaa	dc.b " CMP A$"
mnrnz	dc.b " RNZ$"
mnret	dc.b " RET$"
mnpopb	dc.b " POP B$"
mnjnz	dc.b "AJNZ $"
mnjmpa	dc.b "AJMP $"
mncnz	dc.b "ACNZ $"
mnpushb	dc.b " PUSH B$"
mnadi	dc.b "CADI $"
mnrst0	dc.b " RST 0$"
mnrz	dc.b " RZ$"
mnjz	dc.b "AJZ $"
mnnopCB	dc.b " ILLEGAL FOR 8080$"
mncz	dc.b "ACZ $"
mncall	dc.b "ACALL $"
mnaci	dc.b "CACI $"
mnrst8	dc.b " RST 8$"
mnrnc	dc.b " RNC$"
mnpopd	dc.b " POP D$"
mnjnc	dc.b "AJNC $"
mnout	dc.b "COUT $"
mncnc	dc.b "ACNC $"
mnpushd	dc.b " PUSH D$"
mnsui	dc.b "CSUI $"
mnrst10	dc.b " RST 10$"
mnrc	dc.b " RC$"
mnnopD9	dc.b " ILLEGAL FOR 8080$"
mnjc	dc.b "AJC $"
mnin	dc.b "CIN $"
mncc	dc.b "ACC $"
mnnopDD	dc.b " ILLEGAL FOR 8080$"
mnsbi	dc.b "CSBI $"
mnrst18	dc.b " RST 18$"
mnrpo	dc.b " RPO$"
mnpoph	dc.b " POP H$"
mnjpo	dc.b "AJPO $"
mnxthl	dc.b " XTHL$"
mncpo	dc.b "ACPO $"
mnpushh	dc.b " PUSH H$"
mnani	dc.b "CANI $"
mnrst20	dc.b " RST 20$"
mnrpe	dc.b " RPE$"
mnpchl	dc.b " PCHL$"
mnjpe	dc.b "AJPE $"
mnxchg	dc.b " XCHG$"
mncpe	dc.b "ACPE $"
mnpreED	dc.b " ILLEGAL FOR 8080$"
mnxri	dc.b "CXRI $"
mnrst28	dc.b " RST 28$"
mnrp	dc.b " RP$"
mnpopp	dc.b " POP P$"
mnjp	dc.b "AJP $"
mndi	dc.b " DI$"
mncp	dc.b "ACP $"
mnpushp	dc.b " PUSH P$"
mnoria	dc.b "CORI $"
mnrst30	dc.b " RST 30$"
mnrm	dc.b " RM$"
mnsphl	dc.b " SPHL$"
mnjm	dc.b "AJM $"
mnei	dc.b " EI$"
mncm	dc.b "ACM $"
mnnopFD	dc.b " ILLEGAL FOR 8080$"
mncpi	dc.b "CCPI $"
mnrst38	dc.b " RST 38$"
	.end
