*;
*;**********************************************************
*; DIFFERENCE SIGNAL COMPUTATION
*;
*;	INPUT:	LINEAR PCM SAMPLE -- SL (SAMPLE)
*;		SIGNAL ESTIMATE   -- SE
*;
*;	OUTPUT: DIFFERENCE SIGNAL -- D (accumulator)
*;
*;	NOTATION:  SL -- 14b TC (Q0) [sign extended]
*;		   SE -- 15b TC (Q0) [sign extended]
*;		   D  -- 16b TC (Q0)
*;
*;**********************************************************
*;
*;		  SL   +-------+
*;	       ------->|       |   D
*;		  SE   | SUBTA |------->
*;	       ------->|       |
*;		       +-------+
*;
*;**********************************************************
*;
AQUAN	LAC	SAMPLE		; compute difference sig
	SUB	SE
*;
*;**********************************************************
*;  ADAPTIVE QUANTIZER
*;
*; Implements the following modules (per CCITT spec):
*;
*;	LOG	-- computes log of difference signal
*;	SUBTB	-- scales log by subtracting Y
*;	QUAN	-- computes 4b output
*;
*;**********************************************************
*;
*;	INPUT:	DIFFERENCED PCM SAMPLE -- D (accumulator)
*;		QUANTIZER SCALE FACTOR -- Y (YOVER4)
*;
*;	OUTPUT: ADPCM OUTPUT SAMPLE    -- I
*;
*;	NOTATION:  D	  -- 16b TC (Q0)
*;		   YOVER4 -- 11b SM (Q7) POSITIVE VALUE ONLY
*;		   I	  -- 4b SM (Q0)
*;
*;**********************************************************
*;
*;			     DS
*;	      +-------------------------------+
*;	      | 			      |
*;	      | 			      V
*;   D	  +---+---+  DL   +-------+  DLN  +--------+   I
*; ------>|  LOG  |------>| SUBTB |------>|  QUAN  |------>
*;	  +-------+	  +-------+	  +--------+
*;			      ^
*;			      | Y
*;
*;***********************************************************
*;
*; first get log of difference signal -- express
*; as unsigned 11b number (4b exp/7b mantissa)
*;
*; First order log approximation: log2 (1+x) = x.
*;
	SACH	SIGN	; -1 if neg; 0 if positive (DS)
	ABS
	SACL	TEMP1
GETEXP	SUB	ONE,8	; binary search to get exponent
	BGEZ	C8TO14
C0TO7	ADD	M15,4	; TEMP1-16	 exp = 0-7
	BGEZ	C4TO7
C0TO3	ADD	THREE,2 ; TEMP1-4	 exp = 0-3
	BGEZ	C2TO3
C0TO1	ADD	ONE,1	; TEMP1-2	 exp = 0-1
	BGEZ	EXP1
EXP0	LARK	0,0	; exp = 0
	LAC	TEMP1,7
	B	GETMAN	; save exponent and get mantissa
EXP1	LARK	0,1	; exp = 1
	LAC	TEMP1,6
	B	GETMAN
C2TO3	SUB	ONE,2	; TEMP1-8	exp = 2-3
	BGEZ	EXP3
EXP2	LARK	0,2	; exp = 2
	LAC	TEMP1,5
	B	GETMAN
EXP3	LARK	0,3	; exp = 3
	LAC	TEMP1,4
	B	GETMAN
C4TO7	SUB	THREE,4 ; TEMP1-64	 exp = 4-7
	BGEZ	C6TO7
C4TO5	ADD	ONE,5	; TEMP1-32	 exp = 4-5
	BGEZ	EXP5
EXP4	LARK	0,4	; exp = 4
	LAC	TEMP1,3
	B	GETMAN
EXP5	LARK	0,5	; exp = 5
	LAC	TEMP1,2
	B	GETMAN
C6TO7	SUB	ONE,6	; TEMP1-128	 exp = 6-7
	BGEZ	EXP7
EXP6	LARK	0,6	; exp = 6
	LAC	TEMP1,1
	B	GETMAN
EXP7	LARK	0,7	; exp = 7
	LAC	TEMP1
	B	GETMAN
C8TO14	SUB	M15,8	; TEMP1-4096	 exp = 8-14
	BGEZ	CCTOE
C8TO11	ADD	THREE,10 ;TEMP1-1024	 exp = 8-11
	BGEZ	CATOB
C8TO9	ADD	ONE,9	; TEMP1-512	 exp = 8-9
	BGEZ	EXP9
EXP8	LARK	0,8	; exp = 8
	LAC	TEMP1,15
	SACH	TEMP1
	LAC	TEMP1
	B	GETMAN
EXP9	LARK	0,9	; exp = 9
	LAC	TEMP1,14
	SACH	TEMP1
	LAC	TEMP1
	B	GETMAN
CATOB	SUB	ONE,10	; TEMP1-2048	 exp = 10-11
	BGEZ	EXP11
EXP10	LARK	0,10	; exp = 10
	LAC	TEMP1,13
	SACH	TEMP1
	LAC	TEMP1
	B	GETMAN
EXP11	LARK	0,11	; exp = 11
	LAC	TEMP1,12
	SACH	TEMP1
	LAC	TEMP1
	B	GETMAN
CCTOE	SUB	THREE,12 ; TEMP1-16384	 exp = 12-14
	BGEZ	EXP14
CCTOD	ADD	ONE,13	 ; TEMP1-8192	 exp = 13-14
	BGEZ	EXP13
EXP12	LARK	0,12	; exp = 12
	LAC	TEMP1,11
	SACH	TEMP1
	LAC	TEMP1
	B	GETMAN
EXP13	LARK	0,13	; exp = 13
	LAC	TEMP1,10
	SACH	TEMP1
	LAC	TEMP1
	B	GETMAN
EXP14	LARK	0,14	; exp = 14
	LAC	TEMP1,9
	SACH	TEMP1
	LAC	TEMP1
GETMAN	AND	M127
	SAR	0,TEMP1
	ADD	TEMP1,7 ; DL  4e...7m (sign=SGN(D))
*;
*;--------------------------------------------------
*;
*; scale LOG D by subtraction (Y>>2 is in YOVER4)
*;
*;--------------------------------------------------
*;
SUBTB	ADD	ONE,11	; offset by 2K
	SUB	YOVER4
*;
*;--------------------------------------------------
*; 16 LEVEL quantizer
*;
*; Table values defined in CCITT spec p67
*; Implemented table is offset by 2048
*;--------------------------------------------------
*;
ITAB1:	.set	2041	; bottom of level 1
ITAB2:	.set	2171	; bottom of level 2
ITAB3:	.set	2250	; bottom of level 3
ITAB4:	.set	2309	; bottom of level 4
ITAB5:	.set	2358	; bottom of level 5
ITAB6:	.set	2404	; bottom of level 6
ITAB7:	.set	2453	; bottom of level 7
*;
QUAN	SUB	K2309	; TEMP2-2309
	BGEZ	CI4TO7
CI0TO3	ADD	K138	; TEMP2-2171	I = 0-3
	BGEZ	CI2TO3
CI0TO1	ADD	K130	; TEMP2-2041	I = 0-1
	BGEZ	IEQ1
IEQ0	LACK	0
	B	GETIM
IEQ1	LACK	1
	B	GETIM
CI2TO3	SUB	K79	; TEMP2-2250	I = 2-3
	BGEZ	IEQ3
IEQ2	LACK	2
	B	GETIM
IEQ3	LACK	3
	B	GETIM
CI4TO7	SUB	K95	; TEMP2-2404	I = 4-7
	BGEZ	CI6TO7
CI5TO6 ADD	K46	; TEMP2-2358	I = 5-6
	BGEZ	IEQ5
IEQ4	LACK	4
	B	GETIM
IEQ5	LACK	5
	B	GETIM
CI6TO7	SUB	K49	; TEMP2-2453	I = 6-7
	BGEZ	IEQ7
IEQ6	LACK	6
	B	GETIM
IEQ7	LACK	7
GETIM	SACL	IM	; accumulator = |I|
	XOR	SIGN	; add sign bit and flip if necessary
	AND	M15	; mask for final four-bit value
QDONE	RET	;; return from AQUAN
	.page
