*;
*;**********************************************************
*; ADAPTATION/PREDICTION
*;
*;  Implements the following modules per CCITT spec:
*;
*;    Inverse Adaptive Quantizer
*;	RECONST 	-- reconstructs D from I
*;	ADDA		-- adds back scale factor
*;	ANTILOG 	-- log to lin conversion to get DQ
*;	FLOAT A 	-- float DQ
*;    Scale Factor Adaptation
*;	FUNCTW		-- map I to log scale factor
*;	FILTD		-- update fast scale factor
*;	LIMB		-- limit scale factor
*;	FILTE		-- update slow scale factor
*;    Adaptation Speed Control
*;	FUNCTF		-- map I to F function
*;	FILTA		-- update short term ave of F
*;	FILTB		-- update long term ave of F
*;	SUBTC		-- determ speed control update
*;				technique
*;	FILTC		-- update speed control
*;    Adaptive Predictor
*;	ADDB		-- compute reconstructed signal
*;	FLOAT A 	-- float SR
*;	ADDC		-- compute sign of PK
*;	UPA2		-- update A2 coeff of 2nd order pred
*;	LIMC		-- limit A2
*;	UPA1		-- update A1 coeff of 2nd order pred
*;	LIMD		-- limit A1
*;	UPB		-- update coeffs of 6th order pred
*;	XOR		-- compute sign of DQ*DQn
*;
*;	NOTE: DELAY A/B/C implicit in timing of MIX/LIMA
*;	      and computation of SEZ/SE
*;
*;**********************************************************
*;
*; First convert quantized difference back to log domain.
*; This is done by table look-up.  Also use ADPCM magnitude
*; to look-up the scale-factor multipliers WI and rate-of-
*; change weighting function FI.
*;
PRDICT	LACK	IQ0
	ADD	IM,2
	SACL	TEMP1
	LAR	0,TEMP1
*;
*;**********************************************************
*; INVERSE ADAPTIVE QUANTIZER
*;
*;	INPUT:	ADPCM INPUT SAMPLE     -- I (IM->TEMP1)
*;		QUANTIZER SCALE FACTOR -- Y (YOVER4)
*;
*;	OUTPUT: QUANTIZED DIFFERENCE SIGNAL -- DQ
*;
*;	NOTATION:  I	  -- 4b SM (Q0)
*;		   IM	  -- 3b magnitude (Q0)
*;		   DQLN(TEMP1) -- 12b TC (Q7) [sign extended]
*;		   YOVER4 -- 11b SM (Q7) POSITIVE VALUE ONLY
*;		   DQ	  -- 15b TC (Q0) [sign extended]
*;		   DQMAN*8-- 9b magnitude
*;		   DQEXP  -- 4b magnitude
*;
*;**********************************************************
*;
*;			     DQS
*;	      +-------------------------------+
*;	      | 			      |
*;	      | 			      V
*;   I	  +---+---+ DQLN  +-------+  DQL  +--------+  DQ
*; ------>|RECONST|------>| ADDA  |------>|ANTILOG |------>
*;	  +-------+	  +-------+	  +--------+
*;			      ^
*;			      | Y
*;
*;***********************************************************
*;
*; add back scale factor
*;
ADDA	LAC	*+,5
	ADD	YOVER4,5
*;
*; now covert to linear domain
*;
ALOG	ADD	ONE,12		; inc exponent for floated value
	SACH	DQEXP,4 	; save exponent + sign ext
	AND	M4095		; isolate mantissa * 2**5
	ADD	ONE,12		; Alog x = 1 + x
	SACL	DQMAN		; DQMAN = 0001 XXXX XXX0 0000
	LAC	DQEXP
	ADD	SHIFT		; add table ptr
	TBLR	TEMP3		; get multiplier
	LT	TEMP3
	ADD	ONE,4		; offset to mask table
	TBLR	TEMP3		; mask for dqman
	MPY	DQMAN		; adjust mantissa
	PAC
	SACH	DQ,4
ADDSGN	LAC	DQ		; absolute DQ
	XOR	SIGN		; take 1's complement if neg
	SUB	SIGN		; add 1 for 2's comp if neg
	SACL	DQ
	LAC	SIGN,12 	; load -4096 if neg/ 0 if pos
	ADD	ONE,11		; add 2048 += +2048, -= -2048
	SACL	SDQ
*;
*;**********************************************************
*; FLOAT DQ -- convert 2's comp number to floating
*;
*;	INPUT:	DQ
*;
*;	OUTPUT: 4b exponent in DQEXP (saved from log value)
*;		6b mantissa*8 in DQMAN (adjusted from log)
*;		sign preserved in DQ
*;
*;**********************************************************
*;
FLTDQ	LAC	DQMAN,5 ; 00000000 0000001X XXXXXX00 00000000
	SACH	DQMAN,4 ; DQMAN = 0000 0000 001X XXXX
	LAC	DQMAN,3 ; DQMAN * 2**3
	AND	TEMP3
	SACL	DQMAN
*;
*;**********************************************************
*; QUANTIZER SCALE FACTOR ADAPTATION
*;
*;	INPUT:	ADPCM SAMPLE  -- I
*;
*;	OUTPUT: FAST QUANTIZER SCALE FACTOR -- YU
*;		SLOW QUANTIZER SCALE FACTOR -- YL (YLL/YLH)
*;
*;	NOTATION: I  -- 4b SM (Q0)
*;		  YU -- 13b unsigned (Q9)
*;		  YL -- 19b unsigned (Q15)
*;		      stored as:
*;			 low 15b -- YLL
*;			 hi   4b -- YLH
*;
*;**********************************************************
*;
*; WI  +-------+YUT +------+YUP +--------+	  YU
*; --->| FILTD |--->| LIMB |-+->| DELAYB |---------------->
*;     +-------+    +------+ |	+--------+
*;	   ^		     |
*;	   | Y		     |	+-------+YLP +--------+ YL
*;	   |		     +->| FILTE |--->| DELAYC |-+->
*;				+-------+    +--------+ |
*;				    ^			|
*;				    +-------------------+
*;
*;**********************************************************
*; Update fast adaptation scale factor
*;
*;   YU(k) = (1-2**-5)*Y(k) + (2**-5)*W(I(k))
*;
*;	INPUT:	QUANTIZER SCALE FACTOR	-- Y
*;		SCALE FACTOR MULTIPLIER -- WI
*;
*;	OUTPUT: FAST QUANTIZER SCALE FACTOR -- YU
*;
*;	NOTATION:  WI -- 12b TC (Q4) [sign extended]
*;		   Y  -- 13b unsigned (Q9)
*;		   YU -- 13b unsigned (Q9)
*;
*;**********************************************************
*;
FILTD	LAC	Y,12		; Y	(Q21)
	SUB	Y,7		; Y/32	(Q21)
	ADD	*+,12		; WI/32 (Q21)
	SACH	YU,4		; YU	(Q9)
*;
*; limit quant scale factor 1.06 <= YU <= 10.0
*;
LIMB	SUB	K544,12 	; check lo threshold
	BGEZ	CHKHI
	LAC	K544
	B	STRLIM		; go store limited value
CHKHI	SUB	K4576,12	; check hi threshold
	BLEZ	FILTE		; within limits--continue
	LAC	K5120
STRLIM	SACL	YU
*;
*;**********************************************************
*; Update slow adaptation scale factor
*;
*;   YL(k) = (1-2**-6)*YL(k-1) + 2**-6 * YU(k)
*;
*;	INPUT:	SLOW QUANTIZER SCALE FACTOR -- YL (YLL/YLH)
*;		FAST QUANTIZER SCALE FACTOR -- YU
*;
*;	OUTPUT: SLOW QUANTIZER SCALE FACTOR -- YL (YLL/YLH)
*;
*;	NOTATION:  YU -- 13b unsigned (Q9)
*;		   YL -- 19b unsigned (Q15)
*;		       stored as:
*;			  low  6b -- YLL
*;			  hi  13b -- YLH
*;
*;**********************************************************
*;
FILTE	LAC	YLH,15	    ; YL      (Q24)
	ADD	YLL,9
	SUB	YLH,9	    ; YL/64   (Q24)
	SUB	YLL,3
	ADD	YU,9	    ; YU/64   (Q24)
	SACH	YLH,1
	AND	M32767
	SACL	TEMP2
	LAC	TEMP2,6
	SACH	YLL,1
*;
*;**********************************************************
*; ADAPTATION SPEED CONTROL
*;
*;	INPUT:	ADPCM SAMPLE  -- I
*;
*;	OUTPUT: UNLIMITED SPEED CONTROL -- AP (APP)
*;
*;	NOTATION: I   -- 4b SM (Q0)
*;		  APP -- 10b unsigned (Q8)
*;
*;**********************************************************
*;
*;			| Y
*;			V
*; FI  +-------+DMSP+-------+ AX +-------+APP +--------+ AP
*; -+->| FILTA |-+->| SUBTC |--->| FILTC |--->| DELAYA |-+->
*;  |  +-------+ |  +-------+	 +-------+    +--------+ |
*;  |	   ^	 V	 ^	     ^			 |
*;  |	DMS| +--------+  |	     +-------------------+
*;  |	   +-| DELAYA |  |
*;  |	     +--------+  |
*;  |			 |
*;  |  +-------+  DMLP	 |
*;  +->| FILTB |--+------+
*;     +-------+  |
*;	   ^	  V
*;	DML| +--------+
*;	   +-| DELAYA |
*;	     +--------+
*;
*;**********************************************************
*; update short term average of FI
*;
*;   DMS(k) = (1-2**-5)*DMS(k-1) + 2**-5 * FI(k)
*;
*;	INPUT:	SHORT TERM AVERAGE	-- DMS
*;		RATE-OF-CHANGE FUNCTION -- FI
*;
*;	OUTPUT: SHORT TERM AVERAGE -- DMS
*;
*;	NOTATION:  DMS -- 12b unsigned (Q9)
*;		   FI  -- 7b unsigned (Q4)
*;
*;**********************************************************
*;
FILTA	LAC	*,15		; FI/32  (Q24)
	ADD	DMS,15		; DMS	 (Q24)
	SUB	DMS,10		; DMS/32 (Q24)
	SACH	DMS,1
*;
*;**********************************************************
*; update long term average of FI
*;
*;   DML(k) = (1-2**-7)*DML(k-1) + 2**-7 * FI(k)
*;
*;	INPUT:	LONG TERM AVERAGE	-- DML
*;		RATE-OF-CHANGE FUNCTION -- FI
*;
*;	OUTPUT: LONG TERM AVERAGE -- DML
*;
*;	NOTATION:  DML -- 14b unsigned (Q11)
*;		   FI  -- 7b unsigned (Q4)
*;
*;**********************************************************
*;
FILTB	LAC	*,15		; FI/128   (Q26)
	ADD	DML,15		; DML	   (Q26)
	SUB	DML,8		; DML/128  (Q26)
	SACH	DML,1
*;
*;----------------------------------------------------------
*; Compute mag of diff of short and long term functions of
*; quantizer output sequence and perform threshold
*; comparison to compute speed control parameter--low-pass
*; result.
*;
*;   APP(k) = (1-2**-4)*APP(k-1) + 2**-3 , if Y < 3 or
*;				if |DMS-DML| > 2**-3 * DML
*;   else
*;
*;   APP(k) = (1-2**-4)*APP(k-1)
*;
*;	INPUT:	SHORT TERM AVERAGE	-- DMS
*;		LONG TERM AVERAGE	-- DML
*;		UNLIMITED SPEED CONTROL -- APP
*;		QUANTIZER SCALE FACTOR	-- Y
*;
*;	OUTPUT: UNLIMITED SPEED CONTROL -- APP
*;
*;	NOTATION:  APP -- 10b unsigned (Q8)
*;		   Y   -- 13b unsigned (Q9)
*;		   DMS -- 12b unsigned (Q9)
*;		   DML -- 14b unsigned (Q11)
*;
*;**********************************************************
*;
FILTC	ZALH	APP		; APP		 (Q24)
	SUB	APP,12		; APP/16	 (Q24)
	SACH	APP		; (1-2**-4)*APP  (Q8)
	LAC	Y
	SUB	THREE,9 	; 3	  (Q9)
	BLZ	ADD18
	LAC	DML,13		; DML/8   (Q27)
	SACH	TEMP3		; DML/8   (Q11)
	LAC	DMS,2		; DMS	  (Q11)
	SUB	DML		; DMS-DML
	ABS
	SUB	TEMP3		; |DMS-DML|-DML/8
	BLZ	APRED
ADD18	LAC	APP		; APP	  (Q8)
	ADD	ONE,5
	SACL	APP		; + 1/8   (Q8)
*;
*;***********************************************************
*; ADAPTIVE PREDICTOR
*;
*;***********************************************************
*;
APRED:	.set	$
*;
*;***********************************************************
*; compute coeff of 6th order predictor
*;
*; Bi(k) = (1-2**-8)*Bi(k-1) + 2**-7*SGN[DQ(k)]*SGN[DQ(k-i)]
*;     for i = 1...6
*;     and Bi is implicitly limited to +/- 2
*;
*;	NOTATION:	Bn   -- 16b TC (Q14)
*;			SDQn -- +2048 if sign positive
*;				-2048 if sign negative
*;
*;***********************************************************
*;
GETB6	LT	SDQ6
	LAC	B6,8	; B6 * 2**-8 TRUNCATED
	SACH	TEMP1
	LAC	B6,15	; Q29
	SUB	TEMP1,15
	MPY	SDQ	; SGN(SDQ)*SGN(SDQ6) * 2**-7  (Q29)
	LTD	SDQ5
	SACH	B6,1	; Q14
GETB5	LAC	B5,8	; B5 * 2**-8 TRUNCATED
	SACH	TEMP1
	LAC	B5,15	; Q29
	SUB	TEMP1,15
	MPY	SDQ
	LTD	SDQ4
	SACH	B5,1	; Q14
GETB4	LAC	B4,8	; B4 * 2**-8 TRUNCATED
	SACH	TEMP1
	LAC	B4,15	; Q29
	SUB	TEMP1,15
	MPY	SDQ
	LTD	SDQ3
	SACH	B4,1	; Q14
GETB3	LAC	B3,8	; B3 * 2**-8 TRUNCATED
	SACH	TEMP1
	LAC	B3,15	; Q29
	SUB	TEMP1,15
	MPY	SDQ
	LTD	SDQ2
	SACH	B3,1	; Q14
GETB2	LAC	B2,8	; B2 * 2**-8 TRUNCATED
	SACH	TEMP1
	LAC	B2,15	; Q29
	SUB	TEMP1,15
	MPY	SDQ
	LTD	SDQ1
	SACH	B2,1	; Q14
GETB1	LAC	B1,8	; B1 * 2**-8 TRUNCATED
	SACH	TEMP1
	LAC	B1,15	; Q29
	SUB	TEMP1,15
	MPY	SDQ
	LTD	SDQ
	SACH	B1,1	; Q14
*;
*;**********************************************************
*; To update coefficients of 2nd order predictor,
*; First get sign of sum of SEZ and DQ
*;
*;	NOTATION: if SEZ+DQ >= 0 then PK0 = 512
*;		  else		      PK0 = -512
*;
*;**********************************************************
*;
ADDC	DMOV	PK1		; PK1==>PK2
	DMOV	PK0		; PK0==>PK1
	LAC	SEZ
	ADD	DQ,1
	SACH	TEMP1	    ; FFFF or 0000
	LAC	TEMP1,10    ; FC00 or 0000
	ADD	ONE,9	    ; FE00 or 0200 | -512 or +512
	SACL	PK0
SUMGT0	LT	PK0
*;
*;**********************************************************
*;  now calculate 1/2 * f[A1(k-1)]
*;
*;	  = 2*A1       if |A1|	<= 1/2
*;	  = SGN(A1)    if |A1|	>  1/2
*;
*;**********************************************************
*;
GETF	LAC	A1,1		; 2*A1
	SACL	TEMP3
	BLZ	GETF2
GETF1	SUB	ONE,14		; is |A1| < 1/2
	BLZ	GETA1
	LAC	K16382		; approx 1
	B	DONEF
GETF2	ABS
	SUB	ONE,14		; is |A1| < 1/2
	BLZ	GETA1
	LAC	M16382		; approx -1
DONEF	SACL	TEMP3
*;
*;**********************************************************
*; Compute A1 coeff of 2nd order predictor
*;
*;   A1(k) = (1-2**-8)*A1(k-1)
*;			 + (3*2**-8)*SGN[p(k)]*SGN[p(k-1)]
*;
*;	NOTATION:  A1  -- 16b TC (Q14)
*;		   PKn -- +512 if SGN[p(k)] = 1
*;			  -512 if SGN[p(k)] = -1
*;
*;**********************************************************
*;
GETA1	LAC	A1,8		; A1*2**-8 TRUNCATED
	SACH	TEMP2
	LAC	A1,12		; Q26
	SUB	TEMP2,12
	MPY	PK1		; SGN[p(k-1)*SGN[p(k)]
	APAC
	APAC
	APAC			; +3*SGN[p(k-1)*SGN[p(k)]
	SACH	A1,4		; store as Q14
	PAC			; save sign
*;
*;**********************************************************
*; Compute A2 coeff of 2nd order predictor
*;
*;   A2(k) = (1-2**-7)*A2(k-1)
*;	      + (2**-7)*{SGN[p(k)]*SGN[(p(k-2)]
*;			 - f[A1(k-1)]*SGN[p(k)]*SGN[p(k-1)]}
*;
*;	NOTATION:  A2	     -- 16b TC (Q14)
*;		   F(),TEMP3 -- 16b TC (Q14)
*;		   PKn	     -- +512 if SGN[p(k)] = 1
*;				-512 if SGN[p(k)] = -1
*;
*;**********************************************************
*;
GETA2	BGEZ	SUBF		; if sign + --> subtract F
	ZAC			;  else negate F and subtract
	SUB	TEMP3
	SACL	TEMP3
*;
SUBF	LAC	A2,9		; A2*2**-7 TRUNCATED
	SACH	SUM4
	MPY	PK2		; SGN[p(k-2)]*SGN[p(k)]
	PAC
	APAC			; 2*2**-8*above  (Q26)
	SUB	TEMP3,6 	; 2*TEMP3*2**-7  (Q26)
	SACH	TEMP3,4 	; Q14
	LAC	A2
	SUB	SUM4		; leak factor
	ADD	TEMP3
	SACL	A2		; Q14
*
	SACH	TEMP1		; save sign to make +/- .75
*;
*; limit A2 to +/- .75 and prevent overflow
*;
LIMC	ABS
	SUB	THREE,12	; |value| must be < .75
	BLEZ	LIMD
	LAC	THREE,12	; .75  (Q14)
	XOR	TEMP1		; 1's complement if negative
	SUB	TEMP1		; 2's complement if negative
DONEC	SACL	A2		; Q14
*;
*; limit A1(k) to +/- [1-2**-4 - A2(k)]
*;
LIMD	LAC	M15,10		; 1-2**-4      (Q14)
	SUB	A2
	SACL	TEMP1		; 1-2**-4-A2P  (Q14)
	LAC	A1
	SACH	SIGN		; save sign to make +/- LIMIT
	ABS
	SUB	TEMP1
	BLEZ	FLTSR		; A1 <= LIMIT
A1LIM	LAC	TEMP1		; ABS value of LIMIT
	XOR	SIGN		; 1's complement if negative
	SUB	SIGN		; 2's complement if negative
	SACL	A1		; Q14
*;
*;**********************************************************
*; COMPUTE RECONSTRUCTED SIGNAL
*;
*;	INPUT:	QUANTIZED DIFFERENCE SIGNAL -- DQ
*;		SIGNAL ESTIMATE 	    -- SE
*;
*;	OUTPUT: RECONSTRUCTED SIGNAL -- SR
*;
*;	NOTATION:  DQ -- 15b TC (Q0) [sign extended]
*;		   SE -- 15b TC (Q0) [sign extended]
*;		   SR -- 16b TC (Q0)
*;
*;**********************************************************
*; FLOAT SR -- convert 2's comp number to floating
*;
*;	INPUT:	accumulator
*;
*;	OUTPUT: --4b exponent left in SREXP
*;		--6b mantissa*8 left in SRMAN
*;		--sign preserved in SR
*;
*;**********************************************************
*;
FLTSR	LAC	DQ	; compute reconstructed signal
	ADD	SE
	SACL	SR
	ABS		; convert to floating point notation
	SACL	SRMAN
	SUB	ONE,7	; binary search to get exponent
	BGEZ	D8TOF
D0TO7	ADD	M15,3	; TEMP1-8 -- exp = 0-7
	BGEZ	D4TO7
D0TO3	ADD	THREE,1 ; TEMP1-2 -- exp = 0-3
	BGEZ	D2TO3
D0TO1	LAC	SRMAN	; exp = 0-1
EXX01	SACL	SREXP
	LAC	ONE,8
	SACL	SRMAN
	RET
D2TO3	SUB	ONE,1	; TEMP1-4 -- exp = 2-3
	BGEZ	EXX3
EXX2	LAC	SRMAN,7 ; exp=2
	SACL	SRMAN
	LACK	2
	SACL	SREXP
	RET
EXX3	LAC	SRMAN,6 ; exp=3
	SACL	SRMAN
	LACK	3
	SACL	SREXP
	RET
D4TO7	SUB	THREE,3 ; TEMP1-32 -- exp = 4-7
	BGEZ	D6TO7
D4TO5	ADD	ONE,4	; TEMP1-16 -- exp = 4-5
	BGEZ	EXX5
EXX4	LAC	SRMAN,5 ; exp=4
	SACL	SRMAN
	LACK	4
	SACL	SREXP
	RET
EXX5	LAC	SRMAN,4 ; exp=5
	SACL	SRMAN
	LACK	5
	SACL	SREXP
	RET
D6TO7	SUB	ONE,5	; TEMP1-64 -- exp = 6-7
	BGEZ	EXX7
EXX6	LAC	SRMAN,3 ; exp=6
	SACL	SRMAN
	LACK	6
	SACL	SREXP
	RET
EXX7	LAC	SRMAN,15
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	7
	SACL	SREXP
	RET
D8TOF	SUB	M15,7	; TEMP1-2048 -- exp = 8-15
	BGEZ	DCTOF
D8TOB	ADD	THREE,9 ; TEMP1-512 -- exp = 8-11
	BGEZ	DATOB
D8TO9	ADD	ONE,8	; TEMP1-256 -- exp = 8-9
	BGEZ	EXX9
EXX8	LAC	SRMAN,14 ; exp=8
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	8
	SACL	SREXP
	RET
EXX9	LAC	SRMAN,13 ; exp=9
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	9
	SACL	SREXP
	RET
DATOB	SUB	ONE,9	 ; TEMP1-1024 -- exp=10-11
	BGEZ	EXX11
EXX10	LAC	SRMAN,12 ; exp=10
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	10
	SACL	SREXP
	RET
EXX11	LAC	SRMAN,11 ; exp=11
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	11
	SACL	SREXP
	RET
DCTOF	SUB	THREE,11 ; TEMP1-8192 -- exp=12-15
	BGEZ	DETOF
DCTOD	ADD	ONE,12	 ; TEMP1-4096 -- exp=12-13
	BGEZ	EXX13
EXX12	LAC	SRMAN,10 ; exp=12
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	12
	SACL	SREXP
	RET
EXX13	LAC	SRMAN,9  ; exp=13
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	13
	SACL	SREXP
	RET
DETOF	SUB	ONE,13	 ; TEMP1-16384 -- exp=14-15
	BGEZ	EXX15
EXX14	LAC	SRMAN,8  ; exp=14
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	14
	SACL	SREXP
	RET
EXX15	LAC	SRMAN,7  ; exp=15
	SACH	SRMAN
	LAC	SRMAN,3
	SACL	SRMAN
	LACK	15
	SACL	SREXP
	RET
	.page
