*;
*;**********************************************************
*;	ROM
*;**********************************************************
ROMLOC: .space	0*16
*; SHIFT MULT TABLE
SHFT:	.space	0*16
	.word	0	; log dq to flt dq exponent adjustment
	.word	1
	.word	2
	.word	4
	.word	8
	.word	16
	.word	32
	.word	64
	.word	128
	.word	256
	.word	512
	.word	1024
	.word	2048
	.word	4096
	.word	8192
	.word	16384
*; DQMAN MASK TABLE
	.word	65024
	.word	65280
	.word	65408
	.word	65472
	.word	65504
	.word	65520
	.word	65528
	.word	65528
	.word	65528
	.word	65528
	.word	65528
	.word	65528
	.word	65528
	.word	65528
	.word	65528
	.word	65528
*;
*; misc constants to be initialized
*;
CONS1:	.space	0*16
	.word	2   ; 12th entry of shift table (1st 11 all 0)
	.word	4
	.word	8
	.word	16
	.word	32
	.word	64
	.word	128
	.word	256
	.word	512
	.word	1024
	.word	2048
	.word	4096
	.word	8192
	.word	16384
	.word	-1
	.word	-2
	.word	-4
NOCNS1: .set	$-CONS1
*;
CONS2:	.space	0*16
	.word	79	;K79
	.word	95	;K95
	.word	130	;K130
	.word	138	;K138
	.word	2309	;K2309
	.word	4095	;M4095
	.word	16382	;K16382
*; INVERSE QUANTIZING TABLE
IQTAB:	.space	0*16
	.word	65401	;IQ(0)
*; WI TABLE
WTABLE: .space	0*16
	.word	65524	;WI(0)
*; FI TABLE
FITABL: .space	0*16
	.word	0	;FI(0)
	.word	-16382	;M16382
	.word	68	;IQ(1)
	.word	4	;WI(1)
	.word	0	;FI(1)
	.word	4576	;K4576
	.word	165	;IQ(2)
	.word	27	;WI(2)
	.word	0	;FI(2)
	.word	5120	;K5120
	.word	232	;IQ(3)
	.word	50	;WI(3)
	.word	16	;FI(3)
	.word	SHFT	;SHIFT
	.word	285	;IQ(4)
	.word	98	;WI(4)
	.word	16	;FI(4)
	.word	0	;** dummy
	.word	332	;IQ(5)
	.word	184	;WI(5)
	.word	16	;FI(5)
	.word	0	;** dummy
	.word	377	;IQ(6)
	.word	340	;WI(6)
	.word	48	;FI(6)
	.word	0	;** dummy
	.word	428	;IQ(7)
	.word	1108	;WI(7)
	.word	112	;FI(7)
	.word	0	;** dummy
NOCNS2: .set	$-CONS2
	.page
*;**********************************************************
*;	 RAM
*;**********************************************************
RAMLOC: .space	0*16
*
	.sect	"DORG0"
*;
*;  RAM Location # 000
TEMP1:	.word	0	; temp
*;
*;  RAM Location # 001
SUM1:	.space	0	*16; temp storage of DQ6*B6 tap
TEMP2:	.word	0	; temp
*;
*;  RAM Location # 002
SUM2:	.space	0	*16; temp storage of DQ5*B5 tap
TEMP3:	.word	0	; temp
*;
*;  RAM Location # 003
SUM3:	.word	0	; temp storage of DQ4*B4 tap
*;
*;  RAM Location # 004
SUM4:	.word	0	; temp storage of DQ3*B3 tap
*;
*;  RAM Location # 005
SUM5:	.space	0	*16; temp storage of DQ2*B2 tap
YOVER4: .word	0	; Y>>2
*;
*;  RAM Location # 006
SUM6:	.space	0	*16; temp storage of DQ1*B1 tap
SIGN:	.word	0	; temp
*;
*;  RAM Location # 007
SUM7:	.space	0	*16; temp storage of SR1*A1 tap
SAMPLE: .word	0	; Linear sample
*;
*;  RAM Location # 008
SUM8:	.space	0	*16; temp storage of SR2*A2 tap
AL:	.word	0	; limited speed control parm
*;
*;  RAM Location # 009
SCRACH: .word	0	; scrach variable
*;
*;  RAM Location # 010
I:	.word	0	; 32Kb output
*;
*;  RAM Location # 011
IM:	.word	0	; 8-level version of I
*;
*;  RAM Location # 012
SE:	.word	0	; signal estimate
*;
*;  RAM Location # 013
SEZ:	.word	0	; partial signal estimate
*;
*;  RAM Location # 014
APP:	.word	0	; unlimited speed control parm
*;
*;  RAM Location # 015
SR:	.word	0	; reconstructed signal frame k
*;
*;  RAM Location # 016
SR1:	.word	0	; reconstructed signal frame k
*;
*;  RAM Location # 017
DQ:	.word	0	; quantized diff signal
*;
*;  RAM Location # 018
Y:	.word	0	; quantizer scale factor
*;
*;  RAM Location # 019
B1:	.word	0	; 6th order predictor coefficient
*;
*;  RAM Location # 020
B2:	.word	0	; 6th order predictor coefficient
*;
*;  RAM Location # 021
B3:	.word	0	; 6th order predictor coefficient
*;
*;  RAM Location # 022
B4:	.word	0	; 6th order predictor coefficient
*;
*;  RAM Location # 023
B5:	.word	0	; 6th order predictor coefficient
*;
*;  RAM Location # 024
B6:	.word	0	; 6th order predictor coefficient
*;
*;  RAM Location # 025
A1:	.word	0	; coefficients of 2nd order predictor
*;
*;  RAM Location # 026
A2:	.word	0	; coefficients of 2nd order predictor
*;
*;  RAM Location # 027
DMS:	.word	0	; short term average of F
*;
*;  RAM Location # 028
DML:	.word	0	; long term average of F
*;
*;  RAM Location # 029
DQEXP:	.word	0	; exponent of DQ
*;
*;  RAM Location # 030
DQ1EXP: .word	0	; exponent of DQ1
*;
*;  RAM Location # 031
DQ2EXP: .word	0	; exp of DQ2
*;
*;  RAM Location # 032
DQ3EXP: .word	0	; exp of DQ3
*;
*;  RAM Location # 033
DQ4EXP: .word	0	; exp of DQ4
*;
*;  RAM Location # 034
DQ5EXP: .word	0	; exp of DQ5
*;
*;  RAM Location # 035
SREXP:	.word	0	; exp of SR
*;
*;  RAM Location # 036
SR1EXP: .word	0	; exp of SR1
*;
*;  RAM Location # 037
YLL:	.word	0	; slow quant scale factor (lo word)
*;
*;  RAM Location # 038
FLTSFT: .word	0	; first location of shift table
*;
*;  RAM Location # 039
	.word	0
*;
*;  RAM Location # 040
	.word	0
*;
*;  RAM Location # 041
	.word	0
*;
*;  RAM Location # 042
	.word	0
*;
*;  RAM Location # 043
	.word	0
*;
*;  RAM Location # 044
	.word	0
*;
*;  RAM Location # 045
	.word	0
*;
*;  RAM Location # 046
	.word	0
*;
*;  RAM Location # 047
	.word	0
*;
*;  RAM Location # 048
	.word	0
*;
*;  RAM Location # 049
	.word	0
*;
*;  RAM Location # 050
PTCNS1: .space	0*16
	.word	0
*;
*;  RAM Location # 051
	.word	0
*;
*;  RAM Location # 052
EIGHT:	.word	0
*;
*;  RAM Location # 053
	.word	0
*;
*;  RAM Location # 054
	.word	0
*;
*;  RAM Location # 055
	.word	0
*;
*;  RAM Location # 056
	.word	0
*;
*;  RAM Location # 057
	.word	0
*;
*;  RAM Location # 058
	.word	0
*;
*;  RAM Location # 059
	.word	0
*;
*;  RAM Location # 060
	.word	0
*;
*;  RAM Location # 061
	.word	0
*;
*;  RAM Location # 062
	.word	0
*;
*;  RAM Location # 063
	.word	0
*;
*;  RAM Location # 064
MINUS:	.word	0
*;
*;  RAM Location # 065
	.word	0
*;
*;  RAM Location # 066
	.word	0	; last loc of table (38-66)
*;
*;  RAM Location # 067
ONE:	.word	0	; 1
*;
*;  RAM Location # 068
SDQ:	.word	0	; sign DQ(k)
*;
*;  RAM Location # 069
SDQ1:	.word	0	; sign DQ(k-1)
*;
*;  RAM Location # 070
SDQ2:	.word	0	; sign DQ(k-2)
*;
*;  RAM Location # 071
SDQ3:	.word	0	; sign DQ(k-3)
*;
*;  RAM Location # 072
SDQ4:	.word	0	; sign DQ(k-4)
*;
*;  RAM Location # 073
SDQ5:	.word	0	; sign DQ(k-5)
*;
*;  RAM Location # 074
SDQ6:	.word	0	; sign DQ(k-6)
*;
*;  RAM Location # 075
SRMAN:	.word	0	; mantissa of SR
*;
*;  RAM Location # 076
SR1MAN: .word	0	; mantissa of SR1
*;
*;  RAM Location # 077
DQMAN:	.word	0	; mantissa of DQ
*;
*;  RAM Location # 078
DQ1MAN: .word	0	; mantissa of DQ1
*;
*;  RAM Location # 079
DQ2MAN: .word	0	; mantissa of DQ2
*;
*;  RAM Location # 080
DQ3MAN: .word	0	; mantissa of DQ3
*;
*;  RAM Location # 081
DQ4MAN: .word	0	; mantissa of DQ4
*;
*;  RAM Location # 082
DQ5MAN: .word	0	; mantissa of DQ5
*;
*;  RAM Location # 083
KFF00:	.word	0	; >FF00
*;
*;  RAM Location # 084
PK0:	.word	0	; sign of p(k)
*;
*;  RAM Location # 085
PK1:	.word	0	; sign of p(k-1)
*;
*;  RAM Location # 086
PK2:	.word	0	; sign of p(k-2)
*;
*;  RAM Location # 087
K544:	.word	0	; 544
*;
*;  RAM Location # 088
YU:	.word	0	; fast quant scale factor
*;
*;  RAM Location # 089
YLH:	.word	0	; fast quant scale factor (hi word)
*;
*;  RAM Location # 090
THREE:	.word	0	; 3
*;
*;  RAM Location # 091
MFFC0:	.word	0	; -64
*;
*;  RAM Location # 092
M0080:	.word	0	; alaw mask
*;
*;  RAM Location # 093
KFF80:	.word	0	; >FF80
*;
*;  RAM Location # 094
M15:	.word	0	; 15
*;
*;  RAM Location # 095
K63:	.word	0	; 63
*;
*;  RAM Location # 096
M127:	.word	0	; 127
*;
*;  RAM Location # 097
M255:	.word	0
*;
*;  RAM Location # 098
BIAS:	.word	0	; constant for mulaw conversions
*;
*;  RAM Location # 099
BIASA:	.word	0	; 33*128
*;
*;  RAM Location # 100
K56:	.word	0	; 56
*;
*;  RAM Location # 101
K32768: .word	0	; sign bit
*;
*;  RAM Location # 102
M32767: .word	0	; 32767
*;
*;  RAM Location # 103
K46:	.word	0	; 46
*;
*;  RAM Location # 104
K49:	.word	0	; 49
*;
*;  RAM Location # 105
PTCNS2: .space	0*16
K79:	.word	0	; constants used for quantizing table
*;
*;  RAM Location # 106
K95:	.word	0	; constants used for quantizing table
*;
*;  RAM Location # 107
K130:	.word	0	; constants used for quantizing table
*;
*;  RAM Location # 108
K138:	.word	0	; constants used for quantizing table
*;
*;  RAM Location # 109
K2309:	.word	0	; constants used for quantizing table
*;
*;  RAM Location # 110
M4095:	.word	0	; 4095
*;
*;  RAM Location # 111
K16382: .word	0	; +16382
*;
*;  RAM Location # 112
IQ0:	.word	0	; inverse quantizer table entry
*;
*;  RAM Location # 113
WI0:	.word	0	; scale factor multiplier entry
*;
*;  RAM Location # 114
FI0:	.word	0	; rate-of-change function entry
*;
*;  RAM Location # 115
M16382: .word	0	; -16382
*;
*;  RAM Location # 116
IQ1:	.word	0	; inverse quantizer table entry
*;
*;  RAM Location # 117
WI1:	.word	0	; scale factor multiplier entry
*;
*;  RAM Location # 118
FI1:	.word	0	; rate-of-change function entry
*;
*;  RAM Location # 119
K4576:	.word	0	; 4576
*;
*;  RAM Location # 120
IQ2:	.word	0	; inverse quantizer table entry
*;
*;  RAM Location # 121
WI2:	.word	0	; scale factor multiplier entry
*;
*;  RAM Location # 122
FI2:	.word	0	; rate-of-change function entry
*;
*;  RAM Location # 123
K5120:	.word	0	; 5120
*;
*;  RAM Location # 124
IQ3:	.word	0	; inverse quantizer table entry
*;
*;  RAM Location # 125
WI3:	.word	0	; scale factor multiplier entry
*;
*;  RAM Location # 126
FI3:	.word	0	; rate-of-change function entry
*;
*;  RAM Location # 127
SHIFT:	.word	0	; SHIFT table address
*;
*
	.sect	"DORG1"
*;
*;  RAM Location # 128
IQ4:	.word	0	; inverse quantizer table entry
*;
*;  RAM Location # 129
WI4:	.word	0	; scale factor multiplier entry
*;
*;  RAM Location # 130
FI4:	.word	0	; rate-of-change function entry
*;
*;  RAM Location # 131
	.word	0	; dummy
*;
*;  RAM Location # 132
IQ5:	.word	0	; inverse quantizer table entry
*;
*;  RAM Location # 133
WI5:	.word	0	; scale factor multiplier entry
*;
*;  RAM Location # 134
FI5:	.word	0	; rate-of-change function entry
*;
*;  RAM Location # 135
	.word	0	; dummy
*;
*;  RAM Location # 136
IQ6:	.word	0	; inverse quantizer table entry
*;
*;  RAM Location # 137
WI6:	.word	0	; scale factor multiplier entry
*;
*;  RAM Location # 138
FI6:	.word	0	; rate-of-change function entry
*;
*;  RAM Location # 139
	.word	0	; dummy
*;
*;  RAM Location # 140
IQ7:	.word	0	; inverse quantizer table entry
*;
*;  RAM Location # 141
WI7:	.word	0	; scale factor multiplier entry
*;
*;  RAM Location # 142
FI7:	.word	0	; rate-of-change function entry
*;
*;  RAM Location # 143
	.word	0	; dummy
*;
