*;
*;*********************************************************
*; SIGDIF
*;
*; Implements the following modules (per CCITT spec):
*;
*;	DELAY D -- delay of DQ and SR derivatives
*;	FMULT	-- Bn * DQn, An * SRn
*;	DELAY A -- (implicit in use of last frames data)
*;	ACCUM	-- Accumulate partial products for SEZ, SE
*;
*;	LIMA	-- compute AL(k)
*;	MIX	-- compute Y(k)
*;
*;**********************************************************
*;
*; compute SEZ-- partial signal estimate
*;
*;  SEZ(k) = B1(k-1)*DQ(k-1) + ... + B6(k-1)*DQ(k-6)
*;
*;	Multiplies are done in floating pt
*;	  DQ's are stored in f.p. notation
*;	  B's are floated each pass
*;
*;**********************************************************
*; FLOATING POINT MULTIPLY (FMULT)
*;
*;	INPUT:	QUANTIZED DIFFERENCE   -- DQn (DQnEXP/DQnMAN)
*;		PREDICTOR COEFFICIENTS -- Bn
*;
*;	OUTPUT: FILTER TAP OUTPUTS     -- WBn (SUMn)
*;
*;	NOTATION: DQnEXP   -- 4b + offset
*;		  DQnMAN*8 -- 9b magnitude
*;		  Bn	   -- 16b TC (Q14)
*;		  SUMn	   -- 16b TC (Q1)
*;
*;**********************************************************
*;
*;	-1	-1	-1	-1	-1	-1
*; DQ  z       z       z       z       z       z
*; o--->---o--->---o--->---o--->---o--->---o--->---o
*;	   |	   |	   |	   |	   |	   |
*;	   |	   |	   |	   |	   |	   |
*;	   vB1(k)  vB2(k)  vB3(k)  vB4(k)  vB5(k)  vB6(k)
*;	   |	   |	   |	   |	   |	   |
*;	   |	   |	   |	   |	   |	   |
*;	   o--->---o--->---o--->---o--->---o--->---o--->---o
*;	  WB1	  WB2	  WB3	   WB4	  WB5	  WB6	 SEZ
*;
*;**********************************************************
*;
SIGDIF	LAC	B6,14	; compute B6*DQ5
	CALL	FLOAT	; ret/w mantissa in TEMP1; exp in ac
	ADD	DQ5EXP
	SACL	SUM1
	LAR	0,SUM1	; exp of product offset by table add
	LT	DQ5MAN	; scaled up by 2**3
	LAC	THREE,7 ; multiply fudge factor
	MPY	TEMP1
	LTA	*,0	; mult mant, add 48, fetch shift fac
	AND	KFF80
	SACL	TEMP1
	MPY	TEMP1	; apply shift factor = f(exp)
	PAC
	SACH	SUM1,1
	BGEZ	CHK1	; exp >= 26 or exp < 26
RS1	ABS		; make positive before mask
	AND	M32767	; keep lower 15 bits
	SACL	SUM1	; save result
CHK1	ZALS	B6	; check sign of product
	XOR	SDQ6
	AND	K32768
	BZ	POS1
NEG1	ZAC		; negate if necessary
	SUB	SUM1
	SACL	SUM1
POS1	LAC	B5,14	; compute B5*DQ4
	CALL	FLOAT	; ret/w mantissa in TEMP1; exp in ac
	ADD	DQ4EXP
	DMOV	DQ4EXP
	SACL	SUM2
	LAR	0,SUM2	; exp of product offset by table add
	LTD	DQ4MAN	; scaled up by 2**3
	LAC	THREE,7 ; multiply fudge factor
	MPY	TEMP1
	LTA	*,0	; mult mant, add 48, fetch shift fac
	AND	KFF80
	SACL	TEMP1
	MPY	TEMP1	; apply shift factor = f(exp)
	PAC
	SACH	SUM2,1
	BGEZ	CHK2	; exp >= 26 or exp < 26
RS2	ABS
	AND	M32767
	SACL	SUM2
CHK2	ZALS	B5	; check sign of product
	XOR	SDQ5
	AND	K32768
	BZ	POS2
NEG2	ZAC		; negate if necessary
	SUB	SUM2
	SACL	SUM2
POS2	LAC	B4,14	; compute B4*DQ3
	CALL	FLOAT	; ret/w mantissa in TEMP1; exp in ac
	ADD	DQ3EXP
	DMOV	DQ3EXP
	SACL	SUM3
	LAR	0,SUM3	; exp of product offset by table add
	LTD	DQ3MAN	; scaled up by 2**3
	LAC	THREE,7 ; multiply fudge factor
	MPY	TEMP1
	LTA	*,0	; mult mant, add 48, fetch shift fac
	AND	KFF80
	SACL	TEMP1
	MPY	TEMP1	; apply shift factor = f(exp)
	PAC
	SACH	SUM3,1	; exp < 26
	BGEZ	CHK3	; exp >= 26 or exp < 26
RS3	ABS
	AND	M32767
	SACL	SUM3
CHK3	ZALS	B4	; check sign of product
	XOR	SDQ4
	AND	K32768
	BZ	POS3
NEG3	ZAC		; negate if necessary
	SUB	SUM3
	SACL	SUM3
POS3	LAC	B3,14	; compute B3*DQ2
	CALL	FLOAT	; ret/w mantissa in TEMP1; exp in ac
	ADD	DQ2EXP
	DMOV	DQ2EXP
	SACL	SUM4
	LAR	0,SUM4	; exp of product offset by table add
	LTD	DQ2MAN	; scaled up by 2**3
	LAC	THREE,7 ; multiply fudge factor
	MPY	TEMP1
	LTA	*,0	; mult mant, add 48, fetch shift fac
	AND	KFF80
	SACL	TEMP1
	MPY	TEMP1	; apply shift factor = f(exp)
	PAC
	SACH	SUM4,1
	BGEZ	CHK4	; exp >= 26 or exp < 26
RS4	ABS
	AND	M32767
	SACL	SUM4
CHK4	ZALS	B3	; check sign of product
	XOR	SDQ3
	AND	K32768
	BZ	POS4
NEG4	ZAC		; negate if necessary
	SUB	SUM4
	SACL	SUM4
POS4	LAC	B2,14	; compute B2*DQ1
	CALL	FLOAT	; ret/w mantissa in TEMP1; exp in ac
	ADD	DQ1EXP
	DMOV	DQ1EXP
	SACL	SUM5
	LAR	0,SUM5	; exp of product offset by table add
	LTD	DQ1MAN	; scaled up by 2**3
	LAC	THREE,7 ; multiply fudge factor
	MPY	TEMP1
	LTA	*,0	; mult mant, add 48, fetch shift fac
	AND	KFF80
	SACL	TEMP1
	MPY	TEMP1	; apply shift factor = f(exp)
	PAC
	SACH	SUM5,1
	BGEZ	CHK5	; exp >= 26 or exp < 26
RS5	ABS
	AND	M32767
	SACL	SUM5
CHK5	ZALS	B2	; check sign of product
	XOR	SDQ2
	AND	K32768
	BZ	POS5
NEG5	ZAC		; negate if necessary
	SUB	SUM5
	SACL	SUM5
POS5	LAC	B1,14	; compute B1*DQ
	CALL	FLOAT	; ret/w mantissa in TEMP1; exp in accum
	ADD	DQEXP
	DMOV	DQEXP
	SACL	SUM6
	LAR	0,SUM6	; exp of product offset by table addr
	LTD	DQMAN	; scaled up by 2**3
	LAC	THREE,7 ; multiply fudge factor
	MPY	TEMP1
	LTA	*,0	; mult mant, add 48, fetch shift factor
	AND	KFF80
	SACL	TEMP1
	MPY	TEMP1	; apply shift factor = f(exp)
	PAC
	SACH	SUM6,1
	BGEZ	CHK6	; exp >= 26 or exp < 26
RS6	ABS
	AND	M32767
	SACL	SUM6
CHK6	ZALS	B1	; check sign of product
	XOR	SDQ1
	AND	K32768
	BZ	POS6
NEG6	ZAC		; negate if necessary
	SUB	SUM6
	SACL	SUM6
POS6:	.set	$
*;
*;**********************************************************
*;
*; compute SE -- signal estimate
*;
*;  SE = A1(k-1)*SR(k-1) + A2(k-1)*SR(k-1) + SEZ(k)
*;
*;	Multiplies are dONE in floating pt
*;	  SR's are stored in f.p. notation
*;	  A's are floated each pass
*;
*;**********************************************************
*; FLOATING POINT MULTIPLY (FMULT)
*;
*;	INPUT:	RECONSTRUCTED SIGNAL   -- SRn (SRnEXP/SRnMAN)
*;		PREDICTOR COEFFICIENTS -- An
*;
*;	OUTPUT: FILTER TAP OUTPUTS     -- WAn (SUMn+6)
*;
*;	NOTATION: SRnEXP   -- 4b + offset
*;		  SRnMAN*8 -- 9b magnitude
*;		  An	   -- 16b TC (Q14)
*;		  SUMn+6   -- 16b TC (Q1)
*;
*;**********************************************************
*;
*;		    -1	    -1
*;	       SR  z	   z
*;	       o--->---o--->---o
*;		       |       |
*;		       |       |
*;		       vA1(k)  vA2(k)
*;		       |       |
*;		       |       |
*;	       o---<---o---<---o---<---o
*;	       SE     WA1     WA2     SEZ
*;
*;**********************************************************
*;
GETSE	LAC	A2,14	; compute A2*SR1
	CALL	FLOAT	; ret/w mantissa in TEMP1; exp in accum
	ADD	SR1EXP
	SACL	SUM7
	LAR	0,SUM7	; exp of product offset by table addr
	LT	SR1MAN	; scaled up by 2**3
	LAC	THREE,7 ; multiply fudge factor
	MPY	TEMP1
	LTA	*,0	; mult mant, add 48, fetch shift factor
	AND	KFF80
	SACL	TEMP1
	MPY	TEMP1	; apply shift factor = f(exp)
	PAC
	SACH	SUM7,1
	BGEZ	CHK11	; exp >= 26 or exp < 26
RS11	ABS
	AND	M32767
	SACL	SUM7
CHK11	ZALS	A2	; check sign of product
	XOR	SR1
	AND	K32768
	BZ	POS11
NEG11	ZAC		; negate if necessary
	SUB	SUM7
	SACL	SUM7
POS11	LAC	A1,14	; compute A1*SR
	CALL	FLOAT	; ret/w mantissa in TEMP1; exp in accum
	ADD	SREXP
	DMOV	SREXP
	SACL	SUM8
	LAR	0,SUM8	; exp of product offset by table addr
	LTD	SRMAN	; scaled up by 2**3
	LAC	THREE,7 ; multiply fudge factor
	MPY	TEMP1
	LTA	*,0	; mult mant, add 48, fetch shift factor
	AND	KFF80
	SACL	TEMP1
	MPY	TEMP1	; apply shift factor = f(exp)
	PAC
	SACH	SUM8,1
	BGEZ	CHK21	; exp >= 26 or exp < 26
RS21	ABS
	AND	M32767
	SACL	SUM8
CHK21	DMOV	SR
	ZALS	SR	; check sign of product
	XOR	A1
	AND	K32768
	BZ	POS21
NEG21	ZAC		; negate if necessary
	SUB	SUM8
	SACL	SUM8
POS21:	.set	$
*;
*;**********************************************************
*; ACCUMULATE FILTER TAP OUTPUTS (ACCUM)
*;
*;	INPUT:	FILTER TAP OUTPUTS -- WAn & WBn (SUMm)
*;
*;	OUTPUT: PARTIAL SUM OF ZEROES FILTER -- SEZ
*;		SIGNAL ESTIMATE 	     -- SE
*;
*;	NOTATION: SUMm -- 16b TC (Q1)
*;		  SEZ  -- 15b TC (Q0) [sign extended]
*;		  SE   -- 15b TC (Q0) [sign extended]
*;
*;**********************************************************
*;
	LAC	SUM6,15 ; accumulate products
	ADD	SUM5,15
	ADD	SUM4,15
	ADD	SUM3,15
	ADD	SUM2,15
	ADD	SUM1,15
	SACH	SEZ,1
	ADD	SUM7,15
	ADD	SUM8,15
	SACH	SE,1
	LAC	SE,15
	SACH	SE
*;
*;**********************************************************
*; limit speed control parameter: AL <= 1.0
*;
*;	AL = 1		if APP >  1
*;	AL = APP	if APP <= 1
*;
*;	INPUT:	UNLIMITED SPEED CONTROL -- AP (APP)
*;
*;	OUTPUT: LIMITED SPEED CONTROL -- AL
*;
*;	NOTATION:  APP -- unsigned 10b (Q8)
*;		   AL  -- unsigned  7b (Q6)
*;
*;**********************************************************
*;
LIMA	LAC	ONE,12
	SACL	AL
	LAC	APP		; check if APP >=1
	SUB	ONE,8
	BGEZ	MIX		;APP >= 1
	LAC	APP,4
	AND	MFFC0
	SACL	AL		;APP  < 1
*;
*;**********************************************************
*; MIX
*; form linear combination of fast and slow scale factors
*;
*;	Y(k) = (1-AL(k))*YL(k-1) + AL(k)*YU(k-1)
*;
*;	INPUT:	SLOW QUANTIZER SCALE FACTOR -- YL (YLL/YLH)
*;		FAST QUANTIZER SCALE FACTOR -- YU
*;		LIMITED SPEED CONTROL	    -- AL
*;
*;	OUTPUT: QUANTIZER SCALE FACTOR		-- Y
*;		RESCALED QUANTIZER SCALE FACTOR -- YOVER4
*;
*;	NOTATION: YL	 -- 19b unsigned (Q15)
*;			  stored as:
*;			     low  6b -- YLL
*;			     hi  13b -- YLH
*;		  YU	 -- 13b unsigned (Q9)
*;		  AL	 -- 7b unsigned  (Q6)
*;		  Y	 -- 13b unsigned (Q9)
*;		  YOVER4 -- 11b unsigned (Q7)
*;
*;**********************************************************
*;
MIX	LAC	YU
	SUB	YLH		; YU-(YL>>6)
	SACL	TEMP1
	LT	AL
	MPY	TEMP1		; AL*(YU-(YL>>6))
	PAC
	BGEZ	NONNEG		; negative truncation
	ADD	M4095
NONNEG	ADD	YLH,12
	SACH	Y,4
	LAC	Y,14		; compute and save y>>2
	SACH	YOVER4
	RET			; ret from SIGDIF
	.page
