	.page
*;**************************************************
*; now execute receive code
*;**************************************************
*;
GET32K	IN	RI,IN32K	; read 4-bit sample
*;
*;**************************************************
*; RECEIVER SUBROUTINES
*;**************************************************
*; COMPUTE SCALE FACTOR AND  BOTH PARTIAL AND FULL
*; SIGNAL ESTIMATE FROM PREVIOUS SAMPLES DATA --
*; THEN COMPUTE DIFFERENCE SIGNAL
*;**************************************************
*;
*; compute SEZ-- partial signal estimate
*;
*;  RSEZ(k) = RB1(k-1)*RDQ(k-1) + ... + RB6(k-1)*RDQ(k-6)
*;
SEZSEY	ZAC
	LT	RDQ5
	MPY	RB6
	LTD	RDQ4
	MPY	RB5
	LTD	RDQ3
	MPY	RB4
	LTD	RDQ2
	MPY	RB3
	LTD	RDQ1
	MPY	RB2
	LTD	RDQ
	MPY	RB1
	APAC
*;
*; shift left by 1 to adjust decimal point
*;
	SACL	TEMP1
	SACH	TEMP2
	ADDH	TEMP2
	ADDS	TEMP1
	SACH	RSEZ,1
*;
*; now compute signal estimate as
*;
*;  RA1(k-1)*RSR(k-1) + RA2(k-1)*RSR(k-1) + RSEZ(k)
*;
RGETSE	LAC	RSEZ,14
	LT	RSR1
	MPY	RA2
	LTD	RSR
	MPY	RA1
	APAC
*;
*; shift left by 1 to adjust decimal point
*;
	SACL	TEMP1
	SACH	TEMP2
	ADDH	TEMP2
	ADDS	TEMP1
	SACH	RSE,1
*;
*; limit speed control parameter: AL===> 1.Q6
*;
*; RAPP : 2.Q8
*;
*;	RAL = 1 (64)	  if RAPP >  1
*;	RAL = RAPP	  if RAPP <= 1
*;
RLIMA	LAC	ONE,6
	SACL	RAL
	LAC	RAPP
	SUB	ONE,8
	BGEZ	RMIX		;RAPP >= 256
	LAC	RAPP,14
	SACH	RAL		;RAPP  < 256
*;
*; form linear combination of fast and slow scale factors
*;
*; RY(k) = (1-RAL(k))*RYL(k-1) + RAL(k)*RYU(k-1)
*;
RMIX	LAC	RYLL,10 	; shift yl right by 6
	SACH	TEMP3
	LAC	TEMP3
	AND	M1023
	ADD	RYLH,10
	SACL	TEMP3		; low half
	LAC	RYU
	SUB	TEMP3		; RYU-(RYLL>>6)
	SACL	TEMP3
	ZALH	RYLH
	ADDS	RYLL
	LT	RAL
	MPY	TEMP3
	APAC	;; RYL + RAL*(RYU-(RYLL>>6))
	SACL	TEMP3
	SACH	TEMP2
	LAC	TEMP3,10	; shift right by 6
	SACH	TEMP3
	LAC	TEMP3
	AND	M1023		; mask sign extension
	ADD	TEMP2,10
	AND	M8191
	SACL	RY
	LAC	RY,14
	SACH	TEMP3
*;
*;**********************************************************
*; INVERSE ADAPTIVE QUANTIZER
*;
*;	input:	4b quantized samples	-- RI
*;		scale factor (QADAPT)	-- RY
*;	output: reconstructed diff sig	-- RDQ
*;**********************************************************
*;
*; first convert received nibble back to log domain
*;
RIAQUA	LACK	7
	AND	RI
	SACL	RIM
	LAC	RI
	SUB	ONE,3
	BLZ	POSRI
	LACK	7
	XOR	RIM
	SACL	RIM
POSRI	LAC	RIM
	ADD	INQTAB	; reconst table
	TBLR	TEMP1
*;
*; add back scale factor
*;
RADDA	LAC	TEMP1
	ADD	TEMP3	; Y >> 2
	AND	M2047
	SACL	TEMP2
*;
*; now covert to linear domain
*;
RALOG	LAC	TEMP2,9 	; extract exp
	SACH	TEMP1
	LACK	127
	AND	TEMP2
	ADD	ONE,7		; 1+x
	SACL	TEMP2		; extract mantissa
	LT	TEMP2		; prepare to shift
	LAC	TEMP1
	ADD	SHIFT		; ptr to table of multipliers
	TBLR	TEMP3
	MPY	TEMP3		; integer multiply
	PAC
	BLZ	RLEFTS
	SACH	RDQ,1		; dqmag
	B	RADDSG
RLEFTS	ABS
	SACL	RDQ		; dqmag
RADDSG	LAC	ONE,11
	SACL	RSDQ
	LAC	RI		; check sign
	SUB	ONE,3
	BLZ	RQSFA
	ZAC
	SUB	RDQ
	SACL	RDQ
	LAC	MINUS,11
	SACL	RSDQ
*;
*;********************************************************
*; QUANTIZER SCALE FACTOR ADAPTATION
*;
*;	input:	  RI : 32KB coded samples
*;	output: RYU,RYLL: next sample scale factor
*;********************************************************
*; First compute WI
*;
*;	input --RIM
*;	output--TEMP1 (WI)
*;
RQSFA	LAC	WITAB		; get table address and offset
	ADD	RIM
	TBLR	TEMP1		; lookup WI (Q6)
*;
*; Update fast adaptation scale factor -- constant=1/32
*;
*;   RYU(k)=(1-2**-5)*Y(k)+(2**-5)*WI(k)
*;
*;	input --TEMP1  (WI--- TC   6...Q4)
*;	output--RYU    (RYU---SM    3...-9)
*;
RFILTD	LAC	RY,12		; RY	(Q21)
	SUB	RY,7		; RY/32 (Q21)
	ADD	TEMP1,12	; WI/32 (Q21)
	SACH	RYU,4		; RYU	(Q9)
	LAC	RYU
	AND	M8191
	SACL	RYU
*;
*; limit quant scale factor 1.06 <= RYU <= 10.0 : 9 CLOCKS
*;
*;	input: RYU	(3...-9)
*;	ouput: RYU
*;
RLIMB	SUB	K544		; check lo threshold
	BGEZ	RCHKHI
	LAC	K544
	B	RSTRLI		; go store limited value
RCHKHI	SUB	K4576		; check hi threshold
	BLEZ	RFILTE		; within limits--continue
	LAC	K5120
RSTRLI	SACL	RYU
*;
*; Update slow adaptation scale factor -- constant = 1/64 : 28 CLOCKS
*;
*; RYL = (1-2**-6)*RYL + 2**-6 * RYU
*;
RFILTE	LAC	RYLH,6		; shift ryl left by 6
	SACL	TEMP1
	LAC	RYLL,6
	SACL	TEMP2
	SACH	TEMP3
	LAC	TEMP3		; suppress sign extension
	AND	M63
	SACL	TEMP3
	ZALH	TEMP1
	ADDH	TEMP3
	ADDS	TEMP2
	SUBH	RYLH
	SUBS	RYLL
	ADD	RYU,6
	SACL	TEMP1
	SACH	TEMP2		; result = yl (shifted left by 6)
	LAC	TEMP1,10	; shift result right 6 --> 4.q15
	SACH	TEMP1
	LAC	TEMP1
	AND	M1023		; mask sign extension
	ADD	TEMP2,10
	SACL	RYLL
	SACH	RYLH
	LACK	7		; mask upper 13 bits
	AND	RYLH
	SACL	RYLH
*;
*;*******************************************************
*; ADAPTATION SPEED CONTROL
*;
*;	input:	RIM
*;	output: RAPP
*;*******************************************************
*;
*; first compute FI function
*;
RSPDCR	LAC	FITAB	; look-up value of FI function
	ADD	RIM
	TBLR	TEMP1	; FI*16
*;
*; now update short term average of FI
*;
*; RDMS(k) = (1-2**-5)*RDMS(k-1) + 2**-5 * FI(k)
*;
RFILTA	LAC	TEMP1,15	; FI/32 in q24
	ADD	RDMS,15
	SUB	RDMS,10 	; RDMS/32
	SACH	RDMS,1
*;
*; update long term average of FI
*;
*; RDML(k) = (1-2**-7)*RDML(k-1) + 2**-7 * FI(k)
*;
RFILTB	LAC	TEMP1,15	; FI/128 in q26
	ADD	RDML,15
	SUB	RDML,8		; RDML/128
	SACH	RDML,1
*;
*; Compute mag of diff of short and long term functions
*; of quantizer output sequence and perform threshold
*; comparison to compute speed control parameter--low-pass
*; result.
*;
*; RAPP(k) = (1-2**-4)*RAPP(k-1) + 2**-3 , if ry < 3 or
*;		if |RDMS-RDML| > 2**-3 * RDML
*; else
*;
*; RAPP(k) = (1-2**-4)*RAPP(k-1)
*;
RFILTC ZALH	RAPP
	SUB	RAPP,12
	SACH	RAPP
	LAC	RY
	SUB	THREE,9
	BLZ	RADD18
	ZALH	RDMS		; RDMS (Q25)
	SUB	RDML,14 	; RDMS-RDML
	ABS
	SUB	RDML,11
	BLZ	RAPRED
RADD18	LAC	RAPP
	ADD	ONE,5
	SACL	RAPP		; 1/8 in Q8
*;
*;*************************************************
*; ADAPTIVE PREDICTOR: compute signal estimate
*;
*;	input:	RDQ	quantized difference
*;	output: RSE	signal estimate
*;*************************************************
*;
*; compute reconstructed signal:  DQ + SE
*;
RAPRED	LAC	RDQ
	ADD	RSE
	SACL	RSR
*;
*; compute coefficients of 6th order predictor
*;
*; RBi(k) = (1-2**-8)*RBi(k-1)
*;	     + 2**-7 * SGN[RDQ(k)] * SGN[RDQ(k-1)]
*;
*;     for i = 1...6
*;     and RBi is implicitly limited to +/- 2
*;
RGETB6	LT	RSDQ6
	LAC	RB6,15	; Q29
	SUB	RB6,7	; RB6 * 2**-7  (Q29)
	MPY	RSDQ	; SGN(RSDQ)*SGN(RSDQ6) * 2**-7	(Q29)
	LTD	RSDQ5
	SACH	RB6,1	; 1.Q14
RGETB5	LAC	RB5,15
	SUB	RB5,7
	MPY	RSDQ
	LTD	RSDQ4
	SACH	RB5,1
RGETB4	LAC	RB4,15
	SUB	RB4,7
	MPY	RSDQ
	LTD	RSDQ3
	SACH	RB4,1
RGETB3	LAC	RB3,15
	SUB	RB3,7
	MPY	RSDQ
	LTD	RSDQ2
	SACH	RB3,1
RGETB2	LAC	RB2,15
	SUB	RB2,7
	MPY	RSDQ
	LTD	RSDQ1
	SACH	RB2,1
RGETB1	LAC	RB1,15
	SUB	RB1,7
	MPY	RSDQ
	LTD	RSDQ
	SACH	RB1,1
*;
*; Update coefficients of 2nd order predictor
*;
*; First get sign of sum of quantized diff and
*; partial sig estimate
*;
RADDC	DMOV	RPK1		; RPK1==>RPK2
	DMOV	RPK0		; RPK0==>RPK1
	LAC	ONE,9
	SACL	RPK0
	LAC	RSEZ
	ADD	RDQ
	BGEZ	RSUMGT		; is RSEZ+RDQ negative?
	LAC	MINUS,9
	SACL	RPK0
RSUMGT	LT	RPK0
*;
*;  now calculate f[RA1(k-1)]  ==> TEMP3 will get 1/2 F
*;
*;	  = 4*RA1	if |RA1|  <= 1/2
*;	  = 2*SGN(RA1)	if |RA1|  >  1/2
*;
RGETF	LAC	RA1,1		; 2*RA1
	SACL	TEMP3
	BLZ	RGETF2
RGETF1	SUB	ONE,14
	BLZ	RGETA1
	LAC	ONE,14
	B	RDONEF
RGETF2	ABS
	SUB	ONE,14
	BLZ	RGETA1
	LAC	MINUS,14
RDONEF	SACL	TEMP3
*;
*;  A1(k) = (1-2**-8)*A1(k-1)
*;	    + (3*2**-8)*SGN[p(k)]*SGN[p(k-1)]
*;
RGETA1	LAC	RA1,12
	SUB	RA1,4
	MPY	RPK1		; 3*SGN[rp(k-1)*SGN[rp(k)]
	APAC
	APAC
	APAC
	SACH	RA1,4
	PAC	;; save sign of SGN[rp(k-1)]*SGN[rp(k)]
*;
*; RA2(k) = (1-2**-7)*RA2(k-1)
*;	     + (2**-7)*{SGN[rp(k)]*SGN[(rp(k-2)]
*;	     - f[RA1(k-1)]*SGN[rp(k)]*SGN[rp(k-1)]}
*;
RGETA2	BGEZ	RSUBF		; if sign + --> subtract F
	ZAC	;;  else negate F and subtract
	SUB	TEMP3
	SACL	TEMP3
*;
RSUBF	LAC	RA2,12
	SUB	RA2,5
	MPY	RPK2
	APAC
	APAC
	SUB	TEMP3,6
	SACH	RA2,4
*;
*; now limit RA2 to +/- .75 and prevent overflow
*;
RLIMC	LAC	RA2
	ABS
	SUB	THREE,12	; |value| must be < .75
	BLEZ	RLIMD
	LAC	RA2
	BGEZ	RSATPO
RSATNE	LAC	MINUS3,12
	B	RDONEC
RSATPO	LAC	THREE,12
RDONEC	SACL	RA2
*;
*; limit RA1 to +/-  1-2**-4 - RA2
*;
RLIMD	LAC	M15,10
	SUB	RA2
	SACL	TEMP1		; 1-2**-4-RA2
	LAC	RA1
	ABS
	SUB	TEMP1
	BLEZ	GETSR		; RA1 <= LIMIT
	LAC	RA1
	BGEZ	RA1LIM
	ZAC
	SUB	TEMP1
	SACL	TEMP1
RA1LIM	LAC	TEMP1
	SACL	RA1
*;
*; now convert linear output sample to mu-law PCM
*;
GETSR	LAC	RSR		; get reconstructed signal
	SACL	SAMPLE		; save for output
*;
SKIP1	ZAC	;; Assume positive input
	SACL	SCRACH
	LAC	SAMPLE		; Load as is
*;
*;	Check for sign and taking absolute value
*;
	BGEZ	SAT		;Branch if number is positive
	ABS	;;Take absolute value of Sample
	SACL	SAMPLE		;Store absolute value in Sample
	LACK	128		;Negative value handling
	SACL	SCRACH
	LAC	SAMPLE
*;
SAT	SUB	T9		; Sample - T9 to check for saturation
	BLEZ	BYPASS		; Branch to Bypass for non-saturation
	LACK	127
	SACL	SAMPLE
	B	STEP		; Saturation handling complete
*;
BYPASS	LAC	SAMPLE		; Reset accumulator with absolute value
	SUB	ONE,2		;Subtract T1 =4 from Sample
	BLZ	DONE		;Codec value at sign is the final value
*;
TT5	LAC	SAMPLE		;Load absolute value back into accum.
	SUB	T5		;Sample - T5
	BLZ	BOT		;Bottom half of the mu-law curve
*;
TT7	SUB	ONE,12		; Sample-T7 = Sample -T5 -(T7-T6) -
	SUB	ONE,11		; (T6-T5)
	BLZ	TT6		;Branch to compare with T6
*;
TT8	SUB	ONE,13		; Sample-T8 = Sample -T7 -(T8-T7)
	BLZ	SEG7		;7-th Segment identified
*;
	SACL	SAMPLE
	LAC	SAMPLE,6
	SACH	SAMPLE
	LACK	112		; Segment = 8
	ADD	SAMPLE
	SACL	SAMPLE
	B	STEP		;Branch to stepcode computation
*;
SEG7	ADD	ONE,13		; Sample-T7 = Sample-T8 +(T8-T7)
	SACL	SAMPLE
	LAC	SAMPLE,7
	SACH	SAMPLE
	LACK	96		; Segment = 7
	ADD	SAMPLE
	SACL	SAMPLE
	B	STEP		;Branch to step code computation
*;
TT6	ADD	ONE,12		; Sample - T6 = Sample -T7+(T7-T6)
	BLZ	SEG5		;5-th segment identified
*;
	SACL	SAMPLE
	LAC	SAMPLE,8
	SACH	SAMPLE
	LACK	80		; Segment = 6
	ADD	SAMPLE
	SACL	SAMPLE
	B	STEP		;Branch to step code computation
*;
SEG5	ADD	ONE,11		; Sample - T5 = Sample -T6 + (T6-T5)
*;
	SACL	SAMPLE
	LAC	SAMPLE,9
	SACH	SAMPLE
	LACK	64		; Segment = 5
	ADD	SAMPLE
	SACL	SAMPLE
	B	STEP		;Branch to step code computation
*;-------------------------------------------------------------------------
*;	Comparisons for upper half of the curve is complete.  The next
*;	set of comparisons is for searching in the lower half of mu-law curve.
*;-------------------------------------------------------------------------
BOT	ADD	ONE,10		; Sample-T3 = Sample -T5 +(T5-T4) +
	ADD	ONE,9		; (T4-T3)
	BLZ	TT2		;Branch to compare with T2
*;
TT4	SUB	ONE,9		;Sample - T4 = Sample-T3 -(T4-T3)
	BLZ	SEG3		;3-rd Segment identified
*;
	SACL	SAMPLE
	LAC	SAMPLE,10
	SACH	SAMPLE
	LACK	48		; Segment = 4
	ADD	SAMPLE
	SACL	SAMPLE
	B	STEP		;Branch to stepcode computation
*;
SEG3	ADD	ONE,9		; Sample-T3 = Sample-T4 +(T4-T3)
*;
	SACL	SAMPLE
	LAC	SAMPLE,11
	SACH	SAMPLE
	LACK	32		; Segment =3
	ADD	SAMPLE
	SACL	SAMPLE
	B	STEP		;Branch to step code computation
*;
TT2	ADD	ONE,8		;Sample-T2 = Sample-T3 +(T3-T2)
	BLZ	SEG1		;First segment identified
*;
	SACL	SAMPLE
	LAC	SAMPLE,12
	SACH	SAMPLE
	LACK	16		; Segment = 2
	ADD	SAMPLE
	SACL	SAMPLE
	B	STEP		;Branch to step code computation
*;
SEG1	ADD	ONE,7		;Sample -T1 = Sample+(T2+4) -
	SUB	ONE,3		;	(T1 +4) --T1=4,T2=124
*;
	SACL	SAMPLE
	LAC	SAMPLE,13
	SACH	SAMPLE
	LACK	1		; Segment = 1. ADD 1 for Seg1 corrn.
	ADD	SAMPLE
	SACL	SAMPLE
*;
STEP	LAC	SCRACH
	ADD	SAMPLE
	XOR	M255
	SACL	SCRACH
DONE	OUT	SCRACH,DAC
*;*********************************************************
INTRET	EINT
	RET
*;
*;
*;*********************************************************
*; SYSTEM INITIALIZATION
*;*********************************************************
*;
RESET	DINT	;; Disable interrupts
	LDPK	0		; Initialize data page
*;
SETPAC	LARK	0,143
	LARP	0
	ZAC	;; Zero iram
ZRAMA	SACL	*,0,0
	BANZ	ZRAMA
*;
	LACK	1		; Initialize constant ONE
	SACL	ONE
	SUB	ONE,1
	SACL	MINUS		; MINUS
*;
	CALL	INIT1		; initialize CCITT parms
	EINT	;; Enable TMS320 interrupts
WAIT	NOP
	B	WAIT		; Loop to wait for command
*;
	.page
*;
*;********************************************************
*; INITIALIZE 32K CCITT VARIABLES
*;********************************************************
*;
INIT1	LT	ONE
	LACK	3		; 3
	SACL	THREE
	SUB	THREE,1 	; -3
	SACL	MINUS3
*;
	LACK	15		; 15
	SACL	M15
*;
	LACK	63		; 63
	SACL	M63
*;
	LACK	127		; 127
	SACL	M127
	LACK	255
	SACL	M255
	LAC	ONE,9		; 544
	ADD	ONE,5
	SACL	K544
*;
	LAC	ONE,10		; 1023
	SUB	ONE
	SACL	M1023
*;
	LAC	ONE,12		; 4096
	ADD	ONE,10		; + 1024 = 5120  (hi limit for LIMB)
	SACL	K5120
	SUB	K544		; 4576
	SACL	K4576
*;
	LAC	ONE,11		; 2047
	SUB	ONE
	SACL	M2047
	ADD	ONE,11		; 4095
	SACL	M4095
	ADD	ONE,12		; 8191
	SACL	M8191
	ADD	THREE,13	; 32767
	SACL	M32767
*;
	LAC	ONE,11		; constant for lin/codec conv
	SUB	ONE,7
	SUB	ONE,2
	SACL	T5
*;
	LAC	ONE,15		; constant for lin/codec conv
	SUB	ONE,7
	SUB	ONE,3
	SACL	T9
*;
	MPYK	IQTAB		; Init inverse quant table addr
	PAC
	SACL	INQTAB
*;
	MPYK	SHFT		; Init shift mult table addr
	PAC
	SACL	SHIFT
*;
	MPYK	WTABLE		; Init WI lookup table address
	PAC
	SACL	WITAB
*;
	MPYK	FITABL		; Init FI lookup table address
	PAC
	SACL	FITAB
*;
	MPYK	CODADD		; mu-law coding table
	PAC
	SACL	CODEAD
*;
	MPYK	ITAB4		; constants for QUAN table
	PAC
	SACL	K2309
	LACK	138
	SACL	K138
	LACK	130
	SACL	K130
	LACK	79
	SACL	K79
	LACK	95
	SACL	K95
	LACK	46
	SACL	K46
	LACK	49
	SACL	K49
*;
INIT2	LAC	ONE,9		; 512
	SACL	PK0		; init sign of pk to 1
	SACL	PK1
	SACL	RPK0
	SACL	RPK1
*;
	LAC	K544
	SACL	YU		; initial value
	SACL	RYU
*;
	LAC	ONE,15
	ADD	ONE,11
	SACL	YLL		; initial value
	SACL	RYLL
;
	LAC	ONE,11
	SACL	SDQ1
	SACL	SDQ2
	SACL	SDQ3
	SACL	SDQ4
	SACL	SDQ5
	SACL	SDQ6
	SACL	RSDQ1
	SACL	RSDQ2
	SACL	RSDQ3
	SACL	RSDQ4
	SACL	RSDQ5
	SACL	RSDQ6
*;
	RET
